/*
 * Decompiled with CFR 0.152.
 */
package com.wandoulabs.jodis;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.RetrySleeper;

public class BoundedExponentialBackoffRetryUntilElapsed
implements RetryPolicy {
    private final int baseSleepTimeMs;
    private final int maxSleepTimeMs;
    private final long maxElapsedTimeMs;

    public BoundedExponentialBackoffRetryUntilElapsed(int baseSleepTimeMs, int maxSleepTimeMs, long maxElapsedTimeMs) {
        this.baseSleepTimeMs = baseSleepTimeMs;
        this.maxSleepTimeMs = maxSleepTimeMs;
        this.maxElapsedTimeMs = maxElapsedTimeMs < 0L ? Long.MAX_VALUE : maxElapsedTimeMs;
    }

    private long getSleepTimeMs(int retryCount, long elapsedTimeMs) {
        return Math.min((long)this.maxSleepTimeMs, (long)this.baseSleepTimeMs * (long)Math.max(1, ThreadLocalRandom.current().nextInt(1 << Math.min(30, retryCount + 1))));
    }

    public boolean allowRetry(int retryCount, long elapsedTimeMs, RetrySleeper sleeper) {
        if (elapsedTimeMs >= this.maxElapsedTimeMs) {
            return false;
        }
        long sleepTimeMs = Math.min(this.maxElapsedTimeMs - elapsedTimeMs, this.getSleepTimeMs(retryCount, elapsedTimeMs));
        try {
            sleeper.sleepFor(sleepTimeMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }
}

