/*
 * Decompiled with CFR 0.152.
 */
package com.wandoulabs.jodis;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.wandoulabs.jodis.BoundedExponentialBackoffRetryUntilElapsed;
import com.wandoulabs.jodis.JedisResourcePool;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.log4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisException;

public class RoundRobinJedisPool
implements JedisResourcePool {
    private static final Logger LOG = Logger.getLogger(RoundRobinJedisPool.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String JSON_NAME_CODIS_PROXY_ADDR = "addr";
    private static final String JSON_NAME_CODIS_PROXY_STATE = "state";
    private static final String CODIS_PROXY_STATE_ONLINE = "online";
    private static final int CURATOR_RETRY_BASE_SLEEP_MS = 100;
    private static final int CURATOR_RETRY_MAX_SLEEP_MS = 30000;
    private static final int JEDIS_POOL_TIMEOUT_UNSET = -1;
    private static final ImmutableSet<PathChildrenCacheEvent.Type> RESET_TYPES = Sets.immutableEnumSet((Enum)PathChildrenCacheEvent.Type.CHILD_ADDED, (Enum[])new PathChildrenCacheEvent.Type[]{PathChildrenCacheEvent.Type.CHILD_UPDATED, PathChildrenCacheEvent.Type.CHILD_REMOVED});
    private final CuratorFramework curatorClient;
    private final boolean closeCurator;
    private final PathChildrenCache watcher;
    private volatile ImmutableList<PooledObject> pools = ImmutableList.of();
    private final AtomicInteger nextIdx = new AtomicInteger(-1);
    private final JedisPoolConfig poolConfig;
    private final int timeout;

    public RoundRobinJedisPool(String zkAddr, int zkSessionTimeoutMs, String zkPath, JedisPoolConfig poolConfig) {
        this(zkAddr, zkSessionTimeoutMs, zkPath, poolConfig, -1);
    }

    public RoundRobinJedisPool(String zkAddr, int zkSessionTimeoutMs, String zkPath, JedisPoolConfig poolConfig, int timeout) {
        this(CuratorFrameworkFactory.builder().connectString(zkAddr).sessionTimeoutMs(zkSessionTimeoutMs).retryPolicy((RetryPolicy)new BoundedExponentialBackoffRetryUntilElapsed(100, 30000, -1L)).build(), true, zkPath, poolConfig, timeout);
    }

    public RoundRobinJedisPool(CuratorFramework curatorClient, boolean closeCurator, String zkPath, JedisPoolConfig poolConfig) {
        this(curatorClient, closeCurator, zkPath, poolConfig, -1);
    }

    public RoundRobinJedisPool(CuratorFramework curatorClient, boolean closeCurator, String zkPath, JedisPoolConfig poolConfig, int timeout) {
        this.poolConfig = poolConfig;
        this.timeout = timeout;
        this.curatorClient = curatorClient;
        this.closeCurator = closeCurator;
        this.watcher = new PathChildrenCache(curatorClient, zkPath, true);
        this.watcher.getListenable().addListener((Object)new PathChildrenCacheListener(){

            public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                StringBuilder sb = new StringBuilder("zookeeper event received: type=").append(event.getType());
                if (event.getData() != null) {
                    ChildData data = event.getData();
                    sb.append(", path=").append(data.getPath()).append(", stat=").append(data.getStat());
                }
                LOG.info((Object)sb.toString());
                if (RESET_TYPES.contains((Object)event.getType())) {
                    RoundRobinJedisPool.this.resetPools();
                }
            }
        });
        if (curatorClient.getState() == CuratorFrameworkState.LATENT) {
            curatorClient.start();
        }
        try {
            this.watcher.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
        this.resetPools();
    }

    private void resetPools() {
        ImmutableList<PooledObject> pools = this.pools;
        HashMap addr2Pool = Maps.newHashMapWithExpectedSize((int)pools.size());
        for (PooledObject pool : pools) {
            addr2Pool.put(pool.addr, pool);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ChildData childData : this.watcher.getCurrentData()) {
            try {
                JsonNode proxyInfo = MAPPER.readTree(childData.getData());
                if (!CODIS_PROXY_STATE_ONLINE.equals(proxyInfo.get(JSON_NAME_CODIS_PROXY_STATE).asText())) continue;
                String addr = proxyInfo.get(JSON_NAME_CODIS_PROXY_ADDR).asText();
                PooledObject pool = (PooledObject)addr2Pool.remove(addr);
                if (pool == null) {
                    LOG.info((Object)("Add new proxy: " + addr));
                    String[] hostAndPort = addr.split(":");
                    String host = hostAndPort[0];
                    int port = Integer.parseInt(hostAndPort[1]);
                    pool = this.timeout == -1 ? new PooledObject(addr, new JedisPool((GenericObjectPoolConfig)this.poolConfig, host, port)) : new PooledObject(addr, new JedisPool((GenericObjectPoolConfig)this.poolConfig, host, port, this.timeout));
                }
                builder.add((Object)pool);
            }
            catch (Exception e) {
                LOG.warn((Object)("parse " + childData.getPath() + " failed"), (Throwable)e);
            }
        }
        this.pools = builder.build();
        for (PooledObject pool : addr2Pool.values()) {
            LOG.info((Object)("Remove proxy: " + pool.addr));
            pool.pool.close();
        }
    }

    @Override
    public Jedis getResource() {
        int next;
        int current;
        ImmutableList<PooledObject> pools = this.pools;
        if (pools.isEmpty()) {
            throw new JedisException("Proxy list empty");
        }
        while (!this.nextIdx.compareAndSet(current, next = (current = this.nextIdx.get()) >= pools.size() - 1 ? 0 : current + 1)) {
        }
        return ((PooledObject)pools.get((int)next)).pool.getResource();
    }

    @Override
    public void close() {
        try {
            Closeables.close((Closeable)this.watcher, (boolean)true);
        }
        catch (IOException e) {
            LOG.fatal((Object)"IOException should not have been thrown", (Throwable)e);
        }
        if (this.closeCurator) {
            this.curatorClient.close();
        }
        ImmutableList<PooledObject> pools = this.pools;
        this.pools = ImmutableList.of();
        for (PooledObject pool : pools) {
            pool.pool.close();
        }
    }

    private static final class PooledObject {
        public final String addr;
        public final JedisPool pool;

        public PooledObject(String addr, JedisPool pool) {
            this.addr = addr;
            this.pool = pool;
        }
    }
}

