/*
 * Decompiled with CFR 0.152.
 */
package crawler.open.util;

import com.wandoulabs.jodis.JedisResourcePool;
import com.wandoulabs.jodis.RoundRobinJedisPool;
import crawler.open.util.DateUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisUtil {
    private static Log LOG = LogFactory.getLog(RedisUtil.class);
    private static boolean initFlag = false;
    private static JedisPool singlePool = null;
    private static int s_maxTotal = 200;
    private static int s_maxIdle = 20;
    private static long s_maxWaitMillis = 20000L;
    private static boolean s_testOnBorrow = true;
    private static JedisResourcePool codisPool = null;
    private static final int tryTimes = 3;
    private static final long sleepMs = 1000L;
    private static final String F_MODEL = "redis.model";
    private static final String F_ZK = "redis.zkadress";
    private static final String F_TIMEOUT = "redis.zksessiontimeoutms";
    private static final String F_PROXY = "redis.proxypath";
    private static final String F_IP = "redis.ip";
    private static final String F_PORT = "redis.port";
    private static String model = null;
    private static String zk = null;
    private static int timeout = 30000;
    private static String proxy = null;
    private static String ip = null;
    private static int port = 6379;

    public static boolean init(String configFilePath, Log log) {
        LOG = log;
        return RedisUtil.init(configFilePath);
    }

    public static synchronized boolean init(String configFilePath) {
        if (initFlag) {
            LOG.error((Object)"Error details:repeated initialization");
            return false;
        }
        if (StringUtils.isEmpty((String)configFilePath)) {
            LOG.error((Object)"Error details:configFilePath is empty");
            return false;
        }
        Map<String, String> config = RedisUtil.getProperties(configFilePath);
        if (config == null) {
            LOG.error((Object)"Error details:error in reading file from configFilePath");
            return false;
        }
        if (!config.containsKey(F_MODEL)) {
            LOG.error((Object)"lost field:redis.model");
            return false;
        }
        model = config.get(F_MODEL);
        if ("codis".equalsIgnoreCase(model)) {
            boolean checkFlag = RedisUtil.checkField(config, F_ZK, F_TIMEOUT, F_PROXY);
            if (!checkFlag) {
                return false;
            }
            model = "codis";
            zk = config.get(F_ZK);
            try {
                timeout = Integer.parseInt(config.get(F_TIMEOUT));
            }
            catch (Exception e) {
                LOG.error((Object)("Error details:timeout field need integer,your input is " + config.get(F_TIMEOUT)));
                return false;
            }
            proxy = config.get(F_PROXY);
            boolean successFlag = RedisUtil.initCodisPool();
            if (!successFlag) {
                return successFlag;
            }
        } else if ("single".equalsIgnoreCase(model)) {
            boolean checkFlag = RedisUtil.checkField(config, F_IP, F_PORT);
            if (!checkFlag) {
                return false;
            }
            model = "single";
            ip = config.get(F_IP);
            try {
                port = Integer.parseInt(config.get(F_PORT));
            }
            catch (Exception e) {
                LOG.error((Object)("Error details:port field need integer,your input is " + config.get(F_PORT)));
                return false;
            }
            boolean successFlag = RedisUtil.initSinglePool();
            if (!successFlag) {
                return successFlag;
            }
        }
        initFlag = true;
        return true;
    }

    private static boolean initCodisPool() {
        try {
            codisPool = new RoundRobinJedisPool(zk, timeout, proxy, new JedisPoolConfig());
        }
        catch (Exception e) {
            LOG.error((Object)"Error details:error to create jedispool", (Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean initSinglePool() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(s_maxTotal);
        config.setMaxIdle(s_maxIdle);
        config.setMaxWaitMillis(s_maxWaitMillis);
        config.setTestOnBorrow(s_testOnBorrow);
        try {
            singlePool = new JedisPool((GenericObjectPoolConfig)config, ip, port);
        }
        catch (Exception e) {
            LOG.error((Object)"Error details:error to create jedispool", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean checkField(Map<String, String> config, String ... paramNames) {
        String[] stringArray = paramNames;
        int n = paramNames.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (!config.containsKey(param)) {
                LOG.error((Object)("lost field:" + param));
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static Map<String, String> getProperties(String filePath) {
        Properties properties = new Properties();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(new File(filePath)), "utf8");
            properties.load(reader);
            return new HashMap<Object, Object>(properties);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"Error details:error in read file", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Error details:error in IOException", (Throwable)e);
        }
        return null;
    }

    public static boolean set(String key, String value, int dbIndex) {
        int count = 0;
        Jedis jedis = null;
        while (count++ < 3) {
            try {
                if ("single".equals(model)) {
                    if (singlePool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = singlePool.getResource();
                    jedis.select(dbIndex);
                } else if ("codis".equals(model)) {
                    if (codisPool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = codisPool.getResource();
                } else {
                    LOG.error((Object)("error model,your input is " + model));
                    System.exit(0);
                }
                jedis.set(key, value);
            }
            catch (JedisConnectionException e1) {
                LOG.error((Object)("error to connnect redis:" + e1.getMessage() + ",sleep " + 1000L + " millisecond"));
                DateUtil.sleepLong(1000L);
                try {
                    if ("single".equals(model)) {
                        singlePool.returnResource(jedis);
                        continue;
                    }
                    if (!"codis".equals(model) || jedis == null) continue;
                    jedis.close();
                }
                catch (Exception e2) {
                    LOG.error((Object)"error in return jedis", (Throwable)e2);
                }
                continue;
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"error for redis operation", (Throwable)e);
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if ("single".equals(model)) {
                            singlePool.returnResource(jedis);
                        } else if ("codis".equals(model) && jedis != null) {
                            jedis.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.error((Object)"error in return jedis", (Throwable)e2);
                    }
                }
            }
            try {
                if ("single".equals(model)) {
                    singlePool.returnResource(jedis);
                    break;
                }
                if (!"codis".equals(model) || jedis == null) break;
                jedis.close();
            }
            catch (Exception e2) {
                LOG.error((Object)"error in return jedis", (Throwable)e2);
            }
            break;
        }
        if (count == 3) {
            LOG.error((Object)("redis set operation fail,key is " + key + ",value is " + value));
            return false;
        }
        return true;
    }

    public static String get(String key, int dbIndex) {
        int count = 0;
        String data = null;
        Jedis jedis = null;
        while (count++ < 3) {
            try {
                if ("single".equals(model)) {
                    if (singlePool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = singlePool.getResource();
                    jedis.select(dbIndex);
                } else if ("codis".equals(model)) {
                    if (codisPool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = codisPool.getResource();
                } else {
                    LOG.error((Object)("error model,your input is " + model));
                    System.exit(0);
                }
                data = jedis.get(key);
            }
            catch (JedisConnectionException e1) {
                LOG.error((Object)("error to connnect redis:" + e1.getMessage() + ",sleep " + 1000L + " millisecond"));
                DateUtil.sleepLong(1000L);
                try {
                    if ("single".equals(model)) {
                        singlePool.returnResource(jedis);
                        continue;
                    }
                    if (!"codis".equals(model) || jedis == null) continue;
                    jedis.close();
                }
                catch (Exception e2) {
                    LOG.error((Object)"error in return jedis", (Throwable)e2);
                }
                continue;
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"error for redis operation", (Throwable)e);
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if ("single".equals(model)) {
                            singlePool.returnResource(jedis);
                        } else if ("codis".equals(model) && jedis != null) {
                            jedis.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.error((Object)"error in return jedis", (Throwable)e2);
                    }
                }
            }
            try {
                if ("single".equals(model)) {
                    singlePool.returnResource(jedis);
                    break;
                }
                if (!"codis".equals(model) || jedis == null) break;
                jedis.close();
            }
            catch (Exception e2) {
                LOG.error((Object)"error in return jedis", (Throwable)e2);
            }
            break;
        }
        if (count == 3) {
            LOG.error((Object)("redis get operation fail,key is " + key));
        }
        return data;
    }

    public static boolean del(String key, int dbIndex) {
        int count = 0;
        Jedis jedis = null;
        while (count++ < 3) {
            try {
                if ("single".equals(model)) {
                    if (singlePool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = singlePool.getResource();
                    jedis.select(dbIndex);
                } else if ("codis".equals(model)) {
                    if (codisPool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = codisPool.getResource();
                } else {
                    LOG.error((Object)("error model,your input is " + model));
                    System.exit(0);
                }
                jedis.del(key);
            }
            catch (JedisConnectionException e1) {
                LOG.error((Object)("error to connnect redis:" + e1.getMessage() + ",sleep " + 1000L + " millisecond"));
                DateUtil.sleepLong(1000L);
                try {
                    if ("single".equals(model)) {
                        singlePool.returnResource(jedis);
                        continue;
                    }
                    if (!"codis".equals(model) || jedis == null) continue;
                    jedis.close();
                }
                catch (Exception e2) {
                    LOG.error((Object)"error in return jedis", (Throwable)e2);
                }
                continue;
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"error for redis operation", (Throwable)e);
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if ("single".equals(model)) {
                            singlePool.returnResource(jedis);
                        } else if ("codis".equals(model) && jedis != null) {
                            jedis.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.error((Object)"error in return jedis", (Throwable)e2);
                    }
                }
            }
            try {
                if ("single".equals(model)) {
                    singlePool.returnResource(jedis);
                    break;
                }
                if (!"codis".equals(model) || jedis == null) break;
                jedis.close();
            }
            catch (Exception e2) {
                LOG.error((Object)"error in return jedis", (Throwable)e2);
            }
            break;
        }
        if (count == 3) {
            LOG.error((Object)("redis del operation fail,key is " + key));
            return false;
        }
        return true;
    }

    public static boolean lpush(String key, String value, int dbIndex) {
        int count = 0;
        Jedis jedis = null;
        while (count++ < 3) {
            try {
                if ("single".equals(model)) {
                    if (singlePool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = singlePool.getResource();
                    jedis.select(dbIndex);
                } else if ("codis".equals(model)) {
                    if (codisPool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = codisPool.getResource();
                } else {
                    LOG.error((Object)("error model,your input is " + model));
                    System.exit(0);
                }
                jedis.lpush(key, new String[]{value});
            }
            catch (JedisConnectionException e1) {
                LOG.error((Object)("error to connnect redis:" + e1.getMessage() + ",sleep " + 1000L + " millisecond"));
                DateUtil.sleepLong(1000L);
                try {
                    if ("single".equals(model)) {
                        singlePool.returnResource(jedis);
                        continue;
                    }
                    if (!"codis".equals(model) || jedis == null) continue;
                    jedis.close();
                }
                catch (Exception e2) {
                    LOG.error((Object)"error in return jedis", (Throwable)e2);
                }
                continue;
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"error for redis operation", (Throwable)e);
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if ("single".equals(model)) {
                            singlePool.returnResource(jedis);
                        } else if ("codis".equals(model) && jedis != null) {
                            jedis.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.error((Object)"error in return jedis", (Throwable)e2);
                    }
                }
            }
            try {
                if ("single".equals(model)) {
                    singlePool.returnResource(jedis);
                    break;
                }
                if (!"codis".equals(model) || jedis == null) break;
                jedis.close();
            }
            catch (Exception e2) {
                LOG.error((Object)"error in return jedis", (Throwable)e2);
            }
            break;
        }
        if (count == 3) {
            LOG.error((Object)("redis lpush operation fail,key is " + key + ",value is " + value));
            return false;
        }
        return true;
    }

    public static boolean lpush(String key, String[] values, int dbIndex) {
        int count = 0;
        Jedis jedis = null;
        while (count++ < 3) {
            try {
                if ("single".equals(model)) {
                    if (singlePool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = singlePool.getResource();
                    jedis.select(dbIndex);
                } else if ("codis".equals(model)) {
                    if (codisPool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = codisPool.getResource();
                } else {
                    LOG.error((Object)("error model,your input is " + model));
                    System.exit(0);
                }
                jedis.lpush(key, values);
            }
            catch (JedisConnectionException e1) {
                LOG.error((Object)("error to connnect redis:" + e1.getMessage() + ",sleep " + 1000L + " millisecond"));
                DateUtil.sleepLong(1000L);
                try {
                    if ("single".equals(model)) {
                        singlePool.returnResource(jedis);
                        continue;
                    }
                    if (!"codis".equals(model) || jedis == null) continue;
                    jedis.close();
                }
                catch (Exception e2) {
                    LOG.error((Object)"error in return jedis", (Throwable)e2);
                }
                continue;
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"error for redis operation", (Throwable)e);
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if ("single".equals(model)) {
                            singlePool.returnResource(jedis);
                        } else if ("codis".equals(model) && jedis != null) {
                            jedis.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.error((Object)"error in return jedis", (Throwable)e2);
                    }
                }
            }
            try {
                if ("single".equals(model)) {
                    singlePool.returnResource(jedis);
                    break;
                }
                if (!"codis".equals(model) || jedis == null) break;
                jedis.close();
            }
            catch (Exception e2) {
                LOG.error((Object)"error in return jedis", (Throwable)e2);
            }
            break;
        }
        if (count == 3) {
            LOG.error((Object)("redis lpush operation fail,key is " + key + ",value is " + values));
            return false;
        }
        return true;
    }

    public static boolean rpush(String key, String value, int dbIndex) {
        int count = 0;
        Jedis jedis = null;
        while (count++ < 3) {
            try {
                if ("single".equals(model)) {
                    if (singlePool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = singlePool.getResource();
                    jedis.select(dbIndex);
                } else if ("codis".equals(model)) {
                    if (codisPool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = codisPool.getResource();
                } else {
                    LOG.error((Object)("error model,your input is " + model));
                    System.exit(0);
                }
                jedis.rpush(key, new String[]{value});
            }
            catch (JedisConnectionException e1) {
                LOG.error((Object)("error to connnect redis:" + e1.getMessage() + ",sleep " + 1000L + " millisecond"));
                DateUtil.sleepLong(1000L);
                try {
                    if ("single".equals(model)) {
                        singlePool.returnResource(jedis);
                        continue;
                    }
                    if (!"codis".equals(model) || jedis == null) continue;
                    jedis.close();
                }
                catch (Exception e2) {
                    LOG.error((Object)"error in return jedis", (Throwable)e2);
                }
                continue;
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"error for redis operation", (Throwable)e);
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if ("single".equals(model)) {
                            singlePool.returnResource(jedis);
                        } else if ("codis".equals(model) && jedis != null) {
                            jedis.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.error((Object)"error in return jedis", (Throwable)e2);
                    }
                }
            }
            try {
                if ("single".equals(model)) {
                    singlePool.returnResource(jedis);
                    break;
                }
                if (!"codis".equals(model) || jedis == null) break;
                jedis.close();
            }
            catch (Exception e2) {
                LOG.error((Object)"error in return jedis", (Throwable)e2);
            }
            break;
        }
        if (count == 3) {
            LOG.error((Object)("redis rpush operation fail,key is " + key + ",value is " + value));
            return false;
        }
        return true;
    }

    public static String lpop(String key, int dbIndex) {
        int count = 0;
        String data = null;
        Jedis jedis = null;
        while (count++ < 3) {
            try {
                if ("single".equals(model)) {
                    if (singlePool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = singlePool.getResource();
                    jedis.select(dbIndex);
                } else if ("codis".equals(model)) {
                    if (codisPool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = codisPool.getResource();
                } else {
                    LOG.error((Object)("error model,your input is " + model));
                    System.exit(0);
                }
                data = jedis.lpop(key);
            }
            catch (JedisConnectionException e1) {
                LOG.error((Object)("error to connnect redis:" + e1.getMessage() + ",sleep " + 1000L + " millisecond"));
                DateUtil.sleepLong(1000L);
                try {
                    if ("single".equals(model)) {
                        singlePool.returnResource(jedis);
                        continue;
                    }
                    if (!"codis".equals(model) || jedis == null) continue;
                    jedis.close();
                }
                catch (Exception e2) {
                    LOG.error((Object)"error in return jedis", (Throwable)e2);
                }
                continue;
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"error for redis operation", (Throwable)e);
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if ("single".equals(model)) {
                            singlePool.returnResource(jedis);
                        } else if ("codis".equals(model) && jedis != null) {
                            jedis.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.error((Object)"error in return jedis", (Throwable)e2);
                    }
                }
            }
            try {
                if ("single".equals(model)) {
                    singlePool.returnResource(jedis);
                    break;
                }
                if (!"codis".equals(model) || jedis == null) break;
                jedis.close();
            }
            catch (Exception e2) {
                LOG.error((Object)"error in return jedis", (Throwable)e2);
            }
            break;
        }
        if (count == 3) {
            LOG.error((Object)("redis lpop operation fail,key is " + key));
        }
        return data;
    }

    public static String rpop(String key, int dbIndex) {
        int count = 0;
        String data = null;
        Jedis jedis = null;
        while (count++ < 3) {
            try {
                if ("single".equals(model)) {
                    if (singlePool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = singlePool.getResource();
                    jedis.select(dbIndex);
                } else if ("codis".equals(model)) {
                    if (codisPool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = codisPool.getResource();
                } else {
                    LOG.error((Object)("error model,your input is " + model));
                    System.exit(0);
                }
                data = jedis.rpop(key);
            }
            catch (JedisConnectionException e1) {
                LOG.error((Object)("error to connnect redis:" + e1.getMessage() + ",sleep " + 1000L + " millisecond"));
                DateUtil.sleepLong(1000L);
                try {
                    if ("single".equals(model)) {
                        singlePool.returnResource(jedis);
                        continue;
                    }
                    if (!"codis".equals(model) || jedis == null) continue;
                    jedis.close();
                }
                catch (Exception e2) {
                    LOG.error((Object)"error in return jedis", (Throwable)e2);
                }
                continue;
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"error for redis operation", (Throwable)e);
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if ("single".equals(model)) {
                            singlePool.returnResource(jedis);
                        } else if ("codis".equals(model) && jedis != null) {
                            jedis.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.error((Object)"error in return jedis", (Throwable)e2);
                    }
                }
            }
            try {
                if ("single".equals(model)) {
                    singlePool.returnResource(jedis);
                    break;
                }
                if (!"codis".equals(model) || jedis == null) break;
                jedis.close();
            }
            catch (Exception e2) {
                LOG.error((Object)"error in return jedis", (Throwable)e2);
            }
            break;
        }
        if (count == 3) {
            LOG.error((Object)("redis rpop operation fail,key is " + key));
        }
        return data;
    }

    public static long llen(String key, int dbIndex) {
        int count = 0;
        long data = -1L;
        Jedis jedis = null;
        while (count++ < 3) {
            try {
                if ("single".equals(model)) {
                    if (singlePool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = singlePool.getResource();
                    jedis.select(dbIndex);
                } else if ("codis".equals(model)) {
                    if (codisPool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = codisPool.getResource();
                } else {
                    LOG.error((Object)("error model,your input is " + model));
                    System.exit(0);
                }
                data = jedis.llen(key);
            }
            catch (JedisConnectionException e1) {
                LOG.error((Object)("error to connnect redis:" + e1.getMessage() + ",sleep " + 1000L + " millisecond"));
                DateUtil.sleepLong(1000L);
                try {
                    if ("single".equals(model)) {
                        singlePool.returnResource(jedis);
                        continue;
                    }
                    if (!"codis".equals(model) || jedis == null) continue;
                    jedis.close();
                }
                catch (Exception e2) {
                    LOG.error((Object)"error in return jedis", (Throwable)e2);
                }
                continue;
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"error for redis operation", (Throwable)e);
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if ("single".equals(model)) {
                            singlePool.returnResource(jedis);
                        } else if ("codis".equals(model) && jedis != null) {
                            jedis.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.error((Object)"error in return jedis", (Throwable)e2);
                    }
                }
            }
            try {
                if ("single".equals(model)) {
                    singlePool.returnResource(jedis);
                    break;
                }
                if (!"codis".equals(model) || jedis == null) break;
                jedis.close();
            }
            catch (Exception e2) {
                LOG.error((Object)"error in return jedis", (Throwable)e2);
            }
            break;
        }
        if (count == 3) {
            LOG.error((Object)("redis llen operation fail,key is " + key));
        }
        return data;
    }

    public static List<String> lrange(String key, long startIndex, long endIndex, int dbIndex) {
        int count = 0;
        List<String> data = new ArrayList<String>();
        Jedis jedis = null;
        while (count++ < 3) {
            try {
                if ("single".equals(model)) {
                    if (singlePool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = singlePool.getResource();
                    jedis.select(dbIndex);
                } else if ("codis".equals(model)) {
                    if (codisPool == null) {
                        LOG.error((Object)"redis pool is null,please init before using");
                        System.exit(0);
                    }
                    jedis = codisPool.getResource();
                } else {
                    LOG.error((Object)("error model,your input is " + model));
                    System.exit(0);
                }
                data = jedis.lrange(key, startIndex, endIndex);
            }
            catch (JedisConnectionException e1) {
                LOG.error((Object)("error to connnect redis:" + e1.getMessage() + ",sleep " + 1000L + " millisecond"));
                DateUtil.sleepLong(1000L);
                try {
                    if ("single".equals(model)) {
                        singlePool.returnResource(jedis);
                        continue;
                    }
                    if (!"codis".equals(model) || jedis == null) continue;
                    jedis.close();
                }
                catch (Exception e2) {
                    LOG.error((Object)"error in return jedis", (Throwable)e2);
                }
                continue;
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)"error for redis operation", (Throwable)e);
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if ("single".equals(model)) {
                            singlePool.returnResource(jedis);
                        } else if ("codis".equals(model) && jedis != null) {
                            jedis.close();
                        }
                    }
                    catch (Exception e2) {
                        LOG.error((Object)"error in return jedis", (Throwable)e2);
                    }
                }
            }
            try {
                if ("single".equals(model)) {
                    singlePool.returnResource(jedis);
                    break;
                }
                if (!"codis".equals(model) || jedis == null) break;
                jedis.close();
            }
            catch (Exception e2) {
                LOG.error((Object)"error in return jedis", (Throwable)e2);
            }
            break;
        }
        if (count == 3) {
            LOG.error((Object)("redis lrange operation fail,key is " + key + ",start is " + startIndex + ",end is " + endIndex));
        }
        return data;
    }

    public static void main(String[] args) {
        String path = "F:\\crawl2.1_develop\\etc\\redis.properties";
        boolean a = RedisUtil.init(path);
        System.out.println(a);
        RedisUtil.set("testkey", "test is ok", 7);
        System.out.println(RedisUtil.get("testkey", 7));
        RedisUtil.del("testkey", 7);
    }
}

