/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.util;

import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.NodeHelper;
import org.dom4j.QName;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.LazyList;
import org.dom4j.util.DoubleNameMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedElement
extends DefaultElement {
    private DoubleNameMap<List<Element>> elementIndex;
    private DoubleNameMap<Attribute> attributeIndex;

    public IndexedElement(String name) {
        super(name);
    }

    public IndexedElement(QName qname) {
        super(qname);
    }

    public IndexedElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    public Attribute attribute(String name) {
        return this.attributeIndex().get(name);
    }

    @Override
    public Attribute attribute(QName qName) {
        return this.attributeIndex().get(qName);
    }

    @Override
    public Element element(String name) {
        return IndexedElement.firstElement(this.elementIndex().get(name));
    }

    @Override
    public Element element(QName qName) {
        return IndexedElement.firstElement(this.elementIndex().get(qName));
    }

    @Override
    public List<Element> elements(String name) {
        return this.asElementList(this.elementIndex().get(name));
    }

    @Override
    public List<Element> elements(QName qName) {
        return this.asElementList(this.elementIndex().get(qName));
    }

    protected static Element firstElement(List<Element> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    protected List<Element> asElementList(List<Element> list) {
        BackedList<Element> answer = this.createResultList();
        for (Element element : list) {
            answer.addLocal(element);
        }
        return answer;
    }

    @Override
    protected void addNode(Node node) {
        super.addNode(node);
        switch (node.getNodeTypeEnum()) {
            case ELEMENT_NODE: {
                if (this.elementIndex == null) break;
                this.addToElementIndex((Element)node);
                break;
            }
            case ATTRIBUTE_NODE: {
                if (this.attributeIndex == null) break;
                this.addToAttributeIndex((Attribute)node);
            }
        }
    }

    @Override
    protected boolean removeNode(Node node) {
        if (super.removeNode(node)) {
            switch (node.getNodeTypeEnum()) {
                case ELEMENT_NODE: {
                    if (this.elementIndex == null) break;
                    this.removeFromElementIndex((Element)node);
                    break;
                }
                case ATTRIBUTE_NODE: {
                    if (this.attributeIndex == null) break;
                    this.removeFromAttributeIndex((Attribute)node);
                }
            }
            return true;
        }
        return false;
    }

    protected DoubleNameMap<Attribute> attributeIndex() {
        if (this.attributeIndex == null) {
            this.attributeIndex = new DoubleNameMap();
            for (Attribute attribute : this.attributeList()) {
                this.addToAttributeIndex(attribute);
            }
        }
        return this.attributeIndex;
    }

    protected DoubleNameMap<List<Element>> elementIndex() {
        if (this.elementIndex == null) {
            this.elementIndex = new DoubleNameMap();
            for (Node node : this.contentList()) {
                Element element = NodeHelper.nodeAsElement(node);
                if (element == null) continue;
                this.addToElementIndex(element);
            }
        }
        return this.elementIndex;
    }

    protected void addToElementIndex(Element element) {
        QName qName = element.getQName();
        List<Element> list = this.elementIndex.get(qName);
        if (list == null) {
            list = new LazyList<Element>();
            this.elementIndex.put(qName, list);
        }
        list.add(element);
    }

    protected void removeFromElementIndex(Element element) {
        QName qName = element.getQName();
        List<Element> list = this.elementIndex.get(qName);
        if (list != null) {
            list.remove(element);
            if (list.isEmpty()) {
                this.elementIndex.remove(qName);
            }
        }
    }

    protected void addToAttributeIndex(Attribute attribute) {
        QName qName = attribute.getQName();
        this.attributeIndex.put(qName, attribute);
    }

    protected void removeFromAttributeIndex(Attribute attribute) {
        QName qName = attribute.getQName();
        this.attributeIndex.remove(qName);
    }
}

