/*
 * Decompiled with CFR 0.152.
 */
package crawler.open.util;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateUtil {
    private static Log log = LogFactory.getLog(DateUtil.class);
    private static String defaultDatePattern = null;
    private static String timePattern = "HH:mm";
    public static final String TS_FORMAT = String.valueOf(DateUtil.getDatePattern()) + " HH:mm:ss.S";
    private static Calendar cale = Calendar.getInstance();

    public static String getDateTime() {
        try {
            SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return datetime.format(Calendar.getInstance().getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDateTime():" + e.getMessage()));
            return "";
        }
    }

    public static String getDateTime(long date) {
        try {
            SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return datetime.format(new Date(date));
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDateTime():" + e.getMessage()));
            return "";
        }
    }

    public static String getDate() {
        try {
            SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
            return date.format(Calendar.getInstance().getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDate():" + e.getMessage()));
            return "";
        }
    }

    public static String getTime() {
        String temp = "";
        try {
            SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");
            temp = String.valueOf(temp) + time.format(cale.getTime());
            return temp;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getTime():" + e.getMessage()));
            return "";
        }
    }

    public static int getHour() {
        int temp = 0;
        try {
            temp = Calendar.getInstance().get(11);
            return temp;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getTime():" + e.getMessage()));
            return 0;
        }
    }

    public static int getHour(String fromdate) {
        try {
            SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            GregorianCalendar gCal = new GregorianCalendar();
            Date datetime = date.parse(fromdate);
            gCal.setTime(datetime);
            return gCal.get(11);
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.addDay():" + e.toString()));
            return 0;
        }
    }

    public static int getMinute() {
        int temp = 0;
        try {
            temp = Calendar.getInstance().get(12);
            return temp;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getTime():" + e.getMessage()));
            return 0;
        }
    }

    public static String getStartDate() {
        try {
            return String.valueOf(DateUtil.getYear()) + "-01-01";
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getStartDate():" + e.getMessage()));
            return "";
        }
    }

    public static String getEndDate() {
        try {
            return DateUtil.getDate();
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getEndDate():" + e.getMessage()));
            return "";
        }
    }

    public static String getYear() {
        try {
            return String.valueOf(cale.get(1));
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getYear():" + e.getMessage()));
            return "";
        }
    }

    public static String getMonth() {
        try {
            DecimalFormat df = new DecimalFormat();
            df.applyPattern("00");
            return df.format(cale.get(2) + 1);
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getMonth():" + e.getMessage()));
            return "";
        }
    }

    public static String getDay() {
        try {
            return String.valueOf(cale.get(5));
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDay():" + e.getMessage()));
            return "";
        }
    }

    public static int getDays(String date1, String date2) {
        try {
            SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
            ParsePosition pos = new ParsePosition(0);
            ParsePosition pos1 = new ParsePosition(0);
            Date dt1 = date.parse(date1, pos);
            Date dt2 = date.parse(date2, pos1);
            long l = dt1.getTime() - dt2.getTime();
            int margin = (int)(l / 86400000L);
            return margin;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDays():" + e.toString()));
            return 0;
        }
    }

    public static int getHours(String date1, String date2) {
        try {
            SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ParsePosition pos = new ParsePosition(0);
            ParsePosition pos1 = new ParsePosition(0);
            Date dt1 = datetime.parse(date1, pos);
            Date dt2 = datetime.parse(date2, pos1);
            long l = dt1.getTime() - dt2.getTime();
            int margin = (int)(l / 3600000L);
            return margin;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getHours():" + e.toString()));
            return 0;
        }
    }

    public static int getMinutes(String date1, String date2) {
        try {
            SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ParsePosition pos = new ParsePosition(0);
            ParsePosition pos1 = new ParsePosition(0);
            Date dt1 = datetime.parse(date1, pos);
            Date dt2 = datetime.parse(date2, pos1);
            long l = dt1.getTime() - dt2.getTime();
            int margin = (int)(l / 60000L);
            return margin;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getMinutes():" + e.toString()));
            return 0;
        }
    }

    public static int getMinutes(String fromdate) {
        try {
            SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            GregorianCalendar gCal = new GregorianCalendar();
            Date datetime = date.parse(fromdate);
            gCal.setTime(datetime);
            return gCal.get(12);
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.addDay():" + e.toString()));
            return 0;
        }
    }

    public static int getSeconds(String date1, String date2) {
        try {
            SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date dt1 = datetime.parse(date1);
            Date dt2 = datetime.parse(date2);
            long dateintvlong = dt1.getTime() - dt2.getTime();
            int margin = (int)(dateintvlong / 1000L);
            return margin;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getSeconds():" + e.toString()));
            return 0;
        }
    }

    public static double getDoubledays(String date1, String date2) {
        try {
            SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ParsePosition pos = new ParsePosition(0);
            ParsePosition pos1 = new ParsePosition(0);
            Date dt1 = datetime.parse(date1, pos);
            Date dt2 = datetime.parse(date2, pos1);
            long l = dt1.getTime() - dt2.getTime();
            double margin = (double)l / 8.64E7;
            return margin;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getMargin():" + e.toString()));
            return 0.0;
        }
    }

    public static int getMonthMargin(String date1, String date2) {
        try {
            int margin = (Integer.parseInt(date2.substring(0, 4)) - Integer.parseInt(date1.substring(0, 4))) * 12;
            return margin += Integer.parseInt(date2.substring(4, 7).replaceAll("-0", "-")) - Integer.parseInt(date1.substring(4, 7).replaceAll("-0", "-"));
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getMargin():" + e.toString()));
            return 0;
        }
    }

    public static String addDay(String fromdate, int i) {
        try {
            SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
            GregorianCalendar gCal = new GregorianCalendar(Integer.parseInt(fromdate.substring(0, 4)), Integer.parseInt(fromdate.substring(5, 7)) - 1, Integer.parseInt(fromdate.substring(8, 10)));
            gCal.add(5, i);
            return date.format(gCal.getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.addDay():" + e.toString()));
            return DateUtil.getDate();
        }
    }

    public static String addDay(int i) {
        try {
            SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
            Calendar cale = Calendar.getInstance();
            cale.add(5, i);
            return date.format(cale.getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.addDay():" + e.toString()));
            return DateUtil.getDate();
        }
    }

    public static String addMonth(String fromdate, int i) {
        try {
            SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
            GregorianCalendar gCal = new GregorianCalendar(Integer.parseInt(fromdate.substring(0, 4)), Integer.parseInt(fromdate.substring(5, 7)) - 1, Integer.parseInt(fromdate.substring(8, 10)));
            gCal.add(2, i);
            return date.format(gCal.getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.addMonth():" + e.toString()));
            return DateUtil.getDate();
        }
    }

    public static String addYear(String fromdate, int i) {
        try {
            SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
            GregorianCalendar gCal = new GregorianCalendar(Integer.parseInt(fromdate.substring(0, 4)), Integer.parseInt(fromdate.substring(5, 7)) - 1, Integer.parseInt(fromdate.substring(8, 10)));
            gCal.add(1, i);
            return date.format(gCal.getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.addYear():" + e.toString()));
            return "";
        }
    }

    public static int getMaxDay(String year, String month) {
        int day = 0;
        try {
            int iyear = Integer.parseInt(year);
            int imonth = Integer.parseInt(month);
            day = imonth == 1 || imonth == 3 || imonth == 5 || imonth == 7 || imonth == 8 || imonth == 10 || imonth == 12 ? 31 : (imonth == 4 || imonth == 6 || imonth == 9 || imonth == 11 ? 30 : (iyear % 4 == 0 && iyear % 100 != 0 || iyear % 400 == 0 ? 29 : 28));
            return day;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getMonthDay():" + e.toString()));
            return 1;
        }
    }

    public String rollDate(String orgDate, int Type, int Span) {
        int iday;
        int imonth;
        int iyear;
        int seperater;
        int iPos;
        String temp;
        block9: {
            try {
                temp = "";
                iPos = 0;
                seperater = 45;
                if (orgDate != null && orgDate.length() >= 6) break block9;
                return "";
            }
            catch (Exception e) {
                return "";
            }
        }
        iPos = orgDate.indexOf(seperater);
        if (iPos > 0) {
            iyear = Integer.parseInt(orgDate.substring(0, iPos));
            temp = orgDate.substring(iPos + 1);
        } else {
            iyear = Integer.parseInt(orgDate.substring(0, 4));
            temp = orgDate.substring(4);
        }
        iPos = temp.indexOf(seperater);
        if (iPos > 0) {
            imonth = Integer.parseInt(temp.substring(0, iPos));
            temp = temp.substring(iPos + 1);
        } else {
            imonth = Integer.parseInt(temp.substring(0, 2));
            temp = temp.substring(2);
        }
        if (--imonth < 0 || imonth > 11) {
            imonth = 0;
        }
        if ((iday = Integer.parseInt(temp)) < 1 || iday > 31) {
            iday = 1;
        }
        Calendar orgcale = Calendar.getInstance();
        orgcale.set(iyear, imonth, iday);
        temp = DateUtil.rollDate(orgcale, Type, Span);
        return temp;
    }

    public static String rollDate(Calendar cal, int Type, int Span) {
        try {
            SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
            String temp = "";
            Calendar rolcale = cal;
            rolcale.add(Type, Span);
            temp = date.format(rolcale.getTime());
            return temp;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static synchronized String getDatePattern() {
        defaultDatePattern = "yyyy-MM-dd";
        return defaultDatePattern;
    }

    public static final String getDate(Date aDate) {
        SimpleDateFormat df = null;
        String returnValue = "";
        if (aDate != null) {
            df = new SimpleDateFormat(DateUtil.getDatePattern());
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static String getTimeNow(Date theTime) {
        return DateUtil.getDateTime(timePattern, theTime);
    }

    public Calendar getToday() throws ParseException {
        Date today = new Date();
        SimpleDateFormat df = new SimpleDateFormat(DateUtil.getDatePattern());
        String todayAsString = df.format(today);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.convertStringToDate(todayAsString));
        return cal;
    }

    public static final String getDateTime(String aMask, Date aDate) {
        SimpleDateFormat df = null;
        String returnValue = "";
        if (aDate == null) {
            log.error((Object)"aDate is null!");
        } else {
            df = new SimpleDateFormat(aMask);
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static final String convertDateToString(Date aDate) {
        return DateUtil.getDateTime(DateUtil.getDatePattern(), aDate);
    }

    public static final Date convertStringToDate(String aMask, String strDate) throws ParseException {
        SimpleDateFormat df = null;
        Date date = null;
        df = new SimpleDateFormat(aMask);
        if (log.isDebugEnabled()) {
            log.debug((Object)("converting '" + strDate + "' to date with mask '" + aMask + "'"));
        }
        try {
            date = df.parse(strDate);
        }
        catch (ParseException pe) {
            log.error((Object)("ParseException: " + pe));
            throw pe;
        }
        return date;
    }

    public static Date convertStringToDate(String strDate) throws ParseException {
        Date aDate = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("converting date with pattern: " + DateUtil.getDatePattern()));
            }
            aDate = DateUtil.convertStringToDate(DateUtil.getDatePattern(), strDate);
        }
        catch (ParseException pe) {
            log.error((Object)("Could not convert '" + strDate + "' to a date, throwing exception"));
            throw new ParseException(pe.getMessage(), pe.getErrorOffset());
        }
        return aDate;
    }

    public static String getSimpleDateFormat() {
        SimpleDateFormat formatter = new SimpleDateFormat();
        String NDateTime = formatter.format(new Date());
        return NDateTime;
    }

    public static boolean compareTo(String last, String now) {
        Date temp2;
        Date temp1;
        block4: {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            temp1 = formatter.parse(last);
            temp2 = formatter.parse(now);
            if (!temp1.after(temp2)) break block4;
            return false;
        }
        try {
            if (temp1.before(temp2)) {
                return true;
            }
        }
        catch (ParseException e) {
            log.debug((Object)e.getMessage());
        }
        return false;
    }

    public static boolean compareToForBBS(String last, String now) {
        Date temp2;
        Date temp1;
        block6: {
            block5: {
                if (!last.equals(now)) break block5;
                return true;
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            temp1 = formatter.parse(last);
            temp2 = formatter.parse(now);
            if (!temp1.after(temp2)) break block6;
            return false;
        }
        try {
            if (temp1.before(temp2)) {
                return true;
            }
        }
        catch (ParseException e) {
            log.debug((Object)e.getMessage());
        }
        return false;
    }

    public static Date addStartTime(Date param) {
        Date date = param;
        try {
            date.setHours(0);
            date.setMinutes(0);
            date.setSeconds(0);
            return date;
        }
        catch (Exception ex) {
            return date;
        }
    }

    public static Date addEndTime(Date param) {
        Date date = param;
        try {
            date.setHours(23);
            date.setMinutes(59);
            date.setSeconds(0);
            return date;
        }
        catch (Exception ex) {
            return date;
        }
    }

    public static String getMonthLastDay(int month) {
        Date date = new Date();
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[13];
        nArray[1] = 30;
        nArray[2] = 28;
        nArray[3] = 31;
        nArray[4] = 30;
        nArray[5] = 31;
        nArray[6] = 30;
        nArray[7] = 31;
        nArray[8] = 31;
        nArray[9] = 30;
        nArray[10] = 31;
        nArray[11] = 30;
        nArray[12] = 31;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[13];
        nArray2[1] = 31;
        nArray2[2] = 29;
        nArray2[3] = 31;
        nArray2[4] = 30;
        nArray2[5] = 31;
        nArray2[6] = 30;
        nArray2[7] = 31;
        nArray2[8] = 31;
        nArray2[9] = 30;
        nArray2[10] = 31;
        nArray2[11] = 30;
        nArray2[12] = 31;
        nArrayArray[1] = nArray2;
        int[][] day = nArrayArray;
        int year = date.getYear() + 1900;
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            return String.valueOf(day[1][month]);
        }
        return String.valueOf(day[0][month]);
    }

    public static String getMonthLastDay(int year, int month) {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[13];
        nArray[1] = 30;
        nArray[2] = 28;
        nArray[3] = 31;
        nArray[4] = 30;
        nArray[5] = 31;
        nArray[6] = 30;
        nArray[7] = 31;
        nArray[8] = 31;
        nArray[9] = 30;
        nArray[10] = 31;
        nArray[11] = 30;
        nArray[12] = 31;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[13];
        nArray2[1] = 31;
        nArray2[2] = 29;
        nArray2[3] = 31;
        nArray2[4] = 30;
        nArray2[5] = 31;
        nArray2[6] = 30;
        nArray2[7] = 31;
        nArray2[8] = 31;
        nArray2[9] = 30;
        nArray2[10] = 31;
        nArray2[11] = 30;
        nArray2[12] = 31;
        nArrayArray[1] = nArray2;
        int[][] day = nArrayArray;
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            return String.valueOf(day[1][month]);
        }
        return String.valueOf(day[0][month]);
    }

    public static String getTimestamp() {
        Date date = new Date();
        String timestamp = "" + (date.getYear() + 1900) + date.getMonth() + date.getDate() + date.getMinutes() + date.getSeconds() + date.getTime();
        return timestamp;
    }

    public static String getTimestamp(Date date) {
        String timestamp = "" + (date.getYear() + 1900) + date.getMonth() + date.getDate() + date.getMinutes() + date.getSeconds() + date.getTime();
        return timestamp;
    }

    public static Date getDate(String time) {
        Date date = new Date();
        try {
            SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = datetime.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static long getTimeMillis(String datetime) {
        long timemillis = 0L;
        Calendar cal = Calendar.getInstance();
        Date date = DateUtil.getDate(datetime);
        cal.setTime(date);
        timemillis = cal.getTimeInMillis();
        return timemillis;
    }

    public static long getsmallSec(String datetime1, String datetime2) {
        long time1 = 0L;
        long time2 = 0L;
        long time = 0L;
        if (datetime1 != null) {
            time1 = DateUtil.getTimeMillis(datetime1);
        }
        if (datetime2 != null) {
            time2 = DateUtil.getTimeMillis(datetime2);
        }
        time = time1 == 0L ? time2 : (time2 == 0L ? time1 : (time1 > time2 ? time2 : time1));
        return time /= 1000L;
    }

    public static String getDatetimeNfieldgap(int calendarField, String calc, int n) {
        try {
            SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar cal = Calendar.getInstance();
            int value = cal.get(calendarField);
            if (calc.equals("add")) {
                cal.set(calendarField, value + n);
            } else if (calc.equals("sub")) {
                cal.set(calendarField, value - n);
            }
            return datetime.format(cal.getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDay():" + e.getMessage()));
            return "";
        }
    }

    public static void sleep(int seconds) {
        if (seconds < 1) {
            return;
        }
        try {
            Thread.currentThread();
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void sleepLong(long millisecond) {
        if (millisecond < 1L) {
            return;
        }
        try {
            Thread.currentThread();
            Thread.sleep(millisecond);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        boolean flag = DateUtil.compareToForBBS("2015-06-01 00:00:00.0", "2015-06-02 00:05:12");
        System.out.println(flag);
    }
}

