/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf.crfpp;

import com.hankcs.hanlp.model.crf.crfpp.Mcsrch;
import java.util.Arrays;

public class LbfgsOptimizer {
    int iflag_ = 0;
    int iscn = 0;
    int nfev = 0;
    int iycn = 0;
    int point = 0;
    int npt = 0;
    int iter = 0;
    int info = 0;
    int ispt = 0;
    int isyt = 0;
    int iypt = 0;
    int maxfev = 0;
    double stp;
    double stp1;
    double[] diag_ = null;
    double[] w_ = null;
    double[] v_ = null;
    double[] xi_ = null;
    Mcsrch mcsrch_ = null;

    public void pseudo_gradient(int size, double[] v, double[] x, double[] g, double C) {
        for (int i = 0; i < size; ++i) {
            if (x[i] == 0.0) {
                if (g[i] + C < 0.0) {
                    v[i] = g[i] + C;
                    continue;
                }
                if (g[i] - C > 0.0) {
                    v[i] = g[i] - C;
                    continue;
                }
                v[i] = 0.0;
                continue;
            }
            v[i] = g[i] + C * Mcsrch.sigma(x[i]);
        }
    }

    int lbfgs_optimize(int size, int msize, double[] x, double f, double[] g, double[] diag, double[] w, boolean orthant, double C, double[] v, double[] xi, int iflag) {
        int i;
        double yy = 0.0;
        double ys = 0.0;
        int bound = 0;
        int cp = 0;
        if (orthant) {
            this.pseudo_gradient(size, v, x, g, C);
        }
        if (this.mcsrch_ == null) {
            this.mcsrch_ = new Mcsrch();
        }
        boolean firstLoop = true;
        if (iflag == 0) {
            this.point = 0;
            for (i = 0; i < size; ++i) {
                diag[i] = 1.0;
            }
            this.ispt = size + (msize << 1);
            this.iypt = this.ispt + size * msize;
            for (i = 0; i < size; ++i) {
                w[this.ispt + i] = -v[i] * diag[i];
            }
            this.stp1 = 1.0 / Math.sqrt(Mcsrch.ddot_(size, v, 0, v, 0));
        }
        while (true) {
            double xnorm;
            double gnorm;
            if (!firstLoop || firstLoop && iflag != 1 && iflag != 2) {
                ++this.iter;
                this.info = 0;
                if (orthant) {
                    for (i = 0; i < size; ++i) {
                        xi[i] = x[i] != 0.0 ? Mcsrch.sigma(x[i]) : Mcsrch.sigma(-v[i]);
                    }
                }
                if (this.iter != 1) {
                    if (this.iter > size) {
                        bound = size;
                    }
                    ys = Mcsrch.ddot_(size, w, this.iypt + this.npt, w, this.ispt + this.npt);
                    yy = Mcsrch.ddot_(size, w, this.iypt + this.npt, w, this.iypt + this.npt);
                    for (i = 0; i < size; ++i) {
                        diag[i] = ys / yy;
                    }
                }
            }
            if (this.iter != 1 && (!firstLoop || iflag != 1 && firstLoop)) {
                cp = this.point;
                if (this.point == 0) {
                    cp = msize;
                }
                w[size + cp - 1] = 1.0 / ys;
                for (i = 0; i < size; ++i) {
                    w[i] = -v[i];
                }
                bound = Math.min(this.iter - 1, msize);
                cp = this.point;
                for (i = 0; i < bound; ++i) {
                    if (--cp == -1) {
                        cp = msize - 1;
                    }
                    double sq = Mcsrch.ddot_(size, w, this.ispt + cp * size, w, 0);
                    int inmc = size + msize + cp;
                    this.iycn = this.iypt + cp * size;
                    w[inmc] = w[size + cp] * sq;
                    double d = -w[inmc];
                    Mcsrch.daxpy_(size, d, w, this.iycn, w, 0);
                }
                for (i = 0; i < size; ++i) {
                    w[i] = diag[i] * w[i];
                }
                for (i = 0; i < bound; ++i) {
                    double yr = Mcsrch.ddot_(size, w, this.iypt + cp * size, w, 0);
                    double beta = w[size + cp] * yr;
                    int inmc = size + msize + cp;
                    beta = w[inmc] - beta;
                    this.iscn = this.ispt + cp * size;
                    Mcsrch.daxpy_(size, beta, w, this.iscn, w, 0);
                    if (++cp != msize) continue;
                    cp = 0;
                }
                if (orthant) {
                    for (i = 0; i < size; ++i) {
                        w[i] = Mcsrch.sigma(w[i]) == Mcsrch.sigma(-v[i]) ? w[i] : 0.0;
                    }
                }
                for (i = 0; i < size; ++i) {
                    w[this.ispt + this.point * size + i] = w[i];
                }
            }
            if (!firstLoop || firstLoop && iflag != 1) {
                this.nfev = 0;
                this.stp = 1.0;
                if (this.iter == 1) {
                    this.stp = this.stp1;
                }
                for (i = 0; i < size; ++i) {
                    w[i] = g[i];
                }
            }
            double[] stpArr = new double[]{this.stp};
            int[] infoArr = new int[]{this.info};
            int[] nfevArr = new int[]{this.nfev};
            this.mcsrch_.mcsrch(size, x, f, v, w, this.ispt + this.point * size, stpArr, infoArr, nfevArr, diag);
            this.stp = stpArr[0];
            this.info = infoArr[0];
            this.nfev = nfevArr[0];
            if (this.info == -1) {
                if (orthant) {
                    for (int i2 = 0; i2 < size; ++i2) {
                        x[i2] = Mcsrch.sigma(x[i2]) == Mcsrch.sigma(xi[i2]) ? x[i2] : 0.0;
                    }
                }
                return 1;
            }
            if (this.info != 1) {
                System.err.println("The line search routine mcsrch failed: error code:" + this.info);
                return -1;
            }
            this.npt = this.point * size;
            for (int i3 = 0; i3 < size; ++i3) {
                w[this.ispt + this.npt + i3] = this.stp * w[this.ispt + this.npt + i3];
                w[this.iypt + this.npt + i3] = g[i3] - w[i3];
            }
            ++this.point;
            if (this.point == msize) {
                this.point = 0;
            }
            if ((gnorm = Math.sqrt(Mcsrch.ddot_(size, v, 0, v, 0))) / (xnorm = Math.max(1.0, Math.sqrt(Mcsrch.ddot_(size, x, 0, x, 0)))) <= 1.0E-7) {
                return 0;
            }
            firstLoop = false;
        }
    }

    public void clear() {
        this.iypt = 0;
        this.isyt = 0;
        this.ispt = 0;
        this.info = 0;
        this.iter = 0;
        this.npt = 0;
        this.point = 0;
        this.iycn = 0;
        this.nfev = 0;
        this.iscn = 0;
        this.iflag_ = 0;
        this.stp1 = 0.0;
        this.stp = 0.0;
        this.diag_ = null;
        this.w_ = null;
        this.v_ = null;
        this.mcsrch_ = null;
    }

    public int init(int n, int m) {
        int msize = 5;
        int size = n;
        this.iflag_ = 0;
        this.w_ = new double[size * 11 + 10];
        Arrays.fill(this.w_, 0.0);
        this.diag_ = new double[size];
        this.v_ = new double[size];
        return 0;
    }

    public int optimize(double[] x, double f, double[] g) {
        return this.optimize(this.diag_.length, x, f, g, false, 1.0);
    }

    public int optimize(int size, double[] x, double f, double[] g, boolean orthant, double C) {
        int msize = 5;
        if (this.w_ == null) {
            this.iflag_ = 0;
            this.w_ = new double[size * (2 * msize + 1) + 2 * msize];
            Arrays.fill(this.w_, 0.0);
            this.diag_ = new double[size];
            this.v_ = new double[size];
            if (orthant) {
                this.xi_ = new double[size];
            }
        } else {
            if (this.diag_.length != size || this.v_.length != size) {
                System.err.println("size of array is different");
                return -1;
            }
            if (orthant && this.v_.length != size) {
                System.err.println("size of array is different");
                return -1;
            }
        }
        int iflag = 0;
        this.iflag_ = orthant ? (iflag = this.lbfgs_optimize(size, msize, x, f, g, this.diag_, this.w_, orthant, C, this.v_, this.xi_, this.iflag_)) : (iflag = this.lbfgs_optimize(size, msize, x, f, g, this.diag_, this.w_, orthant, C, g, this.xi_, this.iflag_));
        if (iflag < 0) {
            System.err.println("routine stops with unexpected error");
            return -1;
        }
        if (iflag == 0) {
            this.clear();
            return 0;
        }
        return 1;
    }
}

