/*---------------------------- Ajax 请求对象 ----------------------------*/
		
/**************************************************
 -- 属性：
	 url: 请求地址；
	 method: 请求方法（GET 或者 POST），默认为 GET；
	 flag: 异步或者同步请求（true 或者 false），默认为 true；
	 info: 请求参数，默认为 null，注：只有当请求方法为 POST 时，才被使用；
	 //isEval: 是否调用 eval() 函数（true 或者 false），默认为为 false；
	 //callback: 是否设置回调函数（true或者false），默认为 true;
	 result: Ajax 请求的响应结果
 
 -- 方法：
	 executeRequest: 执行 Ajax 请求的方法；
	 onReady: 绑定函数到 req.onreadystatechange 事件；
	 dealResult: 只提供了函数名称，用来设置用户自己的函数。注：在用户自己的函数中，用来处理 Ajax 请求的返回结果。
**************************************************/
function Ajax(url, method, flag, info) {
	this.url = url;
	this.method = method || "GET";
	this.flag = (flag == false) ? false : (flag || true);
	this.info = info || null;
	//this.isEval = false;
	//this.callback = true;
	this.result = null;
	var req = null;	 // req: XMLHttpRequest 对象；
	
	// 实例化 req 对象
	(function() {
		if (window.XMLHttpRequest) {
			req = new XMLHttpRequest();
			if (req.overrideMimeType) {
				//req.overrideMimeType("text/xml");
			}
		} else if (window.ActiveXObject) {
			try {
				req = new ActiveXObject("Msxml2.XMLHTTP");
			} catch (e) {
				try {
					req = new ActiveXObject("Microsoft.XMLHTTP");
				} catch (e) {
					alert("该浏览器不支持 Ajax ！");
					req = null;
				}
			}
			
			/* Msxml2.XMLHTTP.5.0, 4.0, 3.0 都可以，2.0 和 1.0 不可以
			for (var i = 5; i; i--) {
				try {
					alert(i);
					if (i != 2) {
						req = new ActiveXObject("Msxml2.XMLHTTP." + i + ".0");
					}
					
				} catch (e) {
					alert(e);
					continue;
				}
			}*/
		}
	}());
	this.executeRequest = function () {
		if (!req || !this.url) {
			alert("req 为空或者 url 为空！");
			return;
		}
		
		if (this.url.indexOf("_id_=") != -1) {
			// 不改变
		} else {
			// 保证每次请求的 URL 都不一样，防止缓存
			var rand = "_id_=" + Math.random();
			if (this.url.indexOf("?") != -1) {
				this.url += "&" + rand;
			} else {
				this.url += "?" + rand;
			}
		}
		
		/*// 判断，是否设置回调函数
		if (this.callback) {
			this.onReady(req);
		}*/
		// 设置回调函数
		this.onReady(req, this);
		// 初始化 req 对象
		req.open(this.method, this.url, this.flag);
		
		// 判断，是否为 POST 请求
		if ((this.method.toUpperCase() == "POST") && this.info) {
			req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		}
		// 向服务器端发送请求
		req.send(this.info);
		
		/*// 判断，是否执行 eval() 函数
		if (this.isEval) {
			eval(req.responseText);
		}*/
	};
	this.onReady = function (req, ajax) {
		req.onreadystatechange = function () {
			if (req.readyState == 4) {
				var result = req.responseText;
				if (req.status == 200) {
					ajax.result = result;
					if (ajax.dealResult) {
						ajax.dealResult(result);
					} else {
						var message = "请为 Ajax对象的 dealResult 设置回调函数！";
						message += "\r\n例如：Ajax对象.dealResult=function(result) { Your Code }";
						message += "\r\n其中，result 参数为服务器端返回的响应数据。";
						//alert(message);
					}
				} else {
					//alert("响应错误！");
					
					//alert(result);
				}
			}
		};
	};
	this.dealResult;	// = function(result) { };
}
