/*
 * Decompiled with CFR 0.152.
 */
package cn.xddai.chardet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class CharsetDetector {
    private boolean found = false;
    private String result;
    private int lang;

    public String[] detectChineseCharset(InputStream in) throws IOException {
        String[] prob;
        int len;
        this.lang = 2;
        nsDetector det = new nsDetector(this.lang);
        det.Init(new nsICharsetDetectionObserver(){

            public void Notify(String charset) {
                CharsetDetector.this.found = true;
                CharsetDetector.this.result = charset;
            }
        });
        BufferedInputStream imp = new BufferedInputStream(in);
        byte[] buf = new byte[1024];
        boolean isAscii = true;
        while ((len = imp.read(buf, 0, buf.length)) != -1) {
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (isAscii || !det.DoIt(buf, len, false)) continue;
        }
        imp.close();
        in.close();
        det.DataEnd();
        if (isAscii) {
            this.found = true;
            prob = new String[]{"ASCII"};
        } else {
            prob = this.found ? new String[]{this.result} : det.getProbableCharsets();
        }
        return prob;
    }

    public String[] detectAllCharset(InputStream in) throws IOException {
        this.lang = 0;
        return this.detectChineseCharset(in);
    }
}

