// **********************************************************************
//
// Copyright (c) 2003-2013 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.5.1
//
// <auto-generated>
//
// Generated from file `Metrics.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceMX;

/**
 * The metrics administrative facet interface. This interface allows
 * remote administrative clients to access metrics of an application
 * that enabled the Ice administrative facility and configured some
 * metrics views.
 * 
 **/
public final class MetricsAdminPrxHelper extends Ice.ObjectPrxHelperBase implements MetricsAdminPrx
{
    private static final String __disableMetricsView_name = "disableMetricsView";

    /**
     * Disable a metrics view.
     * 
     * @param name The metrics view name.
     * 
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     * 
     **/
    public void disableMetricsView(String name)
        throws UnknownMetricsView
    {
        disableMetricsView(name, null, false);
    }

    /**
     * Disable a metrics view.
     * 
     * @param name The metrics view name.
     * 
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void disableMetricsView(String name, java.util.Map<String, String> __ctx)
        throws UnknownMetricsView
    {
        disableMetricsView(name, __ctx, true);
    }

    private void disableMetricsView(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws UnknownMetricsView
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        final Ice.Instrumentation.InvocationObserver __observer = IceInternal.ObserverHelper.get(this, "disableMetricsView", __ctx);
        int __cnt = 0;
        try
        {
            while(true)
            {
                Ice._ObjectDel __delBase = null;
                try
                {
                    __checkTwowayOnly("disableMetricsView");
                    __delBase = __getDelegate(false);
                    _MetricsAdminDel __del = (_MetricsAdminDel)__delBase;
                    __del.disableMetricsView(name, __ctx, __observer);
                    return;
                }
                catch(IceInternal.LocalExceptionWrapper __ex)
                {
                    __handleExceptionWrapper(__delBase, __ex, __observer);
                }
                catch(Ice.LocalException __ex)
                {
                    __cnt = __handleException(__delBase, __ex, null, __cnt, __observer);
                }
            }
        }
        finally
        {
            if(__observer != null)
            {
                __observer.detach();
            }
        }
    }

    /**
     * Disable a metrics view.
     * 
     * @param __cb The callback object for the operation.
     * @param name The metrics view name.
     * 
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name)
    {
        return begin_disableMetricsView(name, null, false, null);
    }

    /**
     * Disable a metrics view.
     * 
     * @param __cb The callback object for the operation.
     * @param name The metrics view name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name, java.util.Map<String, String> __ctx)
    {
        return begin_disableMetricsView(name, __ctx, true, null);
    }

    /**
     * Disable a metrics view.
     * 
     * @param __cb The callback object for the operation.
     * @param name The metrics view name.
     * 
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name, Ice.Callback __cb)
    {
        return begin_disableMetricsView(name, null, false, __cb);
    }

    /**
     * Disable a metrics view.
     * 
     * @param __cb The callback object for the operation.
     * @param name The metrics view name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_disableMetricsView(name, __ctx, true, __cb);
    }

    /**
     * Disable a metrics view.
     * 
     * @param __cb The callback object for the operation.
     * @param name The metrics view name.
     * 
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name, Callback_MetricsAdmin_disableMetricsView __cb)
    {
        return begin_disableMetricsView(name, null, false, __cb);
    }

    /**
     * Disable a metrics view.
     * 
     * @param __cb The callback object for the operation.
     * @param name The metrics view name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name, java.util.Map<String, String> __ctx, Callback_MetricsAdmin_disableMetricsView __cb)
    {
        return begin_disableMetricsView(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_disableMetricsView(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__disableMetricsView_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __disableMetricsView_name, __cb);
        try
        {
            __result.__prepare(__disableMetricsView_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__startWriteParams(Ice.FormatType.SlicedFormat);
            __os.writeString(name);
            __result.__endWriteParams();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_disableMetricsView(Ice.AsyncResult __result)
        throws UnknownMetricsView
    {
        Ice.AsyncResult.__check(__result, this, __disableMetricsView_name);
        boolean __ok = __result.__wait();
        try
        {
            if(!__ok)
            {
                try
                {
                    __result.__throwUserException();
                }
                catch(UnknownMetricsView __ex)
                {
                    throw __ex;
                }
                catch(Ice.UserException __ex)
                {
                    throw new Ice.UnknownUserException(__ex.ice_name(), __ex);
                }
            }
            __result.__readEmptyParams();
        }
        catch(Ice.LocalException ex)
        {
            Ice.Instrumentation.InvocationObserver __obsv = __result.__getObserver();
            if(__obsv != null)
            {
                __obsv.failed(ex.ice_name());
            }
            throw ex;
        }
    }

    private static final String __enableMetricsView_name = "enableMetricsView";

    /**
     * Enables a metrics view.
     * 
     * @param name The metrics view name.
     * 
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     * 
     **/
    public void enableMetricsView(String name)
        throws UnknownMetricsView
    {
        enableMetricsView(name, null, false);
    }

    /**
     * Enables a metrics view.
     * 
     * @param name The metrics view name.
     * 
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void enableMetricsView(String name, java.util.Map<String, String> __ctx)
        throws UnknownMetricsView
    {
        enableMetricsView(name, __ctx, true);
    }

    private void enableMetricsView(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws UnknownMetricsView
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        final Ice.Instrumentation.InvocationObserver __observer = IceInternal.ObserverHelper.get(this, "enableMetricsView", __ctx);
        int __cnt = 0;
        try
        {
            while(true)
            {
                Ice._ObjectDel __delBase = null;
                try
                {
                    __checkTwowayOnly("enableMetricsView");
                    __delBase = __getDelegate(false);
                    _MetricsAdminDel __del = (_MetricsAdminDel)__delBase;
                    __del.enableMetricsView(name, __ctx, __observer);
                    return;
                }
                catch(IceInternal.LocalExceptionWrapper __ex)
                {
                    __handleExceptionWrapper(__delBase, __ex, __observer);
                }
                catch(Ice.LocalException __ex)
                {
                    __cnt = __handleException(__delBase, __ex, null, __cnt, __observer);
                }
            }
        }
        finally
        {
            if(__observer != null)
            {
                __observer.detach();
            }
        }
    }

    /**
     * Enables a metrics view.
     * 
     * @param __cb The callback object for the operation.
     * @param name The metrics view name.
     * 
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name)
    {
        return begin_enableMetricsView(name, null, false, null);
    }

    /**
     * Enables a metrics view.
     * 
     * @param __cb The callback object for the operation.
     * @param name The metrics view name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name, java.util.Map<String, String> __ctx)
    {
        return begin_enableMetricsView(name, __ctx, true, null);
    }

    /**
     * Enables a metrics view.
     * 
     * @param __cb The callback object for the operation.
     * @param name The metrics view name.
     * 
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name, Ice.Callback __cb)
    {
        return begin_enableMetricsView(name, null, false, __cb);
    }

    /**
     * Enables a metrics view.
     * 
     * @param __cb The callback object for the operation.
     * @param name The metrics view name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_enableMetricsView(name, __ctx, true, __cb);
    }

    /**
     * Enables a metrics view.
     * 
     * @param __cb The callback object for the operation.
     * @param name The metrics view name.
     * 
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name, Callback_MetricsAdmin_enableMetricsView __cb)
    {
        return begin_enableMetricsView(name, null, false, __cb);
    }

    /**
     * Enables a metrics view.
     * 
     * @param __cb The callback object for the operation.
     * @param name The metrics view name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name, java.util.Map<String, String> __ctx, Callback_MetricsAdmin_enableMetricsView __cb)
    {
        return begin_enableMetricsView(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_enableMetricsView(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__enableMetricsView_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __enableMetricsView_name, __cb);
        try
        {
            __result.__prepare(__enableMetricsView_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__startWriteParams(Ice.FormatType.SlicedFormat);
            __os.writeString(name);
            __result.__endWriteParams();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_enableMetricsView(Ice.AsyncResult __result)
        throws UnknownMetricsView
    {
        Ice.AsyncResult.__check(__result, this, __enableMetricsView_name);
        boolean __ok = __result.__wait();
        try
        {
            if(!__ok)
            {
                try
                {
                    __result.__throwUserException();
                }
                catch(UnknownMetricsView __ex)
                {
                    throw __ex;
                }
                catch(Ice.UserException __ex)
                {
                    throw new Ice.UnknownUserException(__ex.ice_name(), __ex);
                }
            }
            __result.__readEmptyParams();
        }
        catch(Ice.LocalException ex)
        {
            Ice.Instrumentation.InvocationObserver __obsv = __result.__getObserver();
            if(__obsv != null)
            {
                __obsv.failed(ex.ice_name());
            }
            throw ex;
        }
    }

    private static final String __getMapMetricsFailures_name = "getMapMetricsFailures";

    /**
     * Get the metrics failures associated with the given view and map.
     * 
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     * @return The metrics failures associated with the map.
     * 
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     * 
     **/
    public MetricsFailures[] getMapMetricsFailures(String view, String map)
        throws UnknownMetricsView
    {
        return getMapMetricsFailures(view, map, null, false);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * 
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The metrics failures associated with the map.
     * 
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     * 
     **/
    public MetricsFailures[] getMapMetricsFailures(String view, String map, java.util.Map<String, String> __ctx)
        throws UnknownMetricsView
    {
        return getMapMetricsFailures(view, map, __ctx, true);
    }

    private MetricsFailures[] getMapMetricsFailures(String view, String map, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws UnknownMetricsView
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        final Ice.Instrumentation.InvocationObserver __observer = IceInternal.ObserverHelper.get(this, "getMapMetricsFailures", __ctx);
        int __cnt = 0;
        try
        {
            while(true)
            {
                Ice._ObjectDel __delBase = null;
                try
                {
                    __checkTwowayOnly("getMapMetricsFailures");
                    __delBase = __getDelegate(false);
                    _MetricsAdminDel __del = (_MetricsAdminDel)__delBase;
                    return __del.getMapMetricsFailures(view, map, __ctx, __observer);
                }
                catch(IceInternal.LocalExceptionWrapper __ex)
                {
                    __handleExceptionWrapper(__delBase, __ex, __observer);
                }
                catch(Ice.LocalException __ex)
                {
                    __cnt = __handleException(__delBase, __ex, null, __cnt, __observer);
                }
            }
        }
        finally
        {
            if(__observer != null)
            {
                __observer.detach();
            }
        }
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view, String map)
    {
        return begin_getMapMetricsFailures(view, map, null, false, null);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view, String map, java.util.Map<String, String> __ctx)
    {
        return begin_getMapMetricsFailures(view, map, __ctx, true, null);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view, String map, Ice.Callback __cb)
    {
        return begin_getMapMetricsFailures(view, map, null, false, __cb);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view, String map, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getMapMetricsFailures(view, map, __ctx, true, __cb);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view, String map, Callback_MetricsAdmin_getMapMetricsFailures __cb)
    {
        return begin_getMapMetricsFailures(view, map, null, false, __cb);
    }

    /**
     * Get the metrics failures associated with the given view and map.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view, String map, java.util.Map<String, String> __ctx, Callback_MetricsAdmin_getMapMetricsFailures __cb)
    {
        return begin_getMapMetricsFailures(view, map, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getMapMetricsFailures(String view, String map, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getMapMetricsFailures_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getMapMetricsFailures_name, __cb);
        try
        {
            __result.__prepare(__getMapMetricsFailures_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__startWriteParams(Ice.FormatType.SlicedFormat);
            __os.writeString(view);
            __os.writeString(map);
            __result.__endWriteParams();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The metrics failures associated with the map.
     * 
     **/
    public MetricsFailures[] end_getMapMetricsFailures(Ice.AsyncResult __result)
        throws UnknownMetricsView
    {
        Ice.AsyncResult.__check(__result, this, __getMapMetricsFailures_name);
        boolean __ok = __result.__wait();
        try
        {
            if(!__ok)
            {
                try
                {
                    __result.__throwUserException();
                }
                catch(UnknownMetricsView __ex)
                {
                    throw __ex;
                }
                catch(Ice.UserException __ex)
                {
                    throw new Ice.UnknownUserException(__ex.ice_name(), __ex);
                }
            }
            IceInternal.BasicStream __is = __result.__startReadParams();
            MetricsFailures[] __ret;
            __ret = MetricsFailuresSeqHelper.read(__is);
            __result.__endReadParams();
            return __ret;
        }
        catch(Ice.LocalException ex)
        {
            Ice.Instrumentation.InvocationObserver __obsv = __result.__getObserver();
            if(__obsv != null)
            {
                __obsv.failed(ex.ice_name());
            }
            throw ex;
        }
    }

    private static final String __getMetricsFailures_name = "getMetricsFailures";

    /**
     * Get the metrics failure associated for the given metrics.
     * 
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     * @param id The ID of the metrics.
     * 
     * @return The metrics failures associated with the metrics.
     * 
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     * 
     **/
    public MetricsFailures getMetricsFailures(String view, String map, String id)
        throws UnknownMetricsView
    {
        return getMetricsFailures(view, map, id, null, false);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * 
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     * @param id The ID of the metrics.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The metrics failures associated with the metrics.
     * 
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     * 
     **/
    public MetricsFailures getMetricsFailures(String view, String map, String id, java.util.Map<String, String> __ctx)
        throws UnknownMetricsView
    {
        return getMetricsFailures(view, map, id, __ctx, true);
    }

    private MetricsFailures getMetricsFailures(String view, String map, String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws UnknownMetricsView
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        final Ice.Instrumentation.InvocationObserver __observer = IceInternal.ObserverHelper.get(this, "getMetricsFailures", __ctx);
        int __cnt = 0;
        try
        {
            while(true)
            {
                Ice._ObjectDel __delBase = null;
                try
                {
                    __checkTwowayOnly("getMetricsFailures");
                    __delBase = __getDelegate(false);
                    _MetricsAdminDel __del = (_MetricsAdminDel)__delBase;
                    return __del.getMetricsFailures(view, map, id, __ctx, __observer);
                }
                catch(IceInternal.LocalExceptionWrapper __ex)
                {
                    __handleExceptionWrapper(__delBase, __ex, __observer);
                }
                catch(Ice.LocalException __ex)
                {
                    __cnt = __handleException(__delBase, __ex, null, __cnt, __observer);
                }
            }
        }
        finally
        {
            if(__observer != null)
            {
                __observer.detach();
            }
        }
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     * @param id The ID of the metrics.
     * 
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view, String map, String id)
    {
        return begin_getMetricsFailures(view, map, id, null, false, null);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     * @param id The ID of the metrics.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view, String map, String id, java.util.Map<String, String> __ctx)
    {
        return begin_getMetricsFailures(view, map, id, __ctx, true, null);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     * @param id The ID of the metrics.
     * 
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view, String map, String id, Ice.Callback __cb)
    {
        return begin_getMetricsFailures(view, map, id, null, false, __cb);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     * @param id The ID of the metrics.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view, String map, String id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getMetricsFailures(view, map, id, __ctx, true, __cb);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     * @param id The ID of the metrics.
     * 
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view, String map, String id, Callback_MetricsAdmin_getMetricsFailures __cb)
    {
        return begin_getMetricsFailures(view, map, id, null, false, __cb);
    }

    /**
     * Get the metrics failure associated for the given metrics.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param map The name of the metrics map.
     * 
     * @param id The ID of the metrics.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view, String map, String id, java.util.Map<String, String> __ctx, Callback_MetricsAdmin_getMetricsFailures __cb)
    {
        return begin_getMetricsFailures(view, map, id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getMetricsFailures(String view, String map, String id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getMetricsFailures_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getMetricsFailures_name, __cb);
        try
        {
            __result.__prepare(__getMetricsFailures_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__startWriteParams(Ice.FormatType.SlicedFormat);
            __os.writeString(view);
            __os.writeString(map);
            __os.writeString(id);
            __result.__endWriteParams();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The metrics failures associated with the metrics.
     * 
     **/
    public MetricsFailures end_getMetricsFailures(Ice.AsyncResult __result)
        throws UnknownMetricsView
    {
        Ice.AsyncResult.__check(__result, this, __getMetricsFailures_name);
        boolean __ok = __result.__wait();
        try
        {
            if(!__ok)
            {
                try
                {
                    __result.__throwUserException();
                }
                catch(UnknownMetricsView __ex)
                {
                    throw __ex;
                }
                catch(Ice.UserException __ex)
                {
                    throw new Ice.UnknownUserException(__ex.ice_name(), __ex);
                }
            }
            IceInternal.BasicStream __is = __result.__startReadParams();
            MetricsFailures __ret;
            __ret = new MetricsFailures();
            __ret.__read(__is);
            __result.__endReadParams();
            return __ret;
        }
        catch(Ice.LocalException ex)
        {
            Ice.Instrumentation.InvocationObserver __obsv = __result.__getObserver();
            if(__obsv != null)
            {
                __obsv.failed(ex.ice_name());
            }
            throw ex;
        }
    }

    private static final String __getMetricsView_name = "getMetricsView";

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * 
     * @param view The name of the metrics view.
     * 
     * @param timestamp The local time of the process when the metrics
     * object were retrieved.
     * 
     * @return The metrics view data.
     * 
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     * 
     **/
    public java.util.Map<java.lang.String, Metrics[]> getMetricsView(String view, Ice.LongHolder timestamp)
        throws UnknownMetricsView
    {
        return getMetricsView(view, timestamp, null, false);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * 
     * @param view The name of the metrics view.
     * 
     * @param timestamp The local time of the process when the metrics
     * object were retrieved.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The metrics view data.
     * 
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     * 
     **/
    public java.util.Map<java.lang.String, Metrics[]> getMetricsView(String view, Ice.LongHolder timestamp, java.util.Map<String, String> __ctx)
        throws UnknownMetricsView
    {
        return getMetricsView(view, timestamp, __ctx, true);
    }

    private java.util.Map<java.lang.String, Metrics[]> getMetricsView(String view, Ice.LongHolder timestamp, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws UnknownMetricsView
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        final Ice.Instrumentation.InvocationObserver __observer = IceInternal.ObserverHelper.get(this, "getMetricsView", __ctx);
        int __cnt = 0;
        try
        {
            while(true)
            {
                Ice._ObjectDel __delBase = null;
                try
                {
                    __checkTwowayOnly("getMetricsView");
                    __delBase = __getDelegate(false);
                    _MetricsAdminDel __del = (_MetricsAdminDel)__delBase;
                    return __del.getMetricsView(view, timestamp, __ctx, __observer);
                }
                catch(IceInternal.LocalExceptionWrapper __ex)
                {
                    __handleExceptionWrapper(__delBase, __ex, __observer);
                }
                catch(Ice.LocalException __ex)
                {
                    __cnt = __handleException(__delBase, __ex, null, __cnt, __observer);
                }
            }
        }
        finally
        {
            if(__observer != null)
            {
                __observer.detach();
            }
        }
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     **/
    public Ice.AsyncResult begin_getMetricsView(String view)
    {
        return begin_getMetricsView(view, null, false, null);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getMetricsView(String view, java.util.Map<String, String> __ctx)
    {
        return begin_getMetricsView(view, __ctx, true, null);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     **/
    public Ice.AsyncResult begin_getMetricsView(String view, Ice.Callback __cb)
    {
        return begin_getMetricsView(view, null, false, __cb);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getMetricsView(String view, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getMetricsView(view, __ctx, true, __cb);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     **/
    public Ice.AsyncResult begin_getMetricsView(String view, Callback_MetricsAdmin_getMetricsView __cb)
    {
        return begin_getMetricsView(view, null, false, __cb);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     * 
     * @param __cb The callback object for the operation.
     * @param view The name of the metrics view.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getMetricsView(String view, java.util.Map<String, String> __ctx, Callback_MetricsAdmin_getMetricsView __cb)
    {
        return begin_getMetricsView(view, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getMetricsView(String view, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getMetricsView_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getMetricsView_name, __cb);
        try
        {
            __result.__prepare(__getMetricsView_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__startWriteParams(Ice.FormatType.SlicedFormat);
            __os.writeString(view);
            __result.__endWriteParams();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The metrics view data.
     * 
     * @param timestamp The local time of the process when the metrics
     * object were retrieved.
     * 
     **/
    public java.util.Map<java.lang.String, Metrics[]> end_getMetricsView(Ice.LongHolder timestamp, Ice.AsyncResult __result)
        throws UnknownMetricsView
    {
        Ice.AsyncResult.__check(__result, this, __getMetricsView_name);
        boolean __ok = __result.__wait();
        try
        {
            if(!__ok)
            {
                try
                {
                    __result.__throwUserException();
                }
                catch(UnknownMetricsView __ex)
                {
                    throw __ex;
                }
                catch(Ice.UserException __ex)
                {
                    throw new Ice.UnknownUserException(__ex.ice_name(), __ex);
                }
            }
            IceInternal.BasicStream __is = __result.__startReadParams();
            timestamp.value = __is.readLong();
            java.util.Map<java.lang.String, Metrics[]> __ret;
            __ret = MetricsViewHelper.read(__is);
            __is.readPendingObjects();
            __result.__endReadParams();
            return __ret;
        }
        catch(Ice.LocalException ex)
        {
            Ice.Instrumentation.InvocationObserver __obsv = __result.__getObserver();
            if(__obsv != null)
            {
                __obsv.failed(ex.ice_name());
            }
            throw ex;
        }
    }

    private static final String __getMetricsViewNames_name = "getMetricsViewNames";

    /**
     * Get the names of enabled and disabled metrics.
     * 
     * @param disabledViews The names of the disabled views.
     * 
     * @return The name of the enabled views.
     * 
     **/
    public String[] getMetricsViewNames(Ice.StringSeqHolder disabledViews)
    {
        return getMetricsViewNames(disabledViews, null, false);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * 
     * @param disabledViews The names of the disabled views.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The name of the enabled views.
     * 
     **/
    public String[] getMetricsViewNames(Ice.StringSeqHolder disabledViews, java.util.Map<String, String> __ctx)
    {
        return getMetricsViewNames(disabledViews, __ctx, true);
    }

    private String[] getMetricsViewNames(Ice.StringSeqHolder disabledViews, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        final Ice.Instrumentation.InvocationObserver __observer = IceInternal.ObserverHelper.get(this, "getMetricsViewNames", __ctx);
        int __cnt = 0;
        try
        {
            while(true)
            {
                Ice._ObjectDel __delBase = null;
                try
                {
                    __checkTwowayOnly("getMetricsViewNames");
                    __delBase = __getDelegate(false);
                    _MetricsAdminDel __del = (_MetricsAdminDel)__delBase;
                    return __del.getMetricsViewNames(disabledViews, __ctx, __observer);
                }
                catch(IceInternal.LocalExceptionWrapper __ex)
                {
                    __handleExceptionWrapper(__delBase, __ex, __observer);
                }
                catch(Ice.LocalException __ex)
                {
                    __cnt = __handleException(__delBase, __ex, null, __cnt, __observer);
                }
            }
        }
        finally
        {
            if(__observer != null)
            {
                __observer.detach();
            }
        }
    }

    /**
     * Get the names of enabled and disabled metrics.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames()
    {
        return begin_getMetricsViewNames(null, false, null);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(java.util.Map<String, String> __ctx)
    {
        return begin_getMetricsViewNames(__ctx, true, null);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(Ice.Callback __cb)
    {
        return begin_getMetricsViewNames(null, false, __cb);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getMetricsViewNames(__ctx, true, __cb);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(Callback_MetricsAdmin_getMetricsViewNames __cb)
    {
        return begin_getMetricsViewNames(null, false, __cb);
    }

    /**
     * Get the names of enabled and disabled metrics.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(java.util.Map<String, String> __ctx, Callback_MetricsAdmin_getMetricsViewNames __cb)
    {
        return begin_getMetricsViewNames(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getMetricsViewNames(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getMetricsViewNames_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getMetricsViewNames_name, __cb);
        try
        {
            __result.__prepare(__getMetricsViewNames_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            __result.__writeEmptyParams();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The name of the enabled views.
     * 
     * @param disabledViews The names of the disabled views.
     * 
     **/
    public String[] end_getMetricsViewNames(Ice.StringSeqHolder disabledViews, Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getMetricsViewNames_name);
        boolean __ok = __result.__wait();
        try
        {
            if(!__ok)
            {
                try
                {
                    __result.__throwUserException();
                }
                catch(Ice.UserException __ex)
                {
                    throw new Ice.UnknownUserException(__ex.ice_name(), __ex);
                }
            }
            IceInternal.BasicStream __is = __result.__startReadParams();
            disabledViews.value = Ice.StringSeqHelper.read(__is);
            String[] __ret;
            __ret = Ice.StringSeqHelper.read(__is);
            __result.__endReadParams();
            return __ret;
        }
        catch(Ice.LocalException ex)
        {
            Ice.Instrumentation.InvocationObserver __obsv = __result.__getObserver();
            if(__obsv != null)
            {
                __obsv.failed(ex.ice_name());
            }
            throw ex;
        }
    }

    public static MetricsAdminPrx checkedCast(Ice.ObjectPrx __obj)
    {
        MetricsAdminPrx __d = null;
        if(__obj != null)
        {
            if(__obj instanceof MetricsAdminPrx)
            {
                __d = (MetricsAdminPrx)__obj;
            }
            else
            {
                if(__obj.ice_isA(ice_staticId()))
                {
                    MetricsAdminPrxHelper __h = new MetricsAdminPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static MetricsAdminPrx checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        MetricsAdminPrx __d = null;
        if(__obj != null)
        {
            if(__obj instanceof MetricsAdminPrx)
            {
                __d = (MetricsAdminPrx)__obj;
            }
            else
            {
                if(__obj.ice_isA(ice_staticId(), __ctx))
                {
                    MetricsAdminPrxHelper __h = new MetricsAdminPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static MetricsAdminPrx checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        MetricsAdminPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA(ice_staticId()))
                {
                    MetricsAdminPrxHelper __h = new MetricsAdminPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static MetricsAdminPrx checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        MetricsAdminPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA(ice_staticId(), __ctx))
                {
                    MetricsAdminPrxHelper __h = new MetricsAdminPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static MetricsAdminPrx uncheckedCast(Ice.ObjectPrx __obj)
    {
        MetricsAdminPrx __d = null;
        if(__obj != null)
        {
            if(__obj instanceof MetricsAdminPrx)
            {
                __d = (MetricsAdminPrx)__obj;
            }
            else
            {
                MetricsAdminPrxHelper __h = new MetricsAdminPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static MetricsAdminPrx uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        MetricsAdminPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            MetricsAdminPrxHelper __h = new MetricsAdminPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    public static final String[] __ids =
    {
        "::Ice::Object",
        "::IceMX::MetricsAdmin"
    };

    public static String ice_staticId()
    {
        return __ids[1];
    }

    protected Ice._ObjectDelM __createDelegateM()
    {
        return new _MetricsAdminDelM();
    }

    protected Ice._ObjectDelD __createDelegateD()
    {
        return new _MetricsAdminDelD();
    }

    public static void __write(IceInternal.BasicStream __os, MetricsAdminPrx v)
    {
        __os.writeProxy(v);
    }

    public static MetricsAdminPrx __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            MetricsAdminPrxHelper result = new MetricsAdminPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }

    public static final long serialVersionUID = 0L;
}
