// **********************************************************************
//
// Copyright (c) 2003-2013 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.5.1
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * The IceGrid administrative interface. </p>
 * <p class="Warning">Allowing access to this interface
 * is a security risk! Please see the IceGrid documentation
 * for further information.
 * 
 **/
public interface AdminPrx extends Ice.ObjectPrx
{
    /**
     * Add an application to IceGrid.
     * 
     * @param descriptor The application descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     **/
    public void addApplication(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               DeploymentException;

    /**
     * Add an application to IceGrid.
     * 
     * @param descriptor The application descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx)
        throws AccessDeniedException,
               DeploymentException;

    /**
     * Add an application to IceGrid.
     * 
     * @param descriptor The application descriptor.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor);

    /**
     * Add an application to IceGrid.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx);

    /**
     * Add an application to IceGrid.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, Ice.Callback __cb);

    /**
     * Add an application to IceGrid.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Add an application to IceGrid.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, Callback_Admin_addApplication __cb);

    /**
     * Add an application to IceGrid.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, Callback_Admin_addApplication __cb);

    /**
     * Add an application to IceGrid.
     * 
     * @param __result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     **/
    public void end_addApplication(Ice.AsyncResult __result)
        throws AccessDeniedException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param descriptor The application descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void syncApplication(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param descriptor The application descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param descriptor The application descriptor.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, Ice.Callback __cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, Callback_Admin_syncApplication __cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, Callback_Admin_syncApplication __cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param __result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void end_syncApplication(Ice.AsyncResult __result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param descriptor The update descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void updateApplication(ApplicationUpdateDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param descriptor The update descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param descriptor The update descriptor.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param descriptor The update descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param descriptor The update descriptor.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, Ice.Callback __cb);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param descriptor The update descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param descriptor The update descriptor.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, Callback_Admin_updateApplication __cb);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param descriptor The update descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx, Callback_Admin_updateApplication __cb);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param __result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void end_updateApplication(Ice.AsyncResult __result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The application descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void syncApplicationWithoutRestart(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The application descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void syncApplicationWithoutRestart(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The application descriptor.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor, Ice.Callback __cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor, Callback_Admin_syncApplicationWithoutRestart __cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, Callback_Admin_syncApplicationWithoutRestart __cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param __result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void end_syncApplicationWithoutRestart(Ice.AsyncResult __result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     **/
    public boolean syncApplicationWithoutRestart_async(AMI_Admin_syncApplicationWithoutRestart __cb, ApplicationDescriptor descriptor);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean syncApplicationWithoutRestart_async(AMI_Admin_syncApplicationWithoutRestart __cb, ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The update descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The update descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The update descriptor.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The update descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The update descriptor.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, Ice.Callback __cb);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The update descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The update descriptor.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, Callback_Admin_updateApplicationWithoutRestart __cb);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The update descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx, Callback_Admin_updateApplicationWithoutRestart __cb);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param __result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void end_updateApplicationWithoutRestart(Ice.AsyncResult __result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The update descriptor.
     * 
     **/
    public boolean updateApplicationWithoutRestart_async(AMI_Admin_updateApplicationWithoutRestart __cb, ApplicationUpdateDescriptor descriptor);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The update descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean updateApplicationWithoutRestart_async(AMI_Admin_updateApplicationWithoutRestart __cb, ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx);

    /**
     * Remove an application from IceGrid.
     * 
     * @param name The application name.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void removeApplication(String name)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Remove an application from IceGrid.
     * 
     * @param name The application name.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void removeApplication(String name, java.util.Map<String, String> __ctx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Remove an application from IceGrid.
     * 
     * @param name The application name.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name);

    /**
     * Remove an application from IceGrid.
     * 
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name, java.util.Map<String, String> __ctx);

    /**
     * Remove an application from IceGrid.
     * 
     * @param name The application name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name, Ice.Callback __cb);

    /**
     * Remove an application from IceGrid.
     * 
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Remove an application from IceGrid.
     * 
     * @param name The application name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name, Callback_Admin_removeApplication __cb);

    /**
     * Remove an application from IceGrid.
     * 
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name, java.util.Map<String, String> __ctx, Callback_Admin_removeApplication __cb);

    /**
     * Remove an application from IceGrid.
     * 
     * @param __result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void end_removeApplication(Ice.AsyncResult __result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if server instantiation
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void instantiateServer(String application, String node, ServerInstanceDescriptor desc)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if server instantiation
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> __ctx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc);

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> __ctx);

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, Ice.Callback __cb);

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, Callback_Admin_instantiateServer __cb);

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> __ctx, Callback_Admin_instantiateServer __cb);

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param __result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if server instantiation
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void end_instantiateServer(Ice.AsyncResult __result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Patch the given application data.
     * 
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @throws PatchException Raised if the patch failed.
     * 
     **/
    public void patchApplication(String name, boolean shutdown)
        throws ApplicationNotExistException,
               PatchException;

    /**
     * Patch the given application data.
     * 
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @throws PatchException Raised if the patch failed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void patchApplication(String name, boolean shutdown, java.util.Map<String, String> __ctx)
        throws ApplicationNotExistException,
               PatchException;

    /**
     * Patch the given application data.
     * 
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown);

    /**
     * Patch the given application data.
     * 
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, java.util.Map<String, String> __ctx);

    /**
     * Patch the given application data.
     * 
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, Ice.Callback __cb);

    /**
     * Patch the given application data.
     * 
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Patch the given application data.
     * 
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, Callback_Admin_patchApplication __cb);

    /**
     * Patch the given application data.
     * 
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, java.util.Map<String, String> __ctx, Callback_Admin_patchApplication __cb);

    /**
     * Patch the given application data.
     * 
     * @param __result The asynchronous result object.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @throws PatchException Raised if the patch failed.
     * 
     **/
    public void end_patchApplication(Ice.AsyncResult __result)
        throws ApplicationNotExistException,
               PatchException;

    /**
     * Get an application descriptor.
     * 
     * @param name The application name.
     * 
     * @return The application descriptor.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public ApplicationInfo getApplicationInfo(String name)
        throws ApplicationNotExistException;

    /**
     * Get an application descriptor.
     * 
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The application descriptor.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public ApplicationInfo getApplicationInfo(String name, java.util.Map<String, String> __ctx)
        throws ApplicationNotExistException;

    /**
     * Get an application descriptor.
     * 
     * @param name The application name.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name);

    /**
     * Get an application descriptor.
     * 
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, java.util.Map<String, String> __ctx);

    /**
     * Get an application descriptor.
     * 
     * @param name The application name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, Ice.Callback __cb);

    /**
     * Get an application descriptor.
     * 
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get an application descriptor.
     * 
     * @param name The application name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, Callback_Admin_getApplicationInfo __cb);

    /**
     * Get an application descriptor.
     * 
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, java.util.Map<String, String> __ctx, Callback_Admin_getApplicationInfo __cb);

    /**
     * Get an application descriptor.
     * 
     * @param __result The asynchronous result object.
     * @return The application descriptor.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public ApplicationInfo end_getApplicationInfo(Ice.AsyncResult __result)
        throws ApplicationNotExistException;

    /**
     * Get the default application descriptor.
     * 
     * @throws DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     * 
     **/
    public ApplicationDescriptor getDefaultApplicationDescriptor()
        throws DeploymentException;

    /**
     * Get the default application descriptor.
     * 
     * @throws DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public ApplicationDescriptor getDefaultApplicationDescriptor(java.util.Map<String, String> __ctx)
        throws DeploymentException;

    /**
     * Get the default application descriptor.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor();

    /**
     * Get the default application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(java.util.Map<String, String> __ctx);

    /**
     * Get the default application descriptor.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(Ice.Callback __cb);

    /**
     * Get the default application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the default application descriptor.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(Callback_Admin_getDefaultApplicationDescriptor __cb);

    /**
     * Get the default application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(java.util.Map<String, String> __ctx, Callback_Admin_getDefaultApplicationDescriptor __cb);

    /**
     * Get the default application descriptor.
     * 
     * @param __result The asynchronous result object.
     * @throws DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     * 
     **/
    public ApplicationDescriptor end_getDefaultApplicationDescriptor(Ice.AsyncResult __result)
        throws DeploymentException;

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @return The application names.
     * 
     **/
    public String[] getAllApplicationNames();

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The application names.
     * 
     **/
    public String[] getAllApplicationNames(java.util.Map<String, String> __ctx);

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames();

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(java.util.Map<String, String> __ctx);

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(Ice.Callback __cb);

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(Callback_Admin_getAllApplicationNames __cb);

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(java.util.Map<String, String> __ctx, Callback_Admin_getAllApplicationNames __cb);

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __result The asynchronous result object.
     * @return The application names.
     * 
     **/
    public String[] end_getAllApplicationNames(Ice.AsyncResult __result);

    /**
     * Get the server information for the server with the given id.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @return The server information.
     * 
     **/
    public ServerInfo getServerInfo(String id)
        throws ServerNotExistException;

    /**
     * Get the server information for the server with the given id.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The server information.
     * 
     **/
    public ServerInfo getServerInfo(String id, java.util.Map<String, String> __ctx)
        throws ServerNotExistException;

    /**
     * Get the server information for the server with the given id.
     * 
     * @param id The server id.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id);

    /**
     * Get the server information for the server with the given id.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, java.util.Map<String, String> __ctx);

    /**
     * Get the server information for the server with the given id.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, Ice.Callback __cb);

    /**
     * Get the server information for the server with the given id.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the server information for the server with the given id.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, Callback_Admin_getServerInfo __cb);

    /**
     * Get the server information for the server with the given id.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, java.util.Map<String, String> __ctx, Callback_Admin_getServerInfo __cb);

    /**
     * Get the server information for the server with the given id.
     * 
     * @param __result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @return The server information.
     * 
     **/
    public ServerInfo end_getServerInfo(Ice.AsyncResult __result)
        throws ServerNotExistException;

    /**
     * Get a server's state.
     * 
     * @param id The server id.
     * 
     * @return The server state.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public ServerState getServerState(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a server's state.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The server state.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public ServerState getServerState(String id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a server's state.
     * 
     * @param id The server id.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id);

    /**
     * Get a server's state.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id, java.util.Map<String, String> __ctx);

    /**
     * Get a server's state.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id, Ice.Callback __cb);

    /**
     * Get a server's state.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get a server's state.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id, Callback_Admin_getServerState __cb);

    /**
     * Get a server's state.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id, java.util.Map<String, String> __ctx, Callback_Admin_getServerState __cb);

    /**
     * Get a server's state.
     * 
     * @param __result The asynchronous result object.
     * @return The server state.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public ServerState end_getServerState(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param id The server id.
     * 
     * @return The server's process id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public int getServerPid(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The server's process id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public int getServerPid(String id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param id The server id.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id, java.util.Map<String, String> __ctx);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id, Ice.Callback __cb);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id, Callback_Admin_getServerPid __cb);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id, java.util.Map<String, String> __ctx, Callback_Admin_getServerPid __cb);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param __result The asynchronous result object.
     * @return The server's process id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public int end_getServerPid(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @return The category for server admin objects.
     * 
     **/
    public String getServerAdminCategory();

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The category for server admin objects.
     * 
     **/
    public String getServerAdminCategory(java.util.Map<String, String> __ctx);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory();

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(java.util.Map<String, String> __ctx);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(Ice.Callback __cb);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(Callback_Admin_getServerAdminCategory __cb);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(java.util.Map<String, String> __ctx, Callback_Admin_getServerAdminCategory __cb);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __result The asynchronous result object.
     * @return The category for server admin objects.
     * 
     **/
    public String end_getServerAdminCategory(Ice.AsyncResult __result);

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param id The server id.
     * 
     * @return A proxy to the server's admin object
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public Ice.ObjectPrx getServerAdmin(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy to the server's admin object
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public Ice.ObjectPrx getServerAdmin(String id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param id The server id.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id);

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, java.util.Map<String, String> __ctx);

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, Ice.Callback __cb);

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, Callback_Admin_getServerAdmin __cb);

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, java.util.Map<String, String> __ctx, Callback_Admin_getServerAdmin __cb);

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param __result The asynchronous result object.
     * @return A proxy to the server's admin object
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public Ice.ObjectPrx end_getServerAdmin(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public void enableServer(String id, boolean enabled)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void enableServer(String id, boolean enabled, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, java.util.Map<String, String> __ctx);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, Ice.Callback __cb);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, Callback_Admin_enableServer __cb);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, java.util.Map<String, String> __ctx, Callback_Admin_enableServer __cb);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param __result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public void end_enableServer(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public boolean isServerEnabled(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean isServerEnabled(String id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param id The server id.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id);

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, java.util.Map<String, String> __ctx);

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, Ice.Callback __cb);

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, Callback_Admin_isServerEnabled __cb);

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, java.util.Map<String, String> __ctx, Callback_Admin_isServerEnabled __cb);

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param __result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public boolean end_isServerEnabled(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Start a server and wait for its activation.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws ServerStartException Raised if the server couldn't be
     * started.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public void startServer(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException;

    /**
     * Start a server and wait for its activation.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws ServerStartException Raised if the server couldn't be
     * started.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void startServer(String id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException;

    /**
     * Start a server and wait for its activation.
     * 
     * @param id The server id.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id);

    /**
     * Start a server and wait for its activation.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id, java.util.Map<String, String> __ctx);

    /**
     * Start a server and wait for its activation.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id, Ice.Callback __cb);

    /**
     * Start a server and wait for its activation.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Start a server and wait for its activation.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id, Callback_Admin_startServer __cb);

    /**
     * Start a server and wait for its activation.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id, java.util.Map<String, String> __ctx, Callback_Admin_startServer __cb);

    /**
     * Start a server and wait for its activation.
     * 
     * @param __result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws ServerStartException Raised if the server couldn't be
     * started.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public void end_startServer(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException;

    /**
     * Stop a server.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws ServerStopException Raised if the server couldn't be
     * stopped.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public void stopServer(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException;

    /**
     * Stop a server.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws ServerStopException Raised if the server couldn't be
     * stopped.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void stopServer(String id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException;

    /**
     * Stop a server.
     * 
     * @param id The server id.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id);

    /**
     * Stop a server.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id, java.util.Map<String, String> __ctx);

    /**
     * Stop a server.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id, Ice.Callback __cb);

    /**
     * Stop a server.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Stop a server.
     * 
     * @param id The server id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id, Callback_Admin_stopServer __cb);

    /**
     * Stop a server.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id, java.util.Map<String, String> __ctx, Callback_Admin_stopServer __cb);

    /**
     * Stop a server.
     * 
     * @param __result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws ServerStopException Raised if the server couldn't be
     * stopped.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public void end_stopServer(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException;

    /**
     * Patch a server.
     * 
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @throws PatchException Raised if the patch failed.
     * 
     **/
    public void patchServer(String id, boolean shutdown)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException;

    /**
     * Patch a server.
     * 
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @throws PatchException Raised if the patch failed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void patchServer(String id, boolean shutdown, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException;

    /**
     * Patch a server.
     * 
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown);

    /**
     * Patch a server.
     * 
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, java.util.Map<String, String> __ctx);

    /**
     * Patch a server.
     * 
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, Ice.Callback __cb);

    /**
     * Patch a server.
     * 
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Patch a server.
     * 
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, Callback_Admin_patchServer __cb);

    /**
     * Patch a server.
     * 
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, java.util.Map<String, String> __ctx, Callback_Admin_patchServer __cb);

    /**
     * Patch a server.
     * 
     * @param __result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @throws PatchException Raised if the patch failed.
     * 
     **/
    public void end_patchServer(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException;

    /**
     * Send signal to a server.
     * 
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @throws BadSignalException Raised if the signal is not recognized 
     * by the target server.
     * 
     **/
    public void sendSignal(String id, String signal)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Send signal to a server.
     * 
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @throws BadSignalException Raised if the signal is not recognized 
     * by the target server.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void sendSignal(String id, String signal, java.util.Map<String, String> __ctx)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Send signal to a server.
     * 
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal);

    /**
     * Send signal to a server.
     * 
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, java.util.Map<String, String> __ctx);

    /**
     * Send signal to a server.
     * 
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, Ice.Callback __cb);

    /**
     * Send signal to a server.
     * 
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Send signal to a server.
     * 
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, Callback_Admin_sendSignal __cb);

    /**
     * Send signal to a server.
     * 
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, java.util.Map<String, String> __ctx, Callback_Admin_sendSignal __cb);

    /**
     * Send signal to a server.
     * 
     * @param __result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @throws BadSignalException Raised if the signal is not recognized 
     * by the target server.
     * 
     **/
    public void end_sendSignal(Ice.AsyncResult __result)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public void writeMessage(String id, String message, int fd)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public void writeMessage(String id, String message, int fd, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @return The asynchronous result object.
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public Ice.AsyncResult begin_writeMessage(String id, String message, int fd);

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public Ice.AsyncResult begin_writeMessage(String id, String message, int fd, java.util.Map<String, String> __ctx);

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public Ice.AsyncResult begin_writeMessage(String id, String message, int fd, Ice.Callback __cb);

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public Ice.AsyncResult begin_writeMessage(String id, String message, int fd, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public Ice.AsyncResult begin_writeMessage(String id, String message, int fd, Callback_Admin_writeMessage __cb);

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public Ice.AsyncResult begin_writeMessage(String id, String message, int fd, java.util.Map<String, String> __ctx, Callback_Admin_writeMessage __cb);

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param __result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public void end_writeMessage(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @return The server ids.
     * 
     **/
    public String[] getAllServerIds();

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The server ids.
     * 
     **/
    public String[] getAllServerIds(java.util.Map<String, String> __ctx);

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds();

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(java.util.Map<String, String> __ctx);

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(Ice.Callback __cb);

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(Callback_Admin_getAllServerIds __cb);

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(java.util.Map<String, String> __ctx, Callback_Admin_getAllServerIds __cb);

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __result The asynchronous result object.
     * @return The server ids.
     * 
     **/
    public String[] end_getAllServerIds(Ice.AsyncResult __result);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param id The adapter id.
     * 
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * 
     * @throws AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     * 
     **/
    public AdapterInfo[] getAdapterInfo(String id)
        throws AdapterNotExistException;

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param id The adapter id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * 
     * @throws AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     * 
     **/
    public AdapterInfo[] getAdapterInfo(String id, java.util.Map<String, String> __ctx)
        throws AdapterNotExistException;

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param id The adapter id.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param id The adapter id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, java.util.Map<String, String> __ctx);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param id The adapter id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, Ice.Callback __cb);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param id The adapter id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param id The adapter id.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, Callback_Admin_getAdapterInfo __cb);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param id The adapter id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, java.util.Map<String, String> __ctx, Callback_Admin_getAdapterInfo __cb);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param __result The asynchronous result object.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * 
     * @throws AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     * 
     **/
    public AdapterInfo[] end_getAdapterInfo(Ice.AsyncResult __result)
        throws AdapterNotExistException;

    /**
     * Remove the adapter with the given id.
     * 
     * @param id The adapter id.
     * @throws AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * 
     **/
    public void removeAdapter(String id)
        throws AdapterNotExistException,
               DeploymentException;

    /**
     * Remove the adapter with the given id.
     * 
     * @param id The adapter id.
     * @throws AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void removeAdapter(String id, java.util.Map<String, String> __ctx)
        throws AdapterNotExistException,
               DeploymentException;

    /**
     * Remove the adapter with the given id.
     * 
     * @param id The adapter id.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id);

    /**
     * Remove the adapter with the given id.
     * 
     * @param id The adapter id.
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, java.util.Map<String, String> __ctx);

    /**
     * Remove the adapter with the given id.
     * 
     * @param id The adapter id.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, Ice.Callback __cb);

    /**
     * Remove the adapter with the given id.
     * 
     * @param id The adapter id.
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Remove the adapter with the given id.
     * 
     * @param id The adapter id.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, Callback_Admin_removeAdapter __cb);

    /**
     * Remove the adapter with the given id.
     * 
     * @param id The adapter id.
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, java.util.Map<String, String> __ctx, Callback_Admin_removeAdapter __cb);

    /**
     * Remove the adapter with the given id.
     * 
     * @param __result The asynchronous result object.
     * @throws AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * 
     **/
    public void end_removeAdapter(Ice.AsyncResult __result)
        throws AdapterNotExistException,
               DeploymentException;

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @return The adapter ids.
     * 
     **/
    public String[] getAllAdapterIds();

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The adapter ids.
     * 
     **/
    public String[] getAllAdapterIds(java.util.Map<String, String> __ctx);

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds();

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(java.util.Map<String, String> __ctx);

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(Ice.Callback __cb);

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(Callback_Admin_getAllAdapterIds __cb);

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(java.util.Map<String, String> __ctx, Callback_Admin_getAllAdapterIds __cb);

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __result The asynchronous result object.
     * @return The adapter ids.
     * 
     **/
    public String[] end_getAllAdapterIds(Ice.AsyncResult __result);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     * 
     * @throws DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * 
     **/
    public void addObject(Ice.ObjectPrx obj)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     * 
     * @throws DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void addObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, Ice.Callback __cb);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, Callback_Admin_addObject __cb);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx, Callback_Admin_addObject __cb);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param __result The asynchronous result object.
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     * 
     * @throws DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * 
     **/
    public void end_addObject(Ice.AsyncResult __result)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param obj The object to be updated to the registry.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     * @throws DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * 
     **/
    public void updateObject(Ice.ObjectPrx obj)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param obj The object to be updated to the registry.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     * @throws DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param obj The object to be updated to the registry.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param obj The object to be updated to the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param obj The object to be updated to the registry.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, Ice.Callback __cb);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param obj The object to be updated to the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param obj The object to be updated to the registry.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, Callback_Admin_updateObject __cb);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param obj The object to be updated to the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx, Callback_Admin_updateObject __cb);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param __result The asynchronous result object.
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     * @throws DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * 
     **/
    public void end_updateObject(Ice.AsyncResult __result)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     * 
     **/
    public void addObjectWithType(Ice.ObjectPrx obj, String type)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> __ctx);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, Ice.Callback __cb);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, Callback_Admin_addObjectWithType __cb);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> __ctx, Callback_Admin_addObjectWithType __cb);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param __result The asynchronous result object.
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     * 
     **/
    public void end_addObjectWithType(Ice.AsyncResult __result)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     * @throws DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * 
     **/
    public void removeObject(Ice.Identity id)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     * @throws DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void removeObject(Ice.Identity id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, java.util.Map<String, String> __ctx);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, Ice.Callback __cb);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, Callback_Admin_removeObject __cb);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, java.util.Map<String, String> __ctx, Callback_Admin_removeObject __cb);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param __result The asynchronous result object.
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     * @throws DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * 
     **/
    public void end_removeObject(Ice.AsyncResult __result)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param id The identity of the object.
     * 
     * @return The object info.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     **/
    public ObjectInfo getObjectInfo(Ice.Identity id)
        throws ObjectNotRegisteredException;

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param id The identity of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The object info.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     **/
    public ObjectInfo getObjectInfo(Ice.Identity id, java.util.Map<String, String> __ctx)
        throws ObjectNotRegisteredException;

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param id The identity of the object.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id);

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param id The identity of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, java.util.Map<String, String> __ctx);

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param id The identity of the object.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, Ice.Callback __cb);

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param id The identity of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param id The identity of the object.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, Callback_Admin_getObjectInfo __cb);

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param id The identity of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, java.util.Map<String, String> __ctx, Callback_Admin_getObjectInfo __cb);

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param __result The asynchronous result object.
     * @return The object info.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     **/
    public ObjectInfo end_getObjectInfo(Ice.AsyncResult __result)
        throws ObjectNotRegisteredException;

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param type The type of the object.
     * 
     * @return The object infos.
     * 
     **/
    public ObjectInfo[] getObjectInfosByType(String type);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param type The type of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The object infos.
     * 
     **/
    public ObjectInfo[] getObjectInfosByType(String type, java.util.Map<String, String> __ctx);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param type The type of the object.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param type The type of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, java.util.Map<String, String> __ctx);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param type The type of the object.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, Ice.Callback __cb);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param type The type of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param type The type of the object.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, Callback_Admin_getObjectInfosByType __cb);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param type The type of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, java.util.Map<String, String> __ctx, Callback_Admin_getObjectInfosByType __cb);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param __result The asynchronous result object.
     * @return The object infos.
     * 
     **/
    public ObjectInfo[] end_getObjectInfosByType(Ice.AsyncResult __result);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @return All the object infos with a stringified identity
     * matching the given expression.
     * 
     **/
    public ObjectInfo[] getAllObjectInfos(String expr);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     * 
     **/
    public ObjectInfo[] getAllObjectInfos(String expr, java.util.Map<String, String> __ctx);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, java.util.Map<String, String> __ctx);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, Ice.Callback __cb);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, Callback_Admin_getAllObjectInfos __cb);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, java.util.Map<String, String> __ctx, Callback_Admin_getAllObjectInfos __cb);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param __result The asynchronous result object.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     * 
     **/
    public ObjectInfo[] end_getAllObjectInfos(Ice.AsyncResult __result);

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param name The node name.
     * 
     * @return true if the node ping succeeded, false otherwise.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     **/
    public boolean pingNode(String name)
        throws NodeNotExistException;

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return true if the node ping succeeded, false otherwise.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     **/
    public boolean pingNode(String name, java.util.Map<String, String> __ctx)
        throws NodeNotExistException;

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param name The node name.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name);

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name, java.util.Map<String, String> __ctx);

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param name The node name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name, Ice.Callback __cb);

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param name The node name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name, Callback_Admin_pingNode __cb);

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name, java.util.Map<String, String> __ctx, Callback_Admin_pingNode __cb);

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param __result The asynchronous result object.
     * @return true if the node ping succeeded, false otherwise.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     **/
    public boolean end_pingNode(Ice.AsyncResult __result)
        throws NodeNotExistException;

    /**
     * Get the load averages of the node.
     * 
     * @param name The node name.
     * 
     * @return The node load information.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public LoadInfo getNodeLoad(String name)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the load averages of the node.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The node load information.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public LoadInfo getNodeLoad(String name, java.util.Map<String, String> __ctx)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the load averages of the node.
     * 
     * @param name The node name.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name);

    /**
     * Get the load averages of the node.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, java.util.Map<String, String> __ctx);

    /**
     * Get the load averages of the node.
     * 
     * @param name The node name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, Ice.Callback __cb);

    /**
     * Get the load averages of the node.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the load averages of the node.
     * 
     * @param name The node name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, Callback_Admin_getNodeLoad __cb);

    /**
     * Get the load averages of the node.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, java.util.Map<String, String> __ctx, Callback_Admin_getNodeLoad __cb);

    /**
     * Get the load averages of the node.
     * 
     * @param __result The asynchronous result object.
     * @return The node load information.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public LoadInfo end_getNodeLoad(Ice.AsyncResult __result)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the node information for the node with the given name.
     * 
     * @param name The node name.
     * 
     * @return The node information.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public NodeInfo getNodeInfo(String name)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the node information for the node with the given name.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The node information.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public NodeInfo getNodeInfo(String name, java.util.Map<String, String> __ctx)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the node information for the node with the given name.
     * 
     * @param name The node name.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name);

    /**
     * Get the node information for the node with the given name.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, java.util.Map<String, String> __ctx);

    /**
     * Get the node information for the node with the given name.
     * 
     * @param name The node name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, Ice.Callback __cb);

    /**
     * Get the node information for the node with the given name.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the node information for the node with the given name.
     * 
     * @param name The node name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, Callback_Admin_getNodeInfo __cb);

    /**
     * Get the node information for the node with the given name.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, java.util.Map<String, String> __ctx, Callback_Admin_getNodeInfo __cb);

    /**
     * Get the node information for the node with the given name.
     * 
     * @param __result The asynchronous result object.
     * @return The node information.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public NodeInfo end_getNodeInfo(Ice.AsyncResult __result)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param name The node name.
     * 
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public int getNodeProcessorSocketCount(String name)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public int getNodeProcessorSocketCount(String name, java.util.Map<String, String> __ctx)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param name The node name.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, java.util.Map<String, String> __ctx);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param name The node name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, Ice.Callback __cb);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param name The node name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, Callback_Admin_getNodeProcessorSocketCount __cb);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, java.util.Map<String, String> __ctx, Callback_Admin_getNodeProcessorSocketCount __cb);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param __result The asynchronous result object.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public int end_getNodeProcessorSocketCount(Ice.AsyncResult __result)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Shutdown an IceGrid node.
     * 
     * @param name The node name.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public void shutdownNode(String name)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Shutdown an IceGrid node.
     * 
     * @param name The node name.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void shutdownNode(String name, java.util.Map<String, String> __ctx)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Shutdown an IceGrid node.
     * 
     * @param name The node name.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name);

    /**
     * Shutdown an IceGrid node.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, java.util.Map<String, String> __ctx);

    /**
     * Shutdown an IceGrid node.
     * 
     * @param name The node name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, Ice.Callback __cb);

    /**
     * Shutdown an IceGrid node.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Shutdown an IceGrid node.
     * 
     * @param name The node name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, Callback_Admin_shutdownNode __cb);

    /**
     * Shutdown an IceGrid node.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, java.util.Map<String, String> __ctx, Callback_Admin_shutdownNode __cb);

    /**
     * Shutdown an IceGrid node.
     * 
     * @param __result The asynchronous result object.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public void end_shutdownNode(Ice.AsyncResult __result)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the hostname of this node.
     * 
     * @param name The node name.
     * 
     * @return The node hostname.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public String getNodeHostname(String name)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the hostname of this node.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The node hostname.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public String getNodeHostname(String name, java.util.Map<String, String> __ctx)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the hostname of this node.
     * 
     * @param name The node name.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name);

    /**
     * Get the hostname of this node.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, java.util.Map<String, String> __ctx);

    /**
     * Get the hostname of this node.
     * 
     * @param name The node name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, Ice.Callback __cb);

    /**
     * Get the hostname of this node.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the hostname of this node.
     * 
     * @param name The node name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, Callback_Admin_getNodeHostname __cb);

    /**
     * Get the hostname of this node.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, java.util.Map<String, String> __ctx, Callback_Admin_getNodeHostname __cb);

    /**
     * Get the hostname of this node.
     * 
     * @param __result The asynchronous result object.
     * @return The node hostname.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public String end_getNodeHostname(Ice.AsyncResult __result)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @return The node names.
     * 
     **/
    public String[] getAllNodeNames();

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The node names.
     * 
     **/
    public String[] getAllNodeNames(java.util.Map<String, String> __ctx);

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames();

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(java.util.Map<String, String> __ctx);

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(Ice.Callback __cb);

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(Callback_Admin_getAllNodeNames __cb);

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(java.util.Map<String, String> __ctx, Callback_Admin_getAllNodeNames __cb);

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __result The asynchronous result object.
     * @return The node names.
     * 
     **/
    public String[] end_getAllNodeNames(Ice.AsyncResult __result);

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param name The registry name.
     * 
     * @return true if the registry ping succeeded, false otherwise.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     **/
    public boolean pingRegistry(String name)
        throws RegistryNotExistException;

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return true if the registry ping succeeded, false otherwise.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     **/
    public boolean pingRegistry(String name, java.util.Map<String, String> __ctx)
        throws RegistryNotExistException;

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param name The registry name.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name);

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, java.util.Map<String, String> __ctx);

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param name The registry name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, Ice.Callback __cb);

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param name The registry name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, Callback_Admin_pingRegistry __cb);

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, java.util.Map<String, String> __ctx, Callback_Admin_pingRegistry __cb);

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param __result The asynchronous result object.
     * @return true if the registry ping succeeded, false otherwise.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     **/
    public boolean end_pingRegistry(Ice.AsyncResult __result)
        throws RegistryNotExistException;

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param name The registry name.
     * 
     * @return The registry information.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     * 
     **/
    public RegistryInfo getRegistryInfo(String name)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The registry information.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     * 
     **/
    public RegistryInfo getRegistryInfo(String name, java.util.Map<String, String> __ctx)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param name The registry name.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name);

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, java.util.Map<String, String> __ctx);

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param name The registry name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, Ice.Callback __cb);

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param name The registry name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, Callback_Admin_getRegistryInfo __cb);

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, java.util.Map<String, String> __ctx, Callback_Admin_getRegistryInfo __cb);

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param __result The asynchronous result object.
     * @return The registry information.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     * 
     **/
    public RegistryInfo end_getRegistryInfo(Ice.AsyncResult __result)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param name The registry name.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     * 
     **/
    public void shutdownRegistry(String name)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param name The registry name.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void shutdownRegistry(String name, java.util.Map<String, String> __ctx)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param name The registry name.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name);

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, java.util.Map<String, String> __ctx);

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param name The registry name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, Ice.Callback __cb);

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param name The registry name.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, Callback_Admin_shutdownRegistry __cb);

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, java.util.Map<String, String> __ctx, Callback_Admin_shutdownRegistry __cb);

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param __result The asynchronous result object.
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     * 
     **/
    public void end_shutdownRegistry(Ice.AsyncResult __result)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @return The registry names.
     * 
     **/
    public String[] getAllRegistryNames();

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The registry names.
     * 
     **/
    public String[] getAllRegistryNames(java.util.Map<String, String> __ctx);

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames();

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(java.util.Map<String, String> __ctx);

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(Ice.Callback __cb);

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(Callback_Admin_getAllRegistryNames __cb);

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(java.util.Map<String, String> __ctx, Callback_Admin_getAllRegistryNames __cb);

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __result The asynchronous result object.
     * @return The registry names.
     * 
     **/
    public String[] end_getAllRegistryNames(Ice.AsyncResult __result);

    /**
     * Shut down the IceGrid registry.
     * 
     **/
    public void shutdown();

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void shutdown(java.util.Map<String, String> __ctx);

    /**
     * Shut down the IceGrid registry.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown();

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx);

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(Ice.Callback __cb);

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(Callback_Admin_shutdown __cb);

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx, Callback_Admin_shutdown __cb);

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __result The asynchronous result object.
     **/
    public void end_shutdown(Ice.AsyncResult __result);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String> getSliceChecksums();

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String> getSliceChecksums(java.util.Map<String, String> __ctx);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums();

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Ice.Callback __cb);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Callback_Admin_getSliceChecksums __cb);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx, Callback_Admin_getSliceChecksums __cb);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __result The asynchronous result object.
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String> end_getSliceChecksums(Ice.AsyncResult __result);
}
