// **********************************************************************
//
// Copyright (c) 2003-2013 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.5.1
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * This interface provides access to IceGrid log file contents.
 * 
 **/
public interface FileIteratorPrx extends Ice.ObjectPrx
{
    /**
     * Read lines from the log file.
     * 
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     * 
     * @return True if EOF is encountered.
     * 
     * @throws FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     * 
     **/
    public boolean read(int size, Ice.StringSeqHolder lines)
        throws FileNotAvailableException;

    /**
     * Read lines from the log file.
     * 
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return True if EOF is encountered.
     * 
     * @throws FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     * 
     **/
    public boolean read(int size, Ice.StringSeqHolder lines, java.util.Map<String, String> __ctx)
        throws FileNotAvailableException;

    /**
     * Read lines from the log file.
     * 
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size);

    /**
     * Read lines from the log file.
     * 
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size, java.util.Map<String, String> __ctx);

    /**
     * Read lines from the log file.
     * 
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size, Ice.Callback __cb);

    /**
     * Read lines from the log file.
     * 
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Read lines from the log file.
     * 
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size, Callback_FileIterator_read __cb);

    /**
     * Read lines from the log file.
     * 
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_read(int size, java.util.Map<String, String> __ctx, Callback_FileIterator_read __cb);

    /**
     * Read lines from the log file.
     * 
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     * 
     * @param __result The asynchronous result object.
     * @return True if EOF is encountered.
     * 
     * @throws FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     * 
     **/
    public boolean end_read(Ice.StringSeqHolder lines, Ice.AsyncResult __result)
        throws FileNotAvailableException;

    /**
     * Destroy the iterator.
     * 
     **/
    public void destroy();

    /**
     * Destroy the iterator.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void destroy(java.util.Map<String, String> __ctx);

    /**
     * Destroy the iterator.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy();

    /**
     * Destroy the iterator.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx);

    /**
     * Destroy the iterator.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(Ice.Callback __cb);

    /**
     * Destroy the iterator.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Destroy the iterator.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(Callback_FileIterator_destroy __cb);

    /**
     * Destroy the iterator.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, Callback_FileIterator_destroy __cb);

    /**
     * Destroy the iterator.
     * 
     * @param __result The asynchronous result object.
     **/
    public void end_destroy(Ice.AsyncResult __result);
}
