// **********************************************************************
//
// Copyright (c) 2003-2013 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.5.1
//
// <auto-generated>
//
// Generated from file `Descriptor.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * A node update descriptor to describe the updates to apply to a
 * node of a deployed application.
 * 
 **/
public class NodeUpdateDescriptor implements java.lang.Cloneable, java.io.Serializable
{
    /**
     * The name of the node to update.
     * 
     **/
    public String name;

    /**
     * The updated description (or null if the description wasn't
     * updated.)
     * 
     **/
    public BoxedString description;

    /**
     * The variables to update.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String> variables;

    /**
     * The variables to remove.
     * 
     **/
    public String[] removeVariables;

    /**
     * The property sets to update.
     * 
     **/
    public java.util.Map<java.lang.String, PropertySetDescriptor> propertySets;

    /**
     * The property sets to remove.
     * 
     **/
    public String[] removePropertySets;

    /**
     * The server instances to update.
     * 
     **/
    public java.util.List<ServerInstanceDescriptor> serverInstances;

    /**
     * The servers which are not template instances to update.
     * 
     **/
    public java.util.List<ServerDescriptor> servers;

    /**
     * The ids of the servers to remove.
     * 
     **/
    public String[] removeServers;

    /**
     * The updated load factor of the node (or null if the load factor
     * was not updated).
     * 
     **/
    public BoxedString loadFactor;

    public NodeUpdateDescriptor()
    {
    }

    public NodeUpdateDescriptor(String name, BoxedString description, java.util.Map<java.lang.String, java.lang.String> variables, String[] removeVariables, java.util.Map<java.lang.String, PropertySetDescriptor> propertySets, String[] removePropertySets, java.util.List<ServerInstanceDescriptor> serverInstances, java.util.List<ServerDescriptor> servers, String[] removeServers, BoxedString loadFactor)
    {
        this.name = name;
        this.description = description;
        this.variables = variables;
        this.removeVariables = removeVariables;
        this.propertySets = propertySets;
        this.removePropertySets = removePropertySets;
        this.serverInstances = serverInstances;
        this.servers = servers;
        this.removeServers = removeServers;
        this.loadFactor = loadFactor;
    }

    public boolean
    equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        NodeUpdateDescriptor _r = null;
        if(rhs instanceof NodeUpdateDescriptor)
        {
            _r = (NodeUpdateDescriptor)rhs;
        }

        if(_r != null)
        {
            if(name != _r.name)
            {
                if(name == null || _r.name == null || !name.equals(_r.name))
                {
                    return false;
                }
            }
            if(description != _r.description)
            {
                if(description == null || _r.description == null || !description.equals(_r.description))
                {
                    return false;
                }
            }
            if(variables != _r.variables)
            {
                if(variables == null || _r.variables == null || !variables.equals(_r.variables))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(removeVariables, _r.removeVariables))
            {
                return false;
            }
            if(propertySets != _r.propertySets)
            {
                if(propertySets == null || _r.propertySets == null || !propertySets.equals(_r.propertySets))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(removePropertySets, _r.removePropertySets))
            {
                return false;
            }
            if(serverInstances != _r.serverInstances)
            {
                if(serverInstances == null || _r.serverInstances == null || !serverInstances.equals(_r.serverInstances))
                {
                    return false;
                }
            }
            if(servers != _r.servers)
            {
                if(servers == null || _r.servers == null || !servers.equals(_r.servers))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(removeServers, _r.removeServers))
            {
                return false;
            }
            if(loadFactor != _r.loadFactor)
            {
                if(loadFactor == null || _r.loadFactor == null || !loadFactor.equals(_r.loadFactor))
                {
                    return false;
                }
            }

            return true;
        }

        return false;
    }

    public int
    hashCode()
    {
        int __h = 5381;
        __h = IceInternal.HashUtil.hashAdd(__h, "::IceGrid::NodeUpdateDescriptor");
        __h = IceInternal.HashUtil.hashAdd(__h, name);
        __h = IceInternal.HashUtil.hashAdd(__h, description);
        __h = IceInternal.HashUtil.hashAdd(__h, variables);
        __h = IceInternal.HashUtil.hashAdd(__h, removeVariables);
        __h = IceInternal.HashUtil.hashAdd(__h, propertySets);
        __h = IceInternal.HashUtil.hashAdd(__h, removePropertySets);
        __h = IceInternal.HashUtil.hashAdd(__h, serverInstances);
        __h = IceInternal.HashUtil.hashAdd(__h, servers);
        __h = IceInternal.HashUtil.hashAdd(__h, removeServers);
        __h = IceInternal.HashUtil.hashAdd(__h, loadFactor);
        return __h;
    }

    public java.lang.Object
    clone()
    {
        java.lang.Object o = null;
        try
        {
            o = super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return o;
    }

    public void
    __write(IceInternal.BasicStream __os)
    {
        __os.writeString(name);
        __os.writeObject(description);
        StringStringDictHelper.write(__os, variables);
        Ice.StringSeqHelper.write(__os, removeVariables);
        PropertySetDescriptorDictHelper.write(__os, propertySets);
        Ice.StringSeqHelper.write(__os, removePropertySets);
        ServerInstanceDescriptorSeqHelper.write(__os, serverInstances);
        ServerDescriptorSeqHelper.write(__os, servers);
        Ice.StringSeqHelper.write(__os, removeServers);
        __os.writeObject(loadFactor);
    }

    private class Patcher implements IceInternal.Patcher
    {
        Patcher(int member)
        {
            __member = member;
        }

        public void
        patch(Ice.Object v)
        {
            switch(__member)
            {
            case 0:
                __typeId = "::IceGrid::BoxedString";
                if(v == null || v instanceof BoxedString)
                {
                    description = (BoxedString)v;
                }
                else
                {
                    IceInternal.Ex.throwUOE(type(), v);
                }
                break;
            case 1:
                __typeId = "::IceGrid::BoxedString";
                if(v == null || v instanceof BoxedString)
                {
                    loadFactor = (BoxedString)v;
                }
                else
                {
                    IceInternal.Ex.throwUOE(type(), v);
                }
                break;
            }
        }

        public String
        type()
        {
            return __typeId;
        }

        private int __member;
        private String __typeId;
    }

    public void
    __read(IceInternal.BasicStream __is)
    {
        name = __is.readString();
        __is.readObject(new Patcher(0));
        variables = new java.util.TreeMap<String, String>();
        int __sz0 = __is.readSize();
        for(int __i0 = 0; __i0 < __sz0; __i0++)
        {
            String __key;
            __key = __is.readString();
            String __value;
            __value = __is.readString();
            variables.put(__key, __value);
        }
        removeVariables = Ice.StringSeqHelper.read(__is);
        propertySets = PropertySetDescriptorDictHelper.read(__is);
        removePropertySets = Ice.StringSeqHelper.read(__is);
        serverInstances = ServerInstanceDescriptorSeqHelper.read(__is);
        servers = ServerDescriptorSeqHelper.read(__is);
        removeServers = Ice.StringSeqHelper.read(__is);
        __is.readObject(new Patcher(1));
    }

    public static final long serialVersionUID = -393596787L;
}
