// **********************************************************************
//
// Copyright (c) 2003-2013 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.5.1
//
// <auto-generated>
//
// Generated from file `UserAccountMapper.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * A user account mapper object is used by IceGrid nodes to map
 * session identifiers to user accounts.
 * 
 **/
public final class UserAccountMapperPrxHelper extends Ice.ObjectPrxHelperBase implements UserAccountMapperPrx
{
    private static final String __getUserAccount_name = "getUserAccount";

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @return The user account name.
     * 
     * @throws UserAccountNotFoundException Raised if no user account
     * is found for the given user.
     * 
     **/
    public String getUserAccount(String user)
        throws UserAccountNotFoundException
    {
        return getUserAccount(user, null, false);
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The user account name.
     * 
     * @throws UserAccountNotFoundException Raised if no user account
     * is found for the given user.
     * 
     **/
    public String getUserAccount(String user, java.util.Map<String, String> __ctx)
        throws UserAccountNotFoundException
    {
        return getUserAccount(user, __ctx, true);
    }

    private String getUserAccount(String user, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws UserAccountNotFoundException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        final Ice.Instrumentation.InvocationObserver __observer = IceInternal.ObserverHelper.get(this, "getUserAccount", __ctx);
        int __cnt = 0;
        try
        {
            while(true)
            {
                Ice._ObjectDel __delBase = null;
                try
                {
                    __checkTwowayOnly("getUserAccount");
                    __delBase = __getDelegate(false);
                    _UserAccountMapperDel __del = (_UserAccountMapperDel)__delBase;
                    return __del.getUserAccount(user, __ctx, __observer);
                }
                catch(IceInternal.LocalExceptionWrapper __ex)
                {
                    __handleExceptionWrapper(__delBase, __ex, __observer);
                }
                catch(Ice.LocalException __ex)
                {
                    __cnt = __handleException(__delBase, __ex, null, __cnt, __observer);
                }
            }
        }
        finally
        {
            if(__observer != null)
            {
                __observer.detach();
            }
        }
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param __cb The callback object for the operation.
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     **/
    public Ice.AsyncResult begin_getUserAccount(String user)
    {
        return begin_getUserAccount(user, null, false, null);
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param __cb The callback object for the operation.
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, java.util.Map<String, String> __ctx)
    {
        return begin_getUserAccount(user, __ctx, true, null);
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param __cb The callback object for the operation.
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, Ice.Callback __cb)
    {
        return begin_getUserAccount(user, null, false, __cb);
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param __cb The callback object for the operation.
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getUserAccount(user, __ctx, true, __cb);
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param __cb The callback object for the operation.
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, Callback_UserAccountMapper_getUserAccount __cb)
    {
        return begin_getUserAccount(user, null, false, __cb);
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * 
     * @param __cb The callback object for the operation.
     * @param user The value of the server descriptor's <tt>user</tt>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <tt>session</tt>, the default value of
     * <tt>user</tt> is the session identifier.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getUserAccount(String user, java.util.Map<String, String> __ctx, Callback_UserAccountMapper_getUserAccount __cb)
    {
        return begin_getUserAccount(user, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getUserAccount(String user, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getUserAccount_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getUserAccount_name, __cb);
        try
        {
            __result.__prepare(__getUserAccount_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__startWriteParams(Ice.FormatType.DefaultFormat);
            __os.writeString(user);
            __result.__endWriteParams();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The user account name.
     * 
     **/
    public String end_getUserAccount(Ice.AsyncResult __result)
        throws UserAccountNotFoundException
    {
        Ice.AsyncResult.__check(__result, this, __getUserAccount_name);
        boolean __ok = __result.__wait();
        try
        {
            if(!__ok)
            {
                try
                {
                    __result.__throwUserException();
                }
                catch(UserAccountNotFoundException __ex)
                {
                    throw __ex;
                }
                catch(Ice.UserException __ex)
                {
                    throw new Ice.UnknownUserException(__ex.ice_name(), __ex);
                }
            }
            IceInternal.BasicStream __is = __result.__startReadParams();
            String __ret;
            __ret = __is.readString();
            __result.__endReadParams();
            return __ret;
        }
        catch(Ice.LocalException ex)
        {
            Ice.Instrumentation.InvocationObserver __obsv = __result.__getObserver();
            if(__obsv != null)
            {
                __obsv.failed(ex.ice_name());
            }
            throw ex;
        }
    }

    public static UserAccountMapperPrx checkedCast(Ice.ObjectPrx __obj)
    {
        UserAccountMapperPrx __d = null;
        if(__obj != null)
        {
            if(__obj instanceof UserAccountMapperPrx)
            {
                __d = (UserAccountMapperPrx)__obj;
            }
            else
            {
                if(__obj.ice_isA(ice_staticId()))
                {
                    UserAccountMapperPrxHelper __h = new UserAccountMapperPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static UserAccountMapperPrx checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        UserAccountMapperPrx __d = null;
        if(__obj != null)
        {
            if(__obj instanceof UserAccountMapperPrx)
            {
                __d = (UserAccountMapperPrx)__obj;
            }
            else
            {
                if(__obj.ice_isA(ice_staticId(), __ctx))
                {
                    UserAccountMapperPrxHelper __h = new UserAccountMapperPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static UserAccountMapperPrx checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        UserAccountMapperPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA(ice_staticId()))
                {
                    UserAccountMapperPrxHelper __h = new UserAccountMapperPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static UserAccountMapperPrx checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        UserAccountMapperPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA(ice_staticId(), __ctx))
                {
                    UserAccountMapperPrxHelper __h = new UserAccountMapperPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static UserAccountMapperPrx uncheckedCast(Ice.ObjectPrx __obj)
    {
        UserAccountMapperPrx __d = null;
        if(__obj != null)
        {
            if(__obj instanceof UserAccountMapperPrx)
            {
                __d = (UserAccountMapperPrx)__obj;
            }
            else
            {
                UserAccountMapperPrxHelper __h = new UserAccountMapperPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static UserAccountMapperPrx uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        UserAccountMapperPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            UserAccountMapperPrxHelper __h = new UserAccountMapperPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    public static final String[] __ids =
    {
        "::Ice::Object",
        "::IceGrid::UserAccountMapper"
    };

    public static String ice_staticId()
    {
        return __ids[1];
    }

    protected Ice._ObjectDelM __createDelegateM()
    {
        return new _UserAccountMapperDelM();
    }

    protected Ice._ObjectDelD __createDelegateD()
    {
        return new _UserAccountMapperDelD();
    }

    public static void __write(IceInternal.BasicStream __os, UserAccountMapperPrx v)
    {
        __os.writeProxy(v);
    }

    public static UserAccountMapperPrx __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            UserAccountMapperPrxHelper result = new UserAccountMapperPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }

    public static final long serialVersionUID = 0L;
}
