// **********************************************************************
//
// Copyright (c) 2003-2013 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.5.1
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * The IceGrid administrative interface. </p>
 * <p class="Warning">Allowing access to this interface
 * is a security risk! Please see the IceGrid documentation
 * for further information.
 * 
 **/
public interface _AdminOperations
{
    /**
     * Add an application to IceGrid.
     * 
     * @param descriptor The application descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @param __current The Current object for the invocation.
     **/
    void addApplication(ApplicationDescriptor descriptor, Ice.Current __current)
        throws AccessDeniedException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param descriptor The application descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __current The Current object for the invocation.
     **/
    void syncApplication(ApplicationDescriptor descriptor, Ice.Current __current)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param descriptor The update descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __current The Current object for the invocation.
     **/
    void updateApplication(ApplicationUpdateDescriptor descriptor, Ice.Current __current)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The application descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __current The Current object for the invocation.
     **/
    void syncApplicationWithoutRestart(ApplicationDescriptor descriptor, Ice.Current __current)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * 
     * @param descriptor The update descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __current The Current object for the invocation.
     **/
    void updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, Ice.Current __current)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Remove an application from IceGrid.
     * 
     * @param name The application name.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __current The Current object for the invocation.
     **/
    void removeApplication(String name, Ice.Current __current)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if server instantiation
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __current The Current object for the invocation.
     **/
    void instantiateServer(String application, String node, ServerInstanceDescriptor desc, Ice.Current __current)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Patch the given application data.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @param __current The Current object for the invocation.
     **/
    void patchApplication_async(AMD_Admin_patchApplication __cb, String name, boolean shutdown, Ice.Current __current)
        throws ApplicationNotExistException,
               PatchException;

    /**
     * Get an application descriptor.
     * 
     * @param name The application name.
     * 
     * @param __current The Current object for the invocation.
     * @return The application descriptor.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    ApplicationInfo getApplicationInfo(String name, Ice.Current __current)
        throws ApplicationNotExistException;

    /**
     * Get the default application descriptor.
     * 
     * @throws DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     * 
     * @param __current The Current object for the invocation.
     **/
    ApplicationDescriptor getDefaultApplicationDescriptor(Ice.Current __current)
        throws DeploymentException;

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __current The Current object for the invocation.
     * @return The application names.
     * 
     **/
    String[] getAllApplicationNames(Ice.Current __current);

    /**
     * Get the server information for the server with the given id.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @param __current The Current object for the invocation.
     * @return The server information.
     * 
     **/
    ServerInfo getServerInfo(String id, Ice.Current __current)
        throws ServerNotExistException;

    /**
     * Get a server's state.
     * 
     * @param id The server id.
     * 
     * @param __current The Current object for the invocation.
     * @return The server state.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    ServerState getServerState(String id, Ice.Current __current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param id The server id.
     * 
     * @param __current The Current object for the invocation.
     * @return The server's process id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    int getServerPid(String id, Ice.Current __current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __current The Current object for the invocation.
     * @return The category for server admin objects.
     * 
     **/
    String getServerAdminCategory(Ice.Current __current);

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param id The server id.
     * 
     * @param __current The Current object for the invocation.
     * @return A proxy to the server's admin object
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    Ice.ObjectPrx getServerAdmin(String id, Ice.Current __current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @param __current The Current object for the invocation.
     **/
    void enableServer(String id, boolean enabled, Ice.Current __current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @param __current The Current object for the invocation.
     **/
    boolean isServerEnabled(String id, Ice.Current __current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Start a server and wait for its activation.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __current The Current object for the invocation.
     **/
    void startServer_async(AMD_Admin_startServer __cb, String id, Ice.Current __current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException;

    /**
     * Stop a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __current The Current object for the invocation.
     **/
    void stopServer_async(AMD_Admin_stopServer __cb, String id, Ice.Current __current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException;

    /**
     * Patch a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @param __current The Current object for the invocation.
     **/
    void patchServer_async(AMD_Admin_patchServer __cb, String id, boolean shutdown, Ice.Current __current)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException;

    /**
     * Send signal to a server.
     * 
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @throws BadSignalException Raised if the signal is not recognized 
     * by the target server.
     * 
     * @param __current The Current object for the invocation.
     **/
    void sendSignal(String id, String signal, Ice.Current __current)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @param __current The Current object for the invocation.
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    void writeMessage(String id, String message, int fd, Ice.Current __current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __current The Current object for the invocation.
     * @return The server ids.
     * 
     **/
    String[] getAllServerIds(Ice.Current __current);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param id The adapter id.
     * 
     * @param __current The Current object for the invocation.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * 
     * @throws AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     * 
     **/
    AdapterInfo[] getAdapterInfo(String id, Ice.Current __current)
        throws AdapterNotExistException;

    /**
     * Remove the adapter with the given id.
     * 
     * @param id The adapter id.
     * @throws AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * 
     * @param __current The Current object for the invocation.
     **/
    void removeAdapter(String id, Ice.Current __current)
        throws AdapterNotExistException,
               DeploymentException;

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __current The Current object for the invocation.
     * @return The adapter ids.
     * 
     **/
    String[] getAllAdapterIds(Ice.Current __current);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     * 
     * @throws DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * 
     * @param __current The Current object for the invocation.
     **/
    void addObject(Ice.ObjectPrx obj, Ice.Current __current)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param obj The object to be updated to the registry.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     * @throws DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * 
     * @param __current The Current object for the invocation.
     **/
    void updateObject(Ice.ObjectPrx obj, Ice.Current __current)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     * 
     * @param __current The Current object for the invocation.
     **/
    void addObjectWithType(Ice.ObjectPrx obj, String type, Ice.Current __current)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     * @throws DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * 
     * @param __current The Current object for the invocation.
     **/
    void removeObject(Ice.Identity id, Ice.Current __current)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param id The identity of the object.
     * 
     * @param __current The Current object for the invocation.
     * @return The object info.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     **/
    ObjectInfo getObjectInfo(Ice.Identity id, Ice.Current __current)
        throws ObjectNotRegisteredException;

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param type The type of the object.
     * 
     * @param __current The Current object for the invocation.
     * @return The object infos.
     * 
     **/
    ObjectInfo[] getObjectInfosByType(String type, Ice.Current __current);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @param __current The Current object for the invocation.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     * 
     **/
    ObjectInfo[] getAllObjectInfos(String expr, Ice.Current __current);

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param name The node name.
     * 
     * @param __current The Current object for the invocation.
     * @return true if the node ping succeeded, false otherwise.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     **/
    boolean pingNode(String name, Ice.Current __current)
        throws NodeNotExistException;

    /**
     * Get the load averages of the node.
     * 
     * @param name The node name.
     * 
     * @param __current The Current object for the invocation.
     * @return The node load information.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    LoadInfo getNodeLoad(String name, Ice.Current __current)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the node information for the node with the given name.
     * 
     * @param name The node name.
     * 
     * @param __current The Current object for the invocation.
     * @return The node information.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    NodeInfo getNodeInfo(String name, Ice.Current __current)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param name The node name.
     * 
     * @param __current The Current object for the invocation.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    int getNodeProcessorSocketCount(String name, Ice.Current __current)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Shutdown an IceGrid node.
     * 
     * @param name The node name.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @param __current The Current object for the invocation.
     **/
    void shutdownNode(String name, Ice.Current __current)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the hostname of this node.
     * 
     * @param name The node name.
     * 
     * @param __current The Current object for the invocation.
     * @return The node hostname.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    String getNodeHostname(String name, Ice.Current __current)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __current The Current object for the invocation.
     * @return The node names.
     * 
     **/
    String[] getAllNodeNames(Ice.Current __current);

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param name The registry name.
     * 
     * @param __current The Current object for the invocation.
     * @return true if the registry ping succeeded, false otherwise.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     **/
    boolean pingRegistry(String name, Ice.Current __current)
        throws RegistryNotExistException;

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param name The registry name.
     * 
     * @param __current The Current object for the invocation.
     * @return The registry information.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     * 
     **/
    RegistryInfo getRegistryInfo(String name, Ice.Current __current)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param name The registry name.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     * 
     * @param __current The Current object for the invocation.
     **/
    void shutdownRegistry(String name, Ice.Current __current)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __current The Current object for the invocation.
     * @return The registry names.
     * 
     **/
    String[] getAllRegistryNames(Ice.Current __current);

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __current The Current object for the invocation.
     **/
    void shutdown(Ice.Current __current);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __current The Current object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    java.util.Map<java.lang.String, java.lang.String> getSliceChecksums(Ice.Current __current);
}
