// **********************************************************************
//
// Copyright (c) 2003-2013 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.5.1
//
// <auto-generated>
//
// Generated from file `Observer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * The database observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * registry database.
 * 
 **/
public interface _ApplicationObserverOperationsNC
{
    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * 
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * 
     * @param applications The applications currently registered with
     * the registry.
     * 
     **/
    void applicationInit(int serial, java.util.List<ApplicationInfo> applications);

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * 
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the new application.
     * 
     **/
    void applicationAdded(int serial, ApplicationInfo desc);

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * 
     * @param serial The new serial number of the registry database.
     * 
     * @param name The name of the application that was removed.
     * 
     **/
    void applicationRemoved(int serial, String name);

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * 
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the update.
     * 
     **/
    void applicationUpdated(int serial, ApplicationUpdateInfo desc);
}
