/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.jdbc;

import com.baifendian.util.SimpleCrypto;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DBConnectionManager {
    private static DBConnectionManager m_dbInstance;
    private static int m_ClientNum;
    public static final Logger LOG;
    private Vector drivers = new Vector();
    private Hashtable pools = new Hashtable();
    public int nCount;
    public int iConID;

    static {
        LOG = Logger.getLogger(DBConnectionManager.class);
    }

    public static synchronized DBConnectionManager getInstance() {
        if (m_dbInstance == null) {
            m_dbInstance = new DBConnectionManager();
        }
        ++m_ClientNum;
        return m_dbInstance;
    }

    public static synchronized DBConnectionManager getInstance(String name) {
        if (m_dbInstance == null) {
            m_dbInstance = new DBConnectionManager();
            m_dbInstance.init(name);
        }
        ++m_ClientNum;
        return m_dbInstance;
    }

    public void setDBDrivers(String[] sDrivers) {
        int i = 0;
        while (i < sDrivers.length) {
            if (!this.hasDriver(sDrivers[i])) {
                this.loadDrivers(sDrivers[i]);
            }
            ++i;
        }
    }

    public void setDBDrivers(String sDriver) {
        if (!this.hasDriver(sDriver)) {
            this.loadDrivers(sDriver);
        }
    }

    public void setDBParams(String conName, String sURL, String sUser, String sPasswd, int maxConn) {
        this.createPools(conName, sURL, sUser, sPasswd, maxConn);
    }

    public boolean hasInitialized(String conName) {
        return this.pools.keySet().contains(conName);
    }

    public boolean hasDriver(String driver) {
        return this.drivers.contains(driver);
    }

    public void freeConnection(String name, Connection con) {
        DBConnectionPool pool = (DBConnectionPool)this.pools.get(name);
        if (pool != null) {
            pool.freeConnection(con);
        }
    }

    public Connection getConnection(String name) {
        DBConnectionPool pool = (DBConnectionPool)this.pools.get(name);
        if (pool != null) {
            return pool.getConnection();
        }
        return null;
    }

    public Connection getConnection(String name, long time) {
        DBConnectionPool pool = (DBConnectionPool)this.pools.get(name);
        if (pool != null) {
            return pool.getConnection(time);
        }
        return null;
    }

    public Statement ExecuteSQL(Connection con, String strSQL, StringBuffer sError) {
        Statement Stmt = null;
        if (con == null) {
            sError.append("Argument Error Connection is null");
            System.out.println("Argument Error Connection is null");
            return Stmt;
        }
        ResultSet Rset = null;
        boolean bResult = false;
        try {
            Stmt = con.createStatement();
            Rset = Stmt.executeQuery(strSQL);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 0) {
                System.out.println("Sucessful " + ex.getMessage());
            } else {
                sError.append(ex.getMessage());
                System.out.println(" #1 :( Query Fail  " + ex.getMessage());
            }
        }
        catch (Exception ex) {
            System.out.println("[DB:SQL]Unkown Exception: " + ex.getMessage());
        }
        return Stmt;
    }

    public Statement ExecuteSQLEx(String sDSN, String strSQL, StringBuffer sError) {
        Statement Stmt = null;
        Connection con = this.getConnection(sDSN);
        if (con == null) {
            sError.append("Can not get a DB connection");
            System.out.println("Can not get a DB connection");
            return Stmt;
        }
        ResultSet Rset = null;
        boolean bResult = false;
        try {
            Stmt = con.createStatement();
            Rset = Stmt.executeQuery(strSQL);
            Rset.close();
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 0) {
                System.out.println("Sucessful " + ex.getMessage());
            } else {
                sError.append(ex.getMessage());
                System.out.println(" #1 :( Query Fail  " + ex.getMessage());
            }
        }
        catch (Exception ex) {
            System.out.println("[DB:SQLEX]Unkown Exception: " + ex.getMessage());
        }
        this.freeConnection(sDSN, con);
        return Stmt;
    }

    public synchronized void release() {
        if (--m_ClientNum != 0) {
            return;
        }
        Enumeration allPools = this.pools.elements();
        while (allPools.hasMoreElements()) {
            DBConnectionPool pool = (DBConnectionPool)allPools.nextElement();
            pool.release();
        }
        Enumeration allDrivers = this.drivers.elements();
        while (allDrivers.hasMoreElements()) {
            Driver driver = (Driver)allDrivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
                LOG.info((Object)("Unregister JDBC Driver " + driver.getClass().getName()));
            }
            catch (SQLException e) {
                LOG.warn((Object)("Can't Unregister JDBC Driver: " + driver.getClass().getName()), (Throwable)e);
            }
        }
        System.gc();
    }

    public static String quoteString(String sdata) {
        if (sdata == null) {
            return "";
        }
        sdata = sdata.replace("'", "''");
        sdata = sdata.replace("\\", "\\\\");
        return sdata;
    }

    public static String getValue(ResultSet rs, String fldName, String sdefault) {
        try {
            if (rs == null) {
                return sdefault;
            }
            String res = rs.getString(fldName);
            if (res == null || res.equalsIgnoreCase("null")) {
                return sdefault;
            }
            return res;
        }
        catch (SQLException sQLException) {
            return sdefault;
        }
    }

    public static long getValue(ResultSet rs, String fldName, long ldefault) {
        try {
            String res = DBConnectionManager.getValue(rs, fldName, "" + ldefault);
            return Long.parseLong(res);
        }
        catch (Exception exception) {
            return ldefault;
        }
    }

    public static int getValue(ResultSet rs, String fldName, int idefault) {
        try {
            String res = DBConnectionManager.getValue(rs, fldName, "" + idefault);
            return Integer.parseInt(res);
        }
        catch (Exception exception) {
            return idefault;
        }
    }

    public static double getValue(ResultSet rs, String fldName, double ddefault) {
        try {
            String res = DBConnectionManager.getValue(rs, fldName, "" + ddefault);
            return Double.parseDouble(res);
        }
        catch (Exception exception) {
            return ddefault;
        }
    }

    private void createPools(String poolName, String url, String user, String password, int max) {
        if (max < 1 || max > 256) {
            max = 5;
        }
        DBConnectionPool pool = new DBConnectionPool(poolName, url, user, password, max);
        this.pools.put(poolName, pool);
        LOG.debug((Object)("Create Connect pool Success: " + poolName));
    }

    private void loadDrivers(String driverClasses) {
        StringTokenizer st = new StringTokenizer(driverClasses);
        while (st.hasMoreElements()) {
            String driverClassName = st.nextToken().trim();
            try {
                Driver driver = (Driver)Class.forName(driverClassName).newInstance();
                DriverManager.registerDriver(driver);
                this.drivers.addElement(driver);
                LOG.info((Object)("Register JDBC Driver" + driverClassName + " Success"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void init(String name) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(name);
        if (is == null) {
            try {
                File f = new File(name);
                if (f.exists()) {
                    is = new FileInputStream(f);
                }
            }
            catch (SecurityException ex) {
                LOG.error((Object)"security manager may forbid access to the local file system");
            }
            catch (FileNotFoundException e) {
                LOG.warn((Object)("Open Config File db.properties Error: " + e.getMessage()));
            }
        }
        Properties dbProps = new Properties();
        try {
            dbProps.load(is);
        }
        catch (Exception e) {
            LOG.error((Object)"Can not read file db.properties, please check");
            return;
        }
        this.loadDrivers(dbProps);
        this.createPools(dbProps);
    }

    private void createPools(Properties props) {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String name = (String)propNames.nextElement();
            if (!name.endsWith(".url")) continue;
            String poolName = name.substring(0, name.lastIndexOf("."));
            String url = props.getProperty(String.valueOf(poolName) + ".url");
            if (url == null) {
                LOG.warn((Object)("Not set URL for Conection Pool: " + poolName));
                continue;
            }
            String user = props.getProperty(String.valueOf(poolName) + ".user");
            String password = props.getProperty(String.valueOf(poolName) + ".password");
            String maxconn = props.getProperty(String.valueOf(poolName) + ".maxconn", "0");
            int max = 5;
            try {
                max = Integer.parseInt(maxconn);
                if (max < 1 || max > 356) {
                    max = 5;
                }
            }
            catch (Exception x) {
                max = 5;
            }
            DBConnectionPool pool = new DBConnectionPool(poolName, url, user, password, max);
            this.pools.put(poolName, pool);
            LOG.debug((Object)("Create Connect pool Success: " + poolName));
        }
    }

    private void loadDrivers(Properties props) {
        String driverClasses = props.getProperty("drivers");
        StringTokenizer st = new StringTokenizer(driverClasses);
        while (st.hasMoreElements()) {
            String driverClassName = st.nextToken().trim();
            try {
                Driver driver = (Driver)Class.forName(driverClassName).newInstance();
                DriverManager.registerDriver(driver);
                this.drivers.addElement(driver);
                LOG.debug((Object)("Register JDBC Driver" + driverClassName + " Success"));
            }
            catch (Exception e) {
                LOG.warn((Object)("Can't register JDBC Driver: " + driverClassName + ", Error: " + e));
            }
        }
    }

    class DBConnectionPool {
        private int checkedOut;
        private Vector freeConnections = new Vector();
        private int maxConn;
        private String name;
        private String password;
        private String URL;
        private String user;

        public DBConnectionPool(String name, String URL2, String user, String password, int maxConn) {
            this.name = name;
            this.URL = URL2;
            this.user = user;
            this.password = password;
            password = SimpleCrypto.decrypt((String)password);
            this.maxConn = maxConn;
        }

        public synchronized void freeConnection(Connection con) {
            this.freeConnections.addElement(con);
            --this.checkedOut;
            this.notifyAll();
        }

        public synchronized Connection getConnection() {
            Connection con = null;
            LOG.debug((Object)(String.valueOf(Thread.currentThread().getName()) + " freeConnections.size:" + this.freeConnections.size() + ",checkedOut=" + this.checkedOut + ",maxConn=" + this.maxConn));
            if (this.freeConnections.size() > 0) {
                con = (Connection)this.freeConnections.firstElement();
                this.freeConnections.removeElementAt(0);
                try {
                    if (con.isClosed() || !con.isValid(2)) {
                        LOG.debug((Object)("Delete a connection from Connect Pool: " + this.name));
                        --this.checkedOut;
                        con = null;
                        con = this.getConnection();
                    }
                }
                catch (SQLException e) {
                    LOG.warn((Object)("Delete a connection from Connect Pool: " + this.name));
                    --this.checkedOut;
                    con = null;
                    con = this.getConnection();
                }
            } else if (this.maxConn == 0 || this.checkedOut < this.maxConn) {
                con = this.newConnection();
            }
            if (con != null) {
                ++this.checkedOut;
            }
            return con;
        }

        public synchronized Connection getConnection(long timeout) {
            Connection con;
            long startTime = 0L;
            while ((con = this.getConnection()) == null) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (startTime++ < timeout) continue;
                return null;
            }
            return con;
        }

        public synchronized void release() {
            Enumeration allConnections = this.freeConnections.elements();
            while (allConnections.hasMoreElements()) {
                Connection con = (Connection)allConnections.nextElement();
                try {
                    con.close();
                    LOG.debug((Object)("Close one connect of pool: " + this.name));
                }
                catch (SQLException e) {
                    LOG.warn((Object)("Can't Close a connection of Pool: " + this.name), (Throwable)e);
                }
            }
            this.freeConnections.removeAllElements();
        }

        private Connection newConnection() {
            Connection con = null;
            try {
                con = this.user == null ? DriverManager.getConnection(this.URL) : DriverManager.getConnection(this.URL, this.user, this.password);
                LOG.debug((Object)("Create a new connection of pool: " + this.name));
            }
            catch (SQLException e) {
                LOG.warn((Object)("Can't Create Connection of URL: " + this.URL), (Throwable)e);
                return null;
            }
            return con;
        }
    }
}

