/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.jdbc;

import com.baifendian.util.SimpleCrypto;
import com.bfd.jdbc.DBConnectionManager;
import com.bfd.jdbc.DBInstance;
import com.bfd.jdbc.DBServer;
import com.bfd.jdbc.Route;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class DBShardingManager {
    public static final Logger LOG = Logger.getLogger(DBShardingManager.class);
    private static final String DB_CONFIG_FILE = "../etc/dbconfig.xml";
    private Map<String, String> drivers = new HashMap<String, String>();
    private static DBShardingManager instance = new DBShardingManager();
    private Map<String, DBInstance> dbInstances;
    private Map<String, DBServer> dbServers;
    private Map<String, Integer> shardingTableSize;
    private Map<String, String> tableCreator;
    private static final byte[] _hexChars = "0123456789abcdef".getBytes();

    public static DBShardingManager getInstance() {
        return instance;
    }

    private DBShardingManager() {
        this.init();
    }

    private void init() {
        if (this.dbInstances == null) {
            this.dbInstances = new HashMap<String, DBInstance>();
        }
        if (this.dbServers == null) {
            this.dbServers = new HashMap<String, DBServer>();
        }
        if (this.shardingTableSize == null) {
            this.shardingTableSize = new HashMap<String, Integer>();
        }
        if (this.tableCreator == null) {
            this.tableCreator = new HashMap<String, String>();
        }
        this.loadConfig();
    }

    private Document load(String file) {
        InputStream stream = DBShardingManager.class.getClassLoader().getResourceAsStream(file);
        if (stream == null) {
            try {
                File f = new File(file);
                if (f.exists()) {
                    stream = new FileInputStream(f);
                }
            }
            catch (SecurityException e) {
                LOG.error((Object)"security manager may forbid access to the local file system", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)(String.valueOf(file) + " not found"), (Throwable)e);
            }
        }
        try {
            Document document = Jsoup.parse((InputStream)stream, (String)"utf8", (String)file);
            return document;
        }
        catch (Exception e) {
            LOG.error((Object)("read " + file + " error"), (Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)("read " + file + " error"), (Throwable)e);
            }
            stream = null;
            file = null;
        }
        return null;
    }

    private void loadConfig() {
        Document doc = this.load(DB_CONFIG_FILE);
        if (doc == null) {
            throw new RuntimeException("load db config error!");
        }
        Elements elems = doc.select("driver");
        if (elems == null || elems.size() == 0) {
            throw new RuntimeException("<driver/> config is empty, please config right driver");
        }
        int i = 0;
        while (i < elems.size()) {
            Element elem = elems.get(i);
            this.drivers.put(elem.attr("dbtype"), elem.attr("value"));
            ++i;
        }
        this.loadDbServers(doc);
        Elements instanceElems = doc.select("instance");
        int i2 = 0;
        while (i2 < instanceElems.size()) {
            Elements routeElems;
            DBInstance dbInstance = new DBInstance();
            Element instanceElem = instanceElems.get(i2);
            String name = instanceElem.attr("name");
            dbInstance.setName(name);
            String type = instanceElem.attr("type");
            dbInstance.setType(type);
            if (!type.equalsIgnoreCase("single")) {
                if (type.equalsIgnoreCase("router")) {
                    String table = instanceElem.attr("table");
                    String tSize = instanceElem.attr("tablesize");
                    if (DBShardingManager.strIsEmpty(table) || DBShardingManager.strIsEmpty(tSize)) {
                        throw new RuntimeException("<instance type=router> 's param is invalid. table or size is empty.");
                    }
                    int size = Integer.parseInt(tSize);
                    dbInstance.setTable(table);
                    dbInstance.setSize(size);
                    this.shardingTableSize.put(table, size);
                } else {
                    throw new RuntimeException("invalid instance type. type should be 'router' or 'singler', but the type is " + type);
                }
            }
            if ((routeElems = instanceElem.select("route")) == null || routeElems.size() == 0) {
                throw new RuntimeException("<instance type=router> 's config param is invalid. route field can not be empty");
            }
            ArrayList<Route> routes = new ArrayList<Route>();
            int j = 0;
            while (j < routeElems.size()) {
                Route route = new Route();
                Element routeElem = routeElems.get(j);
                String db = routeElem.attr("db");
                DBServer dbServer = this.dbServers.get(db);
                if (dbServer == null) {
                    throw new RuntimeException("<route> param is invalid. index or db is empty,  or size is not numeric");
                }
                route.setDbName(db);
                route.setDbServer(dbServer);
                if (DBShardingManager.strIsEmpty(db)) {
                    throw new RuntimeException("<route> param is invalid. db is empty");
                }
                if ("router".equalsIgnoreCase(type)) {
                    String index = routeElem.attr("index");
                    if (DBShardingManager.strIsEmpty(index)) {
                        throw new RuntimeException("<route> param is invalid. index is empty,  or is not numeric, index=" + index);
                    }
                    route.setIndex(Integer.parseInt(index));
                }
                routes.add(route);
                ++j;
            }
            Collections.sort(routes);
            dbInstance.setRoutes(routes);
            this.dbInstances.put(name, dbInstance);
            ++i2;
        }
        Elements tableElems = doc.select("table");
        int i3 = 0;
        while (i3 < tableElems.size()) {
            Element elem = tableElems.get(i3);
            String tableName = elem.attr("name");
            String creator = elem.text();
            this.tableCreator.put(tableName, creator);
            ++i3;
        }
        LOG.info((Object)("load and cache dbInstanceMap successfully, dbInstanceMap ->" + this.dbInstances));
        LOG.info((Object)("load and cache shardingTableSize successfully, shardingTableSize ->" + this.shardingTableSize));
    }

    private void loadDbServers(Document doc) {
        Elements dbElems = doc.select("db");
        if (dbElems == null || dbElems.size() == 0) {
            throw new RuntimeException("single instance should has child node of server, but there is no server nodes");
        }
        int i = 0;
        while (i < dbElems.size()) {
            Element dbElem = dbElems.get(i);
            DBServer dbServer = new DBServer();
            String name = dbElem.attr("name");
            String host = dbElem.attr("host");
            String port = dbElem.attr("port");
            String charset = dbElem.attr("charset");
            String user = dbElem.attr("user");
            String password = dbElem.attr("password");
            password = SimpleCrypto.decrypt((String)password);
            String dbtype = dbElem.attr("dbtype");
            String database = dbElem.attr("database");
            String maxconn = dbElem.attr("maxconn");
            if (DBShardingManager.strIsEmpty(host) || DBShardingManager.strIsEmpty(port) || DBShardingManager.strIsEmpty(charset) || DBShardingManager.strIsEmpty(user) || DBShardingManager.strIsEmpty(password) || DBShardingManager.strIsEmpty(dbtype) || DBShardingManager.strIsEmpty(database) || DBShardingManager.strIsEmpty(maxconn)) {
                throw new RuntimeException("db server config param is invalid. some fields are empty");
            }
            dbServer.setHost(host);
            dbServer.setPort(port);
            dbServer.setCharset(charset);
            dbServer.setUser(user);
            dbServer.setPassword(password);
            dbServer.setDbtype(dbtype);
            dbServer.setDatabase(database);
            dbServer.setMaxConn(Integer.parseInt(maxconn));
            dbServer.setName(name);
            this.dbServers.put(name, dbServer);
            ++i;
        }
    }

    public Map<String, DBInstance> getBbInstanceMap() {
        if (this.dbInstances == null || this.dbInstances.size() == 0) {
            this.loadConfig();
        }
        return this.dbInstances;
    }

    private int getTableShardingSize(String tableName) {
        return this.shardingTableSize.get(tableName);
    }

    private void initAllConnManagers() {
        Map<String, DBInstance> instances = this.getBbInstanceMap();
        for (Map.Entry<String, DBInstance> entry : instances.entrySet()) {
            DBConnectionManager manager;
            DBInstance dbInstance = entry.getValue();
            DBServer server = dbInstance.getServer();
            if (server == null || (manager = this.getConnManager(server)) != null) continue;
            LOG.warn((Object)("dbconnection manager is null, dbConfig -> " + dbInstance));
        }
    }

    public void checkAndCreateDatabases(boolean drop) {
        Collection<DBServer> instances = this.dbServers.values();
        for (DBServer instance : instances) {
            DBConnectionManager dbm = new DBConnectionManager();
            dbm.setDBDrivers(this.drivers.get(instance.getDbtype()));
            String url = "jdbc:" + instance.getDbtype() + "://" + instance.getHost() + ":" + instance.getPort() + "/";
            dbm.setDBParams(instance.getName(), url, instance.getUser(), instance.getPassword(), instance.getMaxConn());
            Connection conn = dbm.getConnection(instance.getName());
            try {
                Statement st = conn.createStatement();
                if (drop) {
                    st.executeUpdate("drop database  if exists " + instance.getDatabase());
                }
                st.executeUpdate("CREATE DATABASE IF NOT EXISTS " + instance.getDatabase() + "  DEFAULT CHARACTER SET utf8 ");
                st.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)("create database error,database instance->" + instance));
            }
            dbm.freeConnection(instance.getName(), conn);
        }
    }

    public void checkAndCreateTables(boolean drop) {
        Collection<DBInstance> instances = this.dbInstances.values();
        for (DBInstance instance : instances) {
            if (instance.getType().equalsIgnoreCase("router")) {
                if (this.tableCreator.get(instance.getTable()) == null) continue;
                this.checkAndCreateTables(instance, drop);
                continue;
            }
            if (!instance.getType().equalsIgnoreCase("single")) continue;
            List<Route> dbRoutes = instance.getRoutes();
            for (Route route : dbRoutes) {
                DBServer dbserver = route.getDbServer();
                String cmd = new StringBuffer().append("sh installDB.sh -h ").append(dbserver.getHost()).append(" -u ").append(dbserver.getUser()).append(" -p").append(dbserver.getPassword()).append(" -P").append(dbserver.getPort()).append(" -d ").append(dbserver.getDatabase()).toString();
                try {
                    Process p = Runtime.getRuntime().exec(cmd);
                    InputStream is = p.getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(isr);
                    String line = null;
                    StringBuffer sb = new StringBuffer();
                    while ((line = br.readLine()) != null) {
                        sb.append(line).append("\n");
                    }
                    int exitVal = p.waitFor();
                    LOG.info((Object)(", Exit Value for command [" + cmd + "] is: " + exitVal + ",value : " + sb.toString()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void checkAndCreateTables(String table, boolean drop) {
        if (DBShardingManager.strIsEmpty(table)) {
            LOG.info((Object)("error tablename -> " + table));
        }
        Collection<DBInstance> instances = this.dbInstances.values();
        for (DBInstance instance : instances) {
            if (!instance.getType().equalsIgnoreCase("router") || !table.equalsIgnoreCase(instance.getTable()) || this.tableCreator.get(instance.getTable()) == null) continue;
            this.checkAndCreateTables(instance, drop);
        }
    }

    private void checkAndCreateTables(DBInstance instance, boolean drop) {
        List<Route> dbRoutes = instance.getRoutes();
        String table = instance.getTable();
        int size = instance.getSize();
        System.out.println(size);
        int dbSize = dbRoutes.size();
        int n = 0;
        for (Route route : dbRoutes) {
            block27: {
                String name = route.getDbName();
                DBConnectionManager manager = this.getConnManager(route.getDbServer());
                Connection connection = manager.getConnection(name);
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    try {
                        stmt = connection.createStatement();
                        rs = stmt.executeQuery("show tables");
                        BitSet set = new BitSet(size);
                        while (rs.next()) {
                            String index;
                            String tableName = rs.getString("Tables_in_" + route.getDbServer().getDatabase());
                            if (!tableName.startsWith(String.valueOf(table) + "_") || !DBShardingManager.strIsEmpty(index = tableName.substring(table.length() + 1))) continue;
                            while (index.startsWith("0")) {
                                if (index.length() == 1) break;
                                index = index.substring(1);
                            }
                            int idx = Integer.parseInt(index);
                            set.set(idx, true);
                        }
                        int i = 0;
                        while (i < size) {
                            if ((drop || !set.get(i)) && i % dbSize == n) {
                                String tableName = table + "_" + DBShardingManager.replenishSuffixWith0(size, i) + i;
                                boolean res = false;
                                if (drop && (res = stmt.execute("drop table if exists " + tableName))) {
                                    LOG.info((Object)("drop table successfully, tableName=" + tableName));
                                }
                                String creator = this.tableCreator.get(table).replace("@#@#@", tableName);
                                System.out.println(creator);
                                res = stmt.execute(creator);
                                if (res) {
                                    LOG.info((Object)("create table successfully, tableName=" + tableName));
                                }
                            }
                            ++i;
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            if (stmt != null) {
                                stmt.close();
                            }
                            if (connection != null) {
                                manager.freeConnection(name, connection);
                            }
                            break block27;
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (connection != null) {
                            manager.freeConnection(name, connection);
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (connection != null) {
                        manager.freeConnection(name, connection);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ++n;
        }
    }

    public static void main(String[] args) {
        boolean dropflag = false;
        if (args.length > 0) {
            dropflag = Boolean.parseBoolean(args[0]);
        }
        DBShardingManager.getInstance().checkAndCreateDatabases(dropflag);
        DBShardingManager.getInstance().checkAndCreateTables(dropflag);
    }

    private DBConnectionManager getConnManager(DBServer server) {
        if (server == null) {
            throw new RuntimeException("param exception, server is null");
        }
        DBConnectionManager manager = DBConnectionManager.getInstance();
        if (manager.hasInitialized(server.getName())) {
            return manager;
        }
        manager.setDBDrivers(this.drivers.get(server.getDbtype()));
        String url = "jdbc:" + server.getDbtype() + "://" + server.getHost() + ":" + server.getPort() + "/" + server.getDatabase() + "?characterEncoding=" + server.getCharset();
        manager.setDBParams(server.getName(), url, server.getUser(), server.getPassword(), server.getMaxConn());
        LOG.info((Object)("initlized dbconnection pool, url -> " + url));
        return manager;
    }

    private int hash(String bizStr, int size) {
        String md5 = DBShardingManager.calcMD5(bizStr.toLowerCase());
        String head = md5.substring(0, 8);
        return (int)(Long.parseLong(head, 16) % (long)size);
    }

    static boolean strIsEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    static String replenishSuffixWith0(int size, int tableIndex) {
        if (tableIndex < 10) {
            return "00";
        }
        if (tableIndex < 100) {
            return "0";
        }
        return "";
    }

    private Connection getConnection(DBServer server) {
        Connection conn = this.getConnManager(server).getConnection(server.getName());
        while (conn == null) {
            LOG.warn((Object)(" get db connection failed, dbserver -> " + server));
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            conn = this.getConnManager(server).getConnection(server.getName());
        }
        return conn;
    }

    private void freeConnection(DBServer dbServer, Connection conn) {
        this.getConnManager(dbServer).freeConnection(dbServer.getName(), conn);
    }

    public int getShardingTableSize(String conName) {
        DBInstance dbInstance = this.dbInstances.get(conName);
        if (dbInstance == null) {
            throw new RuntimeException("Exception, there is none dbinstance named by " + conName);
        }
        return dbInstance.getSize();
    }

    public int getShardingDBSize(String conName) {
        DBInstance dbInstance = this.dbInstances.get(conName);
        if (dbInstance == null) {
            throw new RuntimeException("there is none dbinstance named by " + conName);
        }
        return dbInstance.getRoutes().size();
    }

    public Connection getConnection(String conName, int tableIndex) {
        DBInstance dbInstance = this.dbInstances.get(conName);
        if (dbInstance.getType().equalsIgnoreCase("router")) {
            int size = dbInstance.getSize();
            if (tableIndex >= size) {
                throw new RuntimeException("table index out of bound, table sharding size is" + size + ", but table_index=" + tableIndex);
            }
            int dbIndex = tableIndex % dbInstance.getRoutes().size();
            Route route = dbInstance.getRoutes().get(dbIndex);
            return this.getConnection(route.getDbServer());
        }
        throw new RuntimeException("Error, the biz conName is not a sharding database, conName -> " + conName);
    }

    public Connection getConnection(String conName, String bizStr) {
        if (DBShardingManager.strIsEmpty(bizStr)) {
            throw new RuntimeException("there is none dbInstance named by " + conName);
        }
        DBInstance dbInstance = this.dbInstances.get(conName);
        if (dbInstance == null) {
            throw new RuntimeException("there is none dbInstance named by " + conName);
        }
        if ("router".equalsIgnoreCase(dbInstance.getType())) {
            int dbIndex = this.hash(bizStr, dbInstance.getSize()) % dbInstance.getRoutes().size();
            Route route = dbInstance.getRoutes().get(dbIndex);
            return this.getConnection(route.getDbServer());
        }
        throw new RuntimeException("Exception, the biz conName is not a sharding database, conName -> " + conName);
    }

    public Connection getConnection(String conName) {
        DBInstance dbInstance = this.dbInstances.get(conName);
        if (dbInstance == null) {
            throw new RuntimeException("Exception, there is none dbinstance named by " + conName);
        }
        if ("router".equalsIgnoreCase(dbInstance.getType())) {
            throw new RuntimeException("Exception, the biz conName is a sharding database, another param ( bisstr, tableindex) is needed, conName -> " + conName);
        }
        return this.getConnection(dbInstance.getRoutes().get(0).getDbServer());
    }

    public void freeConnection(String conName, int tableIndex, Connection conn) {
        DBInstance instance = this.dbInstances.get(conName);
        if (instance == null) {
            throw new RuntimeException("Exception, there is none dbinstance named by " + conName);
        }
        if ("router".equalsIgnoreCase(instance.getType())) {
            int dbIndex = tableIndex % instance.getRoutes().size();
            Route route = instance.getRoutes().get(dbIndex);
            this.freeConnection(route.getDbServer(), conn);
            return;
        }
        throw new RuntimeException("Exception, the biz conName is not a sharding database, conName -> " + conName);
    }

    public void freeConnection(String conName, int tableIndex, Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)e);
        }
        this.freeConnection(conName, tableIndex, conn);
    }

    public void freeConnection(String conName, int tableIndex, Connection conn, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)e);
        }
        this.freeConnection(conName, tableIndex, conn);
    }

    public void freeConnection(String conName, String str, Connection conn) {
        DBInstance instance = this.dbInstances.get(conName);
        if (instance == null) {
            throw new RuntimeException("there is none dbinstance named by " + conName);
        }
        if ("router".equalsIgnoreCase(instance.getType())) {
            int tableIndex = this.hash(str, instance.getSize());
            int dbIndex = tableIndex % instance.getRoutes().size();
            Route route = instance.getRoutes().get(dbIndex);
            this.freeConnection(route.getDbServer(), conn);
            return;
        }
        throw new RuntimeException("Exception, the biz conName is not a sharding database, conName -> " + conName);
    }

    public void freeConnection(String conName, String str, Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)e);
        }
        this.freeConnection(conName, str, conn);
    }

    public void freeConnection(String conName, String str, Connection conn, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)e);
        }
        this.freeConnection(conName, str, conn);
    }

    public void freeConnection(String conName, Connection conn) {
        DBInstance instance = this.dbInstances.get(conName);
        if ("router".equalsIgnoreCase(instance.getType())) {
            throw new RuntimeException("Exception, the biz conName is a sharding database, another param ( bisstr, tableindex) is needed, conName -> " + conName);
        }
        Route route = instance.getRoutes().get(0);
        this.freeConnection(route.getDbServer(), conn);
    }

    public void freeConnection(String conName, Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)e);
        }
        this.freeConnection(conName, conn);
    }

    public void freeConnection(String conName, Connection conn, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)e);
        }
        this.freeConnection(conName, conn);
    }

    public String getTableName(String table, int tableIndex) {
        StringBuilder tableName = new StringBuilder().append(table).append("_");
        int size = this.getTableShardingSize(table);
        if (tableIndex >= size) {
            throw new RuntimeException("table index out of bound, sharding_size=" + size + ", but table_index=" + tableIndex);
        }
        return tableName.append(DBShardingManager.replenishSuffixWith0(size, tableIndex)).append(tableIndex).toString();
    }

    public String getTableName(String table, String bizStr) {
        StringBuilder tableName = new StringBuilder().append(table).append("_");
        int size = this.getTableShardingSize(table);
        int tableIndex = this.hash(bizStr, size);
        return tableName.append(DBShardingManager.replenishSuffixWith0(size, tableIndex)).append(tableIndex).toString();
    }

    public static void main2(String[] args) throws SQLException {
        PropertyConfigurator.configure((String)"/home/ian/dev/crawldispatch/conf/log4j.properties");
        String cid = "Cdida";
        int j = 0;
        while (j < 20) {
            final int ii = j++;
            Thread t = new Thread(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < 50) {
                        block7: {
                            String url = "http://wuxi.didatuan.com/" + ii + "_" + i;
                            String bizStr = "Cdida_" + url;
                            Connection conn = null;
                            try {
                                try {
                                    conn = DBShardingManager.getInstance().getConnection("task_list", bizStr);
                                    String table = DBShardingManager.getInstance().getTableName("itemlist", bizStr);
                                    System.out.println(table);
                                    Statement stmt = conn.createStatement();
                                    ResultSet rs = stmt.executeQuery("select * from " + table + " where listurl='" + url + "'");
                                    if (rs.next()) {
                                        System.out.println(rs.getInt("rid"));
                                    }
                                }
                                catch (Exception e) {
                                    System.out.println(e);
                                    DBShardingManager.getInstance().freeConnection("task_list", bizStr, conn);
                                    break block7;
                                }
                            }
                            catch (Throwable throwable) {
                                DBShardingManager.getInstance().freeConnection("task_list", bizStr, conn);
                                throw throwable;
                            }
                            DBShardingManager.getInstance().freeConnection("task_list", bizStr, conn);
                        }
                        System.out.println(String.valueOf(ii) + "---" + i);
                        ++i;
                    }
                }
            };
            t.start();
        }
    }

    public static String calcMD5(String data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return DBShardingManager.toHexString(md.digest(data.getBytes()));
        }
        catch (Exception x) {
            LOG.warn((Object)("calc MD5 error, msg:" + x.getMessage()));
            return "";
        }
    }

    public static String toHexString(byte[] b) {
        StringBuffer s = new StringBuffer(2 * b.length);
        int i = 0;
        while (i < b.length) {
            int v = b[i] & 0xFF;
            s.append((char)_hexChars[v >> 4]);
            s.append((char)_hexChars[v & 0xF]);
            ++i;
        }
        return s.toString();
    }
}

