/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.EnumSet;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.NodeType;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.tree.BackedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeHelper {
    private static final EnumSet<NodeType> BRANCH_TYPE = EnumSet.of(NodeType.ELEMENT_NODE, NodeType.DOCUMENT_NODE);

    private NodeHelper() {
    }

    public static Attribute nodeAsAttribute(Node node) {
        if (node.getNodeTypeEnum() == NodeType.ATTRIBUTE_NODE) {
            assert (node instanceof Attribute);
            return (Attribute)node;
        }
        return null;
    }

    public static Branch nodeAsBranch(Node node) {
        if (BRANCH_TYPE.contains(node.getNodeType())) {
            assert (node instanceof Branch);
            return (Branch)node;
        }
        return null;
    }

    public static Document nodeAsDocument(Node node) {
        if (node.getNodeTypeEnum() == NodeType.DOCUMENT_NODE) {
            assert (node instanceof Document);
            return (Document)node;
        }
        return null;
    }

    public static Element nodeAsElement(Node node) {
        if (node.getNodeTypeEnum() == NodeType.ELEMENT_NODE) {
            assert (node instanceof Element);
            return (Element)node;
        }
        return null;
    }

    public static Namespace nodeAsNamespace(Node node) {
        if (node.getNodeTypeEnum() == NodeType.NAMESPACE_NODE) {
            assert (node instanceof Namespace);
            return (Namespace)node;
        }
        return null;
    }

    public static ProcessingInstruction nodeAsProcessingInstruction(Node node) {
        if (node.getNodeTypeEnum() == NodeType.PROCESSING_INSTRUCTION_NODE) {
            assert (node instanceof ProcessingInstruction);
            return (ProcessingInstruction)node;
        }
        return null;
    }

    public static BackedList<Element> appendElementLocal(Node node, BackedList<Element> list) {
        Element element = NodeHelper.nodeAsElement(node);
        if (element != null) {
            list.addLocal(element);
        }
        return list;
    }

    public static BackedList<Element> appendElementNamedLocal(Node node, BackedList<Element> list, String name) {
        Element element = NodeHelper.nodeAsElement(node);
        if (element != null && name.equals(element.getName())) {
            list.addLocal(element);
        }
        return list;
    }

    public static BackedList<Element> appendElementQNamedLocal(Node node, BackedList<Element> list, QName qname) {
        Element element = NodeHelper.nodeAsElement(node);
        if (element != null && qname.equals(element.getQName())) {
            list.addLocal(element);
        }
        return list;
    }

    public static String getAttributeValue(Attribute attribute, String defaultValue) {
        return attribute == null ? defaultValue : attribute.getValue();
    }
}

