/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.List;
import org.dom4j.Node;
import org.dom4j.tree.AbstractBranch;
import org.dom4j.tree.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackedList<T extends Node>
extends LazyList<T> {
    private final List<Node> branchContent;
    private final AbstractBranch branch;

    public BackedList(AbstractBranch branch, List<Node> branchContent) {
        this.branch = branch;
        this.branchContent = branchContent;
    }

    public BackedList(AbstractBranch branch, List<Node> branchContent, List<T> initialContent) {
        this(branch, branchContent);
        this.addAll(initialContent);
    }

    @Override
    public boolean add(T node) {
        this.branch.addNode((Node)node);
        return super.add(node);
    }

    @Override
    public void add(int index, T node) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index value: " + index + " is less than zero");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index value: " + index + " cannot be greater than " + "the size: " + this.size());
        }
        int realIndex = this.size() == 0 ? this.branchContent.size() : (index < this.size() ? this.branchContent.indexOf(this.get(index)) : this.branchContent.indexOf(this.get(this.size() - 1)) + 1);
        this.branch.addNode(realIndex, (Node)node);
        super.add(index, node);
    }

    @Override
    public T set(int index, T node) {
        int realIndex = this.branchContent.indexOf(this.get(index));
        if (realIndex < 0) {
            int n = realIndex = index == 0 ? 0 : Integer.MAX_VALUE;
        }
        if (realIndex < this.branchContent.size()) {
            this.branch.removeNode((Node)this.get(index));
            this.branch.addNode(realIndex, (Node)node);
        } else {
            this.branch.removeNode((Node)this.get(index));
            this.branch.addNode((Node)node);
        }
        this.branch.childAdded((Node)node);
        return (T)((Node)super.set(index, node));
    }

    public boolean remove(Node node) {
        this.branch.removeNode(node);
        return super.remove(node);
    }

    @Override
    public T remove(int index) {
        Node node = (Node)super.remove(index);
        if (node != null) {
            this.branch.removeNode(node);
        }
        return (T)node;
    }

    @Override
    public void clear() {
        for (Node node : this) {
            this.branchContent.remove(node);
            this.branch.childRemoved(node);
        }
        super.clear();
    }

    public void addLocal(T node) {
        super.add(node);
    }
}

