/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.NodeHelper;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.CloneHelper;
import org.dom4j.tree.ContentListFacade;
import org.dom4j.tree.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultElement
extends AbstractElement {
    private static final transient DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();
    private QName qname;
    private Branch parentBranch;
    private List<Node> content = new LazyList<Node>();
    private final List<Attribute> attributes;

    public DefaultElement(String name) {
        this(DOCUMENT_FACTORY.createQName(name));
    }

    public DefaultElement(QName qname) {
        this(qname, 0);
    }

    public DefaultElement(QName qname, int attributeCount) {
        this.qname = qname;
        this.attributes = new LazyList<Attribute>();
    }

    public DefaultElement(String name, Namespace namespace) {
        this(DOCUMENT_FACTORY.createQName(name, namespace));
    }

    @Override
    public Element getParent() {
        Element result = null;
        if (this.parentBranch instanceof Element) {
            result = (Element)this.parentBranch;
        }
        return result;
    }

    @Override
    public void setParent(Element parent) {
        if (this.parentBranch instanceof Element || parent != null) {
            this.parentBranch = parent;
        }
    }

    @Override
    public Document getDocument() {
        if (this.parentBranch instanceof Document) {
            return (Document)this.parentBranch;
        }
        if (this.parentBranch instanceof Element) {
            Element parent = (Element)this.parentBranch;
            return parent.getDocument();
        }
        return null;
    }

    @Override
    public void setDocument(Document document) {
        if (this.parentBranch instanceof Document || document != null) {
            this.parentBranch = document;
        }
    }

    @Override
    public boolean supportsParent() {
        return true;
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    @Override
    public void setQName(QName name) {
        this.qname = name;
    }

    @Override
    public String getStringValue() {
        if (this.contentList().size() == 0) {
            return "";
        }
        if (this.contentList().size() == 1) {
            return this.getContentAsStringValue(this.contentList().get(0));
        }
        StringBuilder builder = new StringBuilder();
        for (Node node : this.contentList()) {
            String string = this.getContentAsStringValue(node);
            if (string.length() <= 0) continue;
            builder.append(string);
        }
        return builder.toString();
    }

    @Override
    public DefaultElement clone() {
        DefaultElement answer = (DefaultElement)super.clone();
        if (answer != this) {
            CloneHelper.setFinalLazyList(DefaultElement.class, answer, "attributes");
            CloneHelper.setFinalContent(DefaultElement.class, answer);
            answer.appendAttributes(this);
            answer.appendContent(this);
        }
        return answer;
    }

    @Override
    public Namespace getNamespaceForPrefix(String prefix) {
        Namespace answer;
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (prefix.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        List<Node> list = this.contentList();
        for (Node node : list) {
            Namespace namespace = NodeHelper.nodeAsNamespace(node);
            if (namespace == null || !prefix.equals(namespace.getPrefix())) continue;
            return namespace;
        }
        Element parent = this.getParent();
        if (parent != null && (answer = parent.getNamespaceForPrefix(prefix)) != null) {
            return answer;
        }
        if (prefix == null || prefix.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        return null;
    }

    @Override
    public Namespace getNamespaceForURI(String uri) {
        if (uri == null || uri.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        if (uri.equals(this.getNamespaceURI())) {
            return this.getNamespace();
        }
        List<Node> list = this.contentList();
        for (Node node : list) {
            Namespace namespace = NodeHelper.nodeAsNamespace(node);
            if (namespace == null || !uri.equals(namespace.getURI())) continue;
            return namespace;
        }
        Element parent = this.getParent();
        if (parent != null) {
            return parent.getNamespaceForURI(uri);
        }
        return null;
    }

    @Override
    public List<Namespace> declaredNamespaces() {
        BackedList<Namespace> answer = this.createResultList();
        if (this.content != null) {
            for (Node node : this.content) {
                Namespace namespace = NodeHelper.nodeAsNamespace(node);
                if (namespace == null) continue;
                answer.addLocal(namespace);
            }
        }
        return answer;
    }

    @Override
    public List<Namespace> additionalNamespaces() {
        BackedList<Namespace> answer = this.createResultList();
        for (Node node : this.contentList()) {
            Namespace namespace = NodeHelper.nodeAsNamespace(node);
            if (namespace == null || namespace.equals(this.getNamespace())) continue;
            answer.addLocal(namespace);
        }
        return answer;
    }

    @Override
    public List<Namespace> additionalNamespaces(String defaultNamespaceURI) {
        BackedList<Namespace> answer = this.createResultList();
        for (Node node : this.contentList()) {
            Namespace namespace = NodeHelper.nodeAsNamespace(node);
            if (namespace == null || defaultNamespaceURI.equals(namespace.getURI())) continue;
            answer.addLocal(namespace);
        }
        return answer;
    }

    @Override
    public List<ProcessingInstruction> processingInstructions() {
        BackedList<ProcessingInstruction> answer = this.createResultList();
        for (Node node : this.contentList()) {
            ProcessingInstruction pi = NodeHelper.nodeAsProcessingInstruction(node);
            if (pi == null) continue;
            answer.addLocal(pi);
        }
        return answer;
    }

    @Override
    public List<ProcessingInstruction> processingInstructions(String target) {
        BackedList<ProcessingInstruction> answer = this.createResultList();
        for (Node node : this.contentList()) {
            ProcessingInstruction pi = NodeHelper.nodeAsProcessingInstruction(node);
            if (pi == null || !target.equals(pi.getName())) continue;
            answer.addLocal(pi);
        }
        return answer;
    }

    @Override
    public ProcessingInstruction processingInstruction(String target) {
        for (Node node : this.contentList()) {
            ProcessingInstruction pi = NodeHelper.nodeAsProcessingInstruction(node);
            if (pi == null || !target.equals(pi.getName())) continue;
            return pi;
        }
        return null;
    }

    @Override
    public boolean removeProcessingInstruction(String target) {
        Iterator<Node> iterator = this.content.iterator();
        while (iterator.hasNext()) {
            ProcessingInstruction pi = NodeHelper.nodeAsProcessingInstruction(iterator.next());
            if (pi == null || !target.equals(pi.getName())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public Element element(String name) {
        for (Node node : this.contentList()) {
            Element element = NodeHelper.nodeAsElement(node);
            if (element == null || !name.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    @Override
    public Element element(QName qName) {
        for (Node node : this.contentList()) {
            Element element = NodeHelper.nodeAsElement(node);
            if (element == null || !qName.equals(element.getQName())) continue;
            return element;
        }
        return null;
    }

    @Override
    public Element element(String name, Namespace namespace) {
        return this.element(this.getDocumentFactory().createQName(name, namespace));
    }

    @Override
    public void setContent(List<Node> content) {
        this.contentRemoved();
        if (content instanceof ContentListFacade) {
            content = ((ContentListFacade)content).getBackingList();
        }
        List<Node> newContent = this.createContentList();
        if (content != null) {
            for (Node node : content) {
                Element parent = node.getParent();
                if (parent != null && parent != this) {
                    node = (Node)node.clone();
                }
                newContent.add(node);
                this.childAdded(node);
            }
        }
        this.content = newContent;
    }

    @Override
    public void clearContent() {
        assert (this.content != null);
        this.contentRemoved();
        this.content.clear();
    }

    @Override
    public Node node(int index) {
        if (index < 0 || index >= this.contentList().size()) {
            return null;
        }
        return this.contentList().get(index);
    }

    @Override
    public int indexOf(Node node) {
        return this.contentList().indexOf(node);
    }

    @Override
    public int nodeCount() {
        return this.contentList().size();
    }

    @Override
    public Iterator<Node> nodeIterator() {
        return this.contentList().iterator();
    }

    @Override
    public List<Attribute> attributes() {
        return new ContentListFacade<Attribute>(this, this.attributeList());
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        if (attributes instanceof ContentListFacade) {
            attributes = ((ContentListFacade)attributes).getBackingList();
        }
        this.attributes.clear();
        if (attributes != null) {
            this.attributes.addAll(attributes);
        }
    }

    @Override
    public Iterator<Attribute> attributeIterator() {
        return this.attributeList().iterator();
    }

    @Override
    public Attribute attribute(int index) {
        if (index < 0 || index >= this.attributeList().size()) {
            return null;
        }
        return this.attributeList().get(index);
    }

    @Override
    public int attributeCount() {
        return this.attributeList().size();
    }

    @Override
    public Attribute attribute(String name) {
        for (Attribute attribute : this.attributeList()) {
            if (!name.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public Attribute attribute(QName qName) {
        for (Attribute attribute : this.attributeList()) {
            if (!qName.equals(attribute.getQName())) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public Attribute attribute(String name, Namespace namespace) {
        return this.attribute(this.getDocumentFactory().createQName(name, namespace));
    }

    @Override
    public void add(Attribute attribute) {
        if (attribute.getParent() != null) {
            String message = "The Attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, (Node)attribute, message);
        }
        if (attribute.getValue() == null) {
            Attribute oldAttribute = this.attribute(attribute.getQName());
            if (oldAttribute != null) {
                this.remove(oldAttribute);
            }
        } else {
            this.attributeList().add(attribute);
            this.childAdded(attribute);
        }
    }

    @Override
    public boolean remove(Attribute attribute) {
        Attribute copy;
        boolean answer = this.attributeList().remove(attribute);
        if (!answer && (copy = this.attribute(attribute.getQName())) != null) {
            answer = this.attributeList().remove(copy);
        }
        if (answer) {
            this.childRemoved(attribute);
        }
        return answer;
    }

    @Override
    protected void addNewNode(Node node) {
        this.contentList().add(node);
        this.childAdded(node);
    }

    @Override
    protected boolean removeNode(Node node) {
        boolean answer = this.contentList().remove(node);
        if (answer) {
            this.childRemoved(node);
        }
        return answer;
    }

    @Override
    protected List<Node> contentList() {
        assert (this.content != null);
        return this.content;
    }

    protected void setAttributeList(List<Attribute> attributeList) {
        this.attributeList().clear();
        this.attributeList().addAll(attributeList);
    }

    @Override
    protected DocumentFactory getDocumentFactory() {
        DocumentFactory factory = this.qname.getDocumentFactory();
        return factory != null ? factory : DOCUMENT_FACTORY;
    }

    @Override
    protected List<Attribute> attributeList() {
        assert (this.attributes != null);
        return this.attributes;
    }

    @Override
    @Deprecated
    protected List<Attribute> attributeList(int attributeCount) {
        assert (this.attributes != null);
        return this.attributes;
    }
}

