/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.elasti;

import com.bfd.crawler.elasti.producer.ProducerCache;
import com.bfd.crawler.elasti.utils.ESClientFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElastiProducer {
    public static Map<String, ElastiProducer> elastiProducerMap = new HashMap<String, ElastiProducer>();
    private String indexName;
    private ProducerCache producerCache;

    private ElastiProducer(int bussinessType, int esServerName, String indexName, String indexType) {
        this.indexName = indexName;
        ESClientFactory eSClientFactory = ESClientFactory.getInstance(esServerName);
        if (!eSClientFactory.isExistsIndex(esServerName, indexName)) {
            try {
                if (bussinessType == 1) {
                    String properties = eSClientFactory.readFile("./foreground");
                    eSClientFactory.createIndex(indexName, properties);
                } else if (indexName.endsWith("_comment")) {
                    String propertiesComment = eSClientFactory.readFile("./comment");
                    eSClientFactory.createIndex(indexName, propertiesComment);
                } else if (indexName.endsWith("_content")) {
                    String propertiesContent = eSClientFactory.readFile("./content");
                    eSClientFactory.createIndex(indexName, propertiesContent);
                } else if (indexName.endsWith("_user")) {
                    String propertiesUser = eSClientFactory.readFile("./user");
                    eSClientFactory.createIndex(indexName, propertiesUser);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("\u7d22\u5f15\u5df2\u7ecf\u5b58\u5728" + indexName);
            }
        }
        this.producerCache = new ProducerCache(esServerName, this.indexName, indexType, eSClientFactory);
    }

    public static synchronized ElastiProducer getInstance(int bussinessType, int esServerName, String indexName, String indexType) {
        if (!elastiProducerMap.containsKey(esServerName + "#" + indexName)) {
            ElastiProducer elastiProducer = new ElastiProducer(bussinessType, esServerName, indexName, indexType);
            elastiProducerMap.put(esServerName + "#" + indexName, elastiProducer);
            return elastiProducer;
        }
        return elastiProducerMap.get(esServerName + "#" + indexName);
    }

    public void sendMessageToEs(List<String> messages) {
        if (messages.size() > 0) {
            for (String message : messages) {
                this.producerCache.addCache(message);
            }
        }
    }

    public void sendMessageToEs(String message) {
        this.producerCache.addCache(message);
    }

    public int getImportESNum() {
        return this.producerCache.getTotalNum();
    }

    public void send(String json) {
        this.producerCache.addData(json);
    }
}

