/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.elasti;

import com.bfd.crawler.elasti.utils.ESClientFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class ElatiIndexManager {
    private RestHighLevelClient restClient;
    public static Map<Integer, ElatiIndexManager> elatiIndexManagerMap = new HashMap<Integer, ElatiIndexManager>();

    public static boolean isExistsIndex(String indexName) {
        return false;
    }

    private ElatiIndexManager(int esServerName) {
        this.restClient = ESClientFactory.getInstance(esServerName).getHighLevelClient();
    }

    public static ElatiIndexManager getInstance(int esServerName) {
        if (elatiIndexManagerMap.containsKey(esServerName)) {
            return elatiIndexManagerMap.get(esServerName);
        }
        ElatiIndexManager elatiIndexManager = new ElatiIndexManager(esServerName);
        elatiIndexManagerMap.put(esServerName, elatiIndexManager);
        return elatiIndexManager;
    }

    public long getindexNum(String indexName) {
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        long totalNum = 0L;
        try {
            searchResponse = this.restClient.search(searchRequest, new Header[0]);
            totalNum = searchResponse.getHits().getTotalHits();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return totalNum;
    }
}

