/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.elasti.consumer;

import com.bfd.crawler.elasti.consumer.extendType.ConsumerExtendType;
import com.bfd.crawler.elasti.utils.ESClientFactory;
import com.bfd.crawler.elasti.utils.JsonUtils;
import com.bfd.crawler.elasti.utils.PropertiesParser;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerThread
implements Runnable {
    private BlockingQueue<String> queue;
    private String indexName;
    private RestHighLevelClient restClient;
    private String conditions;
    private String packName = "com.bfd.crawler.elasti.consumer.extendType";
    private static PropertiesParser prop = new PropertiesParser("../etc/elasticsearch.properties");
    private int quaryNum = prop.getIntProperty("crawl.elasticsearch.consumer.quary.num");
    private long scrollTime = prop.getIntProperty("crawl.elasticsearch.consumer.scroll.time");
    private Map<String, Object> conditionsMap;

    public ConsumerThread(BlockingQueue<String> queue, String indexName, String conditions) {
        this.queue = queue;
        this.indexName = indexName;
        this.conditions = conditions;
        this.restClient = ESClientFactory.getInstance(1).getHighLevelClient();
    }

    @Override
    public void run() {
        try {
            this.conditionsMap = StringUtils.isNotBlank((CharSequence)this.conditions) ? (Map<Object, Object>)JsonUtils.parseObject(this.conditions) : new HashMap<String, Object>();
            this.quaryFromEs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void quaryFromEs() {
        try {
            Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)this.scrollTime));
            SearchRequest searchRequest = new SearchRequest(new String[]{this.indexName});
            searchRequest.scroll(scroll);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            if (this.conditionsMap.size() > 0) {
                BoolQueryBuilder mustQuery = QueryBuilders.boolQuery();
                for (Map.Entry<String, Object> entry : this.conditionsMap.entrySet()) {
                    SearchHit[] mapKey = entry.getKey();
                    mapKey = mapKey.substring(0, 1).toUpperCase().concat(mapKey.substring(1));
                    ConsumerExtendType cet = (ConsumerExtendType)Class.forName(this.packName + "." + (String)mapKey + "ConsumerExtendType").newInstance();
                    cet.exec(JsonUtils.toJSONString(entry.getValue()), mustQuery);
                }
                searchSourceBuilder.query((QueryBuilder)mustQuery);
            } else {
                searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
            }
            searchSourceBuilder.size(this.quaryNum);
            searchRequest.source(searchSourceBuilder);
            SearchResponse searchResponse = null;
            searchResponse = this.restClient.search(searchRequest, new Header[0]);
            String scrollId = searchResponse.getScrollId();
            SearchHit[] searchHits = searchResponse.getHits().getHits();
            if (searchHits != null && searchHits.length > 0) {
                for (SearchHit searchHit : searchHits) {
                    this.queue.put(searchHit.getSourceAsString());
                }
            }
            while (searchHits != null && searchHits.length > 0) {
                SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
                scrollRequest.scroll(scroll);
                searchResponse = this.restClient.searchScroll(scrollRequest, new Header[0]);
                scrollId = searchResponse.getScrollId();
                searchHits = searchResponse.getHits().getHits();
                if (searchHits == null || searchHits.length <= 0) continue;
                for (SearchHit searchHit : searchHits) {
                    this.queue.put(searchHit.getSourceAsString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

