/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.elasti.producer;

import com.bfd.crawler.elasti.producer.ProducerProcess;
import com.bfd.crawler.elasti.utils.ESClientFactory;
import com.bfd.crawler.elasti.utils.PropertiesParser;
import java.util.Vector;

public class ProducerCache {
    private int currentCacheNum = 0;
    private Vector<String> cacheData = new Vector();
    private PropertiesParser prop;
    private long maxOutWriteTime;
    private int maxCacheRowNum;
    private long lastWriteTime = System.currentTimeMillis();
    private ProducerProcess producerProcess;

    public ProducerCache(int esServerName, String indexName, String indexType, ESClientFactory eSClientFactory) {
        this.prop = esServerName == 1 ? new PropertiesParser("../etc/elasticsearch_148.properties") : new PropertiesParser("../etc/elasticsearch_158.properties");
        this.maxOutWriteTime = this.prop.getLongProperty("crawl.elasticsearch.producer.max.write.time");
        this.maxCacheRowNum = this.prop.getIntProperty("crawl.elasticsearch.producer.max.cache.num");
        this.producerProcess = new ProducerProcess(indexName, indexType, eSClientFactory);
        new Thread(new CheckWirteTimeOut()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCache(String dataMap) {
        Vector<String> vector = this.cacheData;
        synchronized (vector) {
            ++this.currentCacheNum;
            this.cacheData.add(dataMap);
            if (this.currentCacheNum >= this.maxCacheRowNum) {
                this.writeEs();
            }
        }
    }

    public int getTotalNum() {
        return this.producerProcess.getTotalImportEsNum();
    }

    public void addData(String json) {
        this.producerProcess.addData(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEs() {
        Vector<String> vector = this.cacheData;
        synchronized (vector) {
            this.producerProcess.createManyDates(this.cacheData);
            this.cacheData = new Vector();
        }
        this.currentCacheNum = 0;
        this.lastWriteTime = System.currentTimeMillis();
    }

    class CheckWirteTimeOut
    implements Runnable {
        CheckWirteTimeOut() {
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (System.currentTimeMillis() - ProducerCache.this.lastWriteTime > ProducerCache.this.maxOutWriteTime) {
                            ProducerCache.this.writeEs();
                        }
                        Thread.sleep(60000L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

