/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.elasti.utils;

import com.bfd.crawler.elasti.utils.PropertiesParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;

public class ESClientFactory {
    private PropertiesParser prop;
    private String brokerlist;
    private int socket_timeout;
    private int connect_timeout;
    private int max_connect_num;
    private int max_connect_per_route;
    private int max_retry_timeout;
    private boolean uniqueConnectTimeConfig = false;
    private boolean uniqueConnectNumConfig = true;
    private RestClientBuilder builder;
    private RestClient restClient;
    private RestHighLevelClient restHighLevelClient;
    public static Map<Integer, ESClientFactory> eSClientFactoryMap = new HashMap<Integer, ESClientFactory>();
    public static Map<String, String> indexMap = new HashMap<String, String>();

    private ESClientFactory(int esServerName) {
        this.prop = esServerName == 1 ? new PropertiesParser("../etc/elasticsearch_148.properties") : new PropertiesParser("../etc/elasticsearch_158.properties");
        this.brokerlist = this.prop.getStringProperty("crawl.elasticsearch.metadata.broker.list");
        this.socket_timeout = this.prop.getIntProperty("crawl.elasticsearch.socket.timeout.interval.ms");
        this.connect_timeout = this.prop.getIntProperty("crawl.elasticsearch.connect.timeout.ms");
        this.max_connect_num = this.prop.getIntProperty("crawl.elasticsearch.max.connect.num");
        this.max_connect_per_route = this.prop.getIntProperty("crawl.elasticsearch.max.connect.per.route.num");
        this.max_retry_timeout = this.prop.getIntProperty("crawl.elasticsearch.max.retry.timeout");
        String[] brokers = this.brokerlist.split(",");
        HttpHost[] httpHosts = new HttpHost[brokers.length];
        for (int i = 0; i < brokers.length; ++i) {
            String[] brokerIpHost = brokers[i].split(":");
            httpHosts[i] = new HttpHost(brokerIpHost[0], Integer.valueOf(brokerIpHost[1]).intValue(), "http");
        }
        this.builder = RestClient.builder((HttpHost[])httpHosts);
        if (this.uniqueConnectTimeConfig) {
            this.setConnectTimeOutConfig();
        }
        if (this.uniqueConnectNumConfig) {
            this.setMutiConnectConfig();
        }
        this.restHighLevelClient = new RestHighLevelClient(this.builder);
    }

    public boolean createIndex(String indexName, String properties) {
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        request.settings(Settings.builder().put("index.number_of_shards", "5").put("index.number_of_replicas", "1"));
        request.mapping("docs", "  {\n    \"docs\": {\n      \"properties\": {\n" + properties + "      }\n" + "    }\n" + "  }", XContentType.JSON);
        CreateIndexResponse indexResponse = null;
        try {
            indexResponse = this.restHighLevelClient.indices().create(request, new Header[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return indexResponse.isAcknowledged();
    }

    public boolean isExistsIndex(int esServerName, String indexName) {
        if (indexMap.containsKey(esServerName + "#" + indexName)) {
            return true;
        }
        indexMap.put(esServerName + "#" + indexName, indexName);
        return false;
    }

    public String readFile(String filedir) {
        try {
            String commentrow;
            File commentF = new File(filedir);
            BufferedReader commentbr = new BufferedReader(new FileReader(commentF));
            StringBuffer commentProperties = new StringBuffer();
            while ((commentrow = commentbr.readLine()) != null) {
                String row = commentrow.trim();
                if (row.startsWith("type")) {
                    // empty if block
                }
                commentProperties.append(commentrow + "\n");
            }
            commentbr.close();
            return commentProperties.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static ESClientFactory getInstance(int esServerName) {
        if (eSClientFactoryMap.containsKey(esServerName)) {
            return eSClientFactoryMap.get(esServerName);
        }
        ESClientFactory eSClientFactory = new ESClientFactory(esServerName);
        eSClientFactoryMap.put(esServerName, eSClientFactory);
        return eSClientFactory;
    }

    public void setConnectTimeOutConfig() {
        this.builder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                requestConfigBuilder.setConnectTimeout(ESClientFactory.this.socket_timeout);
                requestConfigBuilder.setSocketTimeout(ESClientFactory.this.socket_timeout);
                requestConfigBuilder.setConnectionRequestTimeout(ESClientFactory.this.connect_timeout);
                return requestConfigBuilder;
            }
        });
    }

    public void setMutiConnectConfig() {
        this.builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                httpClientBuilder.setMaxConnTotal(ESClientFactory.this.max_connect_num);
                httpClientBuilder.setMaxConnPerRoute(ESClientFactory.this.max_connect_per_route);
                return httpClientBuilder;
            }
        }).setMaxRetryTimeoutMillis(this.max_retry_timeout);
    }

    public RestClient getClient() {
        return this.restClient;
    }

    public RestHighLevelClient getHighLevelClient() {
        return this.restHighLevelClient;
    }

    public void close() {
        if (this.restClient != null) {
            try {
                this.restClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

