/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdht;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Arrays;

public class ProtoCommon {
    public static final byte FDHT_PROTO_CMD_QUIT = 10;
    public static final byte FDHT_PROTO_CMD_SET = 11;
    public static final byte FDHT_PROTO_CMD_INC = 12;
    public static final byte FDHT_PROTO_CMD_GET = 13;
    public static final byte FDHT_PROTO_CMD_DEL = 14;
    public static final byte FDHT_PROTO_CMD_BATCH_SET = 15;
    public static final byte FDHT_PROTO_CMD_BATCH_GET = 16;
    public static final byte FDHT_PROTO_CMD_BATCH_DEL = 17;
    public static final byte FDHT_PROTO_CMD_STAT = 18;
    public static final byte FDHT_PROTO_CMD_GET_SUB_KEYS = 19;
    public static final byte FDHT_PROTO_CMD_HEART_BEAT = 30;
    public static final byte FDHT_PROTO_CMD_RESP = 40;
    public static final int PROTO_HEADER_BODY_LEN_INDEX = 0;
    public static final int PROTO_HEADER_KEY_HASH_CODE_INDEX = 4;
    public static final int PROTO_HEADER_TIMESTAMP_INDEX = 8;
    public static final int PROTO_HEADER_EXPIRES_INDEX = 12;
    public static final int PROTO_HEADER_CMD_INDEX = 16;
    public static final int PROTO_HEADER_KEEP_ALIVE_INDEX = 17;
    public static final int PROTO_HEADER_STATUS_INDEX = 18;
    public static final int FDHT_PROTO_PKG_HEADER_SIZE = 19;
    public static final int FDHT_MAX_NAMESPACE_LEN = 64;
    public static final int FDHT_MAX_OBJECT_ID_LEN = 128;
    public static final int FDHT_MAX_SUB_KEY_LEN = 128;
    public static final byte FDHT_FULL_KEY_SEPERATOR = 1;
    public static final char FDHT_KEY_LIST_SEP_CHAR = '\u0001';
    public static final String FDHT_KEY_LIST_SEP_STR = String.valueOf('\u0001');
    public static final int FDHT_EXPIRES_NEVER = 0;
    public static final int FDHT_EXPIRES_NONE = -1;
    public static final int FDHT_MAX_FULL_KEY_LEN = 322;

    private ProtoCommon() {
    }

    public static void packHeader(PkgHeader header, byte[] bs) throws UnsupportedEncodingException {
        Arrays.fill(bs, 0, 19, (byte)0);
        ProtoCommon.int2buff(header.body_len, bs, 0);
        ProtoCommon.int2buff(header.key_hash_code, bs, 4);
        ProtoCommon.int2buff(header.timestamp, bs, 8);
        ProtoCommon.int2buff(header.expires, bs, 12);
        bs[16] = header.cmd;
        bs[17] = header.keep_alive;
        bs[18] = header.status;
    }

    public static PkgHeader recvHeader(InputStream in, byte expect_cmd, long expect_body_len) throws IOException {
        PkgHeader header = new PkgHeader();
        byte[] bs = new byte[19];
        int bytes = in.read(bs);
        if (bytes != bs.length) {
            throw new IOException("recv package size " + bytes + " != " + bs.length);
        }
        header.cmd = bs[16];
        if (header.cmd != expect_cmd) {
            throw new IOException("recv cmd: " + bs[16] + " is not correct, expect cmd: " + expect_cmd);
        }
        header.status = bs[18];
        header.body_len = ProtoCommon.buff2int(bs, 0);
        if (header.body_len < 0) {
            throw new IOException("recv body length: " + header.body_len + " < 0!");
        }
        if (header.status == 0) {
            if (expect_body_len >= 0L && (long)header.body_len != expect_body_len) {
                throw new IOException("recv body length: " + header.body_len + " is not correct, expect length: " + expect_body_len);
            }
            header.timestamp = ProtoCommon.buff2int(bs, 8);
            header.expires = ProtoCommon.buff2int(bs, 12);
        }
        return header;
    }

    public static PkgInfo recvPackage(InputStream in, byte expect_cmd, long expect_body_len) throws IOException {
        int bytes;
        PkgHeader header = ProtoCommon.recvHeader(in, expect_cmd, expect_body_len);
        if (header.status != 0) {
            return new PkgInfo(header, null);
        }
        byte[] body = new byte[header.body_len];
        int totalBytes = 0;
        int remainBytes = header.body_len;
        while (totalBytes < header.body_len && (bytes = in.read(body, totalBytes, remainBytes)) >= 0) {
            totalBytes += bytes;
            remainBytes -= bytes;
        }
        if (totalBytes != header.body_len) {
            throw new IOException("recv package size " + totalBytes + " != " + header.body_len);
        }
        return new PkgInfo(header, body);
    }

    public static void quit(Socket sock) throws IOException {
        byte[] bs = new byte[19];
        PkgHeader header = new PkgHeader();
        header.cmd = (byte)10;
        ProtoCommon.packHeader(header, bs);
        sock.getOutputStream().write(bs);
        sock.close();
    }

    public static byte[] int2buff(int n) {
        byte[] bs = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return bs;
    }

    public static void int2buff(int n, byte[] bs, int offset) {
        bs[offset] = (byte)(n >> 24 & 0xFF);
        bs[offset + 1] = (byte)(n >> 16 & 0xFF);
        bs[offset + 2] = (byte)(n >> 8 & 0xFF);
        bs[offset + 3] = (byte)(n & 0xFF);
    }

    public static int buff2int(byte[] bs, int offset) {
        return (bs[offset] >= 0 ? bs[offset] : 256 + bs[offset]) << 24 | (bs[offset + 1] >= 0 ? bs[offset + 1] : 256 + bs[offset + 1]) << 16 | (bs[offset + 2] >= 0 ? bs[offset + 2] : 256 + bs[offset + 2]) << 8 | (bs[offset + 3] >= 0 ? bs[offset + 3] : 256 + bs[offset + 3]);
    }

    public static class PkgInfo {
        public PkgHeader header;
        public byte[] body;

        public PkgInfo(PkgHeader header, byte[] body) {
            this.header = header;
            this.body = body;
        }
    }

    public static class PkgHeader {
        public int body_len;
        public int key_hash_code;
        public int timestamp;
        public int expires;
        public byte cmd;
        public byte keep_alive;
        public byte status;

        public PkgHeader() {
        }

        public PkgHeader(byte status, int body_len) {
            this.status = status;
            this.body_len = body_len;
        }
    }
}

