/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.model.perceptron.PerceptronTagger;
import com.hankcs.hanlp.model.perceptron.common.TaskType;
import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.instance.Instance;
import com.hankcs.hanlp.model.perceptron.instance.NERInstance;
import com.hankcs.hanlp.model.perceptron.model.LinearModel;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.tokenizer.lexical.NERecognizer;
import java.io.IOException;

public class PerceptronNERecognizer
extends PerceptronTagger
implements NERecognizer {
    final NERTagSet tagSet;

    public PerceptronNERecognizer(LinearModel nerModel) {
        super(nerModel);
        if (nerModel.tagSet().type != TaskType.NER) {
            throw new IllegalArgumentException(String.format("\u9519\u8bef\u7684\u6a21\u578b\u7c7b\u578b: \u4f20\u5165\u7684\u4e0d\u662f\u547d\u540d\u5b9e\u4f53\u8bc6\u522b\u6a21\u578b\uff0c\u800c\u662f %s \u6a21\u578b", new Object[]{nerModel.featureMap.tagSet.type}));
        }
        this.tagSet = (NERTagSet)this.model.tagSet();
    }

    public PerceptronNERecognizer(String nerModelPath) throws IOException {
        this(new LinearModel(nerModelPath));
    }

    public PerceptronNERecognizer() throws IOException {
        this(HanLP.Config.PerceptronNERModelPath);
    }

    @Override
    public String[] recognize(String[] wordArray, String[] posArray) {
        NERInstance instance = new NERInstance(wordArray, posArray, this.model.featureMap);
        return this.recognize(instance);
    }

    public String[] recognize(NERInstance instance) {
        instance.tagArray = new int[instance.size()];
        this.model.viterbiDecode(instance);
        return instance.tags(this.tagSet);
    }

    @Override
    public NERTagSet getNERTagSet() {
        return this.tagSet;
    }

    public boolean learn(String segmentedTaggedNERSentence) {
        return this.learn(NERInstance.create(segmentedTaggedNERSentence, this.model.featureMap));
    }

    @Override
    protected Instance createInstance(Sentence sentence, FeatureMap featureMap) {
        return NERInstance.create(sentence, featureMap);
    }
}

