/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;

public abstract class HBaseFileSystem {
    public static final Log LOG = LogFactory.getLog(HBaseFileSystem.class);
    protected static int hdfsClientRetriesNumber;
    private static int baseSleepBeforeRetries;
    private static final int DEFAULT_HDFS_CLIENT_RETRIES_NUMBER = 10;
    private static final int DEFAULT_BASE_SLEEP_BEFORE_RETRIES = 1000;

    public static boolean deleteFileFromFileSystem(FileSystem fs, Path dir) throws IOException {
        IOException lastIOE = null;
        int i = 0;
        while (true) {
            try {
                return fs.delete(dir, false);
            }
            catch (IOException ioe) {
                lastIOE = ioe;
                if (!fs.exists(dir)) {
                    return true;
                }
                HBaseFileSystem.sleepBeforeRetry("Delete File", i + 1);
                if (++i <= hdfsClientRetriesNumber) continue;
                throw new IOException("Exception in deleteFileFromFileSystem", lastIOE);
            }
            break;
        }
    }

    public static boolean deleteDirFromFileSystem(FileSystem fs, Path dir) throws IOException {
        IOException lastIOE = null;
        int i = 0;
        while (true) {
            try {
                return fs.delete(dir, true);
            }
            catch (IOException ioe) {
                lastIOE = ioe;
                if (!fs.exists(dir)) {
                    return true;
                }
                HBaseFileSystem.sleepBeforeRetry("Delete Dir", i + 1);
                if (++i <= hdfsClientRetriesNumber) continue;
                throw new IOException("Exception in deleteDirFromFileSystem", lastIOE);
            }
            break;
        }
    }

    protected static void setRetryCounts(Configuration conf) {
        hdfsClientRetriesNumber = conf.getInt("hdfs.client.retries.number", 10);
        baseSleepBeforeRetries = conf.getInt("hdfs.client.sleep.before.retries", 1000);
    }

    public static boolean makeDirOnFileSystem(FileSystem fs, Path dir) throws IOException {
        int i = 0;
        IOException lastIOE = null;
        while (true) {
            try {
                return fs.mkdirs(dir);
            }
            catch (IOException ioe) {
                lastIOE = ioe;
                if (fs.exists(dir)) {
                    return true;
                }
                HBaseFileSystem.sleepBeforeRetry("Create Directory", i + 1);
                if (++i <= hdfsClientRetriesNumber) continue;
                throw new IOException("Exception in makeDirOnFileSystem", lastIOE);
            }
            break;
        }
    }

    public static boolean renameDirForFileSystem(FileSystem fs, Path src, Path dst) throws IOException {
        IOException lastIOE = null;
        int i = 0;
        while (true) {
            try {
                return fs.rename(src, dst);
            }
            catch (IOException ioe) {
                lastIOE = ioe;
                if (!fs.exists(src) && fs.exists(dst)) {
                    return true;
                }
                HBaseFileSystem.sleepBeforeRetry("Rename Directory", i + 1);
                if (++i <= hdfsClientRetriesNumber) continue;
                throw new IOException("Exception in renameDirForFileSystem", lastIOE);
            }
            break;
        }
    }

    public static FSDataOutputStream createPathOnFileSystem(FileSystem fs, Path dir, boolean overwrite) throws IOException {
        int i = 0;
        boolean existsBefore = fs.exists(dir);
        IOException lastIOE = null;
        while (true) {
            try {
                return fs.create(dir, overwrite);
            }
            catch (IOException ioe) {
                lastIOE = ioe;
                if (existsBefore && !overwrite) {
                    throw ioe;
                }
                HBaseFileSystem.sleepBeforeRetry("Create Path", i + 1);
                if (++i <= hdfsClientRetriesNumber) continue;
                throw new IOException("Exception in createPathOnFileSystem", lastIOE);
            }
            break;
        }
    }

    public static FSDataOutputStream createPathWithPermsOnFileSystem(FileSystem fs, Path path, FsPermission perm, boolean overwrite) throws IOException {
        int i = 0;
        IOException lastIOE = null;
        boolean existsBefore = fs.exists(path);
        while (true) {
            try {
                return fs.create(path, perm, overwrite, FSUtils.getDefaultBufferSize(fs), FSUtils.getDefaultReplication(fs, path), FSUtils.getDefaultBlockSize(fs, path), null);
            }
            catch (IOException ioe) {
                lastIOE = ioe;
                if (existsBefore && !overwrite) {
                    throw ioe;
                }
                HBaseFileSystem.sleepBeforeRetry("Create Path with Perms", i + 1);
                if (++i <= hdfsClientRetriesNumber) continue;
                throw new IOException("Exception in createPathWithPermsOnFileSystem", lastIOE);
            }
            break;
        }
    }

    public static boolean createNewFileOnFileSystem(FileSystem fs, Path file) throws IOException {
        int i = 0;
        IOException lastIOE = null;
        while (true) {
            try {
                return fs.createNewFile(file);
            }
            catch (IOException ioe) {
                lastIOE = ioe;
                if (fs.exists(file)) {
                    return true;
                }
                HBaseFileSystem.sleepBeforeRetry("Create NewFile", i + 1);
                if (++i <= hdfsClientRetriesNumber) continue;
                throw new IOException("Exception in createNewFileOnFileSystem", lastIOE);
            }
            break;
        }
    }

    protected static void sleepBeforeRetry(String msg, int sleepMultiplier) {
        if (sleepMultiplier > hdfsClientRetriesNumber) {
            LOG.warn((Object)(msg + ", retries exhausted"));
            return;
        }
        LOG.info((Object)(msg + ", sleeping " + baseSleepBeforeRetries + " times " + sleepMultiplier));
        Threads.sleep(baseSleepBeforeRetries * sleepMultiplier);
    }

    public static boolean renameAndSetModifyTime(FileSystem fs, Path src, Path dest) throws IOException {
        fs.setTimes(src, EnvironmentEdgeManager.currentTimeMillis(), -1L);
        return HBaseFileSystem.renameDirForFileSystem(fs, src, dest);
    }

    static {
        HBaseFileSystem.setRetryCounts(HBaseConfiguration.create());
    }
}

