/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.ipc.RemoteException;

public abstract class ServerCallable<T>
implements Callable<T> {
    protected final HConnection connection;
    protected final byte[] tableName;
    protected final byte[] row;
    protected HRegionLocation location;
    protected HRegionInterface server;
    protected int callTimeout;
    protected long startTime;
    protected long endTime;

    public ServerCallable(HConnection connection, byte[] tableName, byte[] row) {
        this(connection, tableName, row, Integer.MAX_VALUE);
    }

    public ServerCallable(HConnection connection, byte[] tableName, byte[] row, int callTimeout) {
        this.connection = connection;
        this.tableName = tableName;
        this.row = row;
        this.callTimeout = callTimeout;
    }

    public void connect(boolean reload) throws IOException {
        this.location = this.connection.getRegionLocation(this.tableName, this.row, reload);
        this.server = this.connection.getHRegionConnection(this.location.getHostname(), this.location.getPort());
    }

    public String getServerName() {
        if (this.location == null) {
            return null;
        }
        return this.location.getHostnamePort();
    }

    public byte[] getRegionName() {
        if (this.location == null) {
            return null;
        }
        return this.location.getRegionInfo().getRegionName();
    }

    public byte[] getRow() {
        return this.row;
    }

    public void beforeCall() {
        HBaseRPC.setRpcTimeout(this.callTimeout);
        this.startTime = System.currentTimeMillis();
    }

    public void afterCall() {
        HBaseRPC.resetRpcTimeout();
        this.endTime = System.currentTimeMillis();
    }

    public void shouldRetry(Throwable throwable) throws IOException {
        if (this.callTimeout != Integer.MAX_VALUE) {
            if (throwable instanceof SocketTimeoutException || this.endTime - this.startTime > (long)this.callTimeout) {
                throw (SocketTimeoutException)new SocketTimeoutException("Call to access row '" + Bytes.toString(this.row) + "' on table '" + Bytes.toString(this.tableName) + "' failed on socket timeout exception: " + throwable).initCause(throwable);
            }
            this.callTimeout = (int)(this.endTime - this.startTime);
        }
    }

    HConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T withRetries() throws IOException, RuntimeException {
        Configuration c = this.getConnection().getConfiguration();
        long pause = c.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
        int numRetries = c.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        ArrayList<RetriesExhaustedException.ThrowableWithExtraContext> exceptions = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
        for (int tries = 0; tries < numRetries; ++tries) {
            try {
                this.beforeCall();
                this.connect(tries != 0);
                Object v = this.call();
                return (T)v;
            }
            catch (Throwable t) {
                this.shouldRetry(t);
                t = ServerCallable.translateException(t);
                if (t instanceof SocketTimeoutException || t instanceof ConnectException || t instanceof RetriesExhaustedException) {
                    HRegionLocation hrl = this.location;
                    if (hrl != null) {
                        this.getConnection().clearCaches(hrl.getHostnamePort());
                    }
                } else if (t instanceof NotServingRegionException && numRetries == 1) {
                    this.getConnection().deleteCachedRegionLocation(this.location);
                }
                RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext(t, System.currentTimeMillis(), this.toString());
                exceptions.add(qt);
                if (tries == numRetries - 1) {
                    throw new RetriesExhaustedException(tries, exceptions);
                }
            }
            finally {
                this.afterCall();
            }
            try {
                Thread.sleep(ConnectionUtils.getPauseTime(pause, tries));
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Giving up after tries=" + tries, e);
            }
        }
        return null;
    }

    public T withoutRetries() throws IOException, RuntimeException {
        try {
            this.beforeCall();
            this.connect(false);
            Object v = this.call();
            return (T)v;
        }
        catch (Throwable t) {
            Throwable t2 = ServerCallable.translateException(t);
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            throw new RuntimeException(t2);
        }
        finally {
            this.afterCall();
        }
    }

    private static Throwable translateException(Throwable t) throws IOException {
        if (t instanceof UndeclaredThrowableException) {
            t = t.getCause();
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        if (t instanceof DoNotRetryIOException) {
            throw (DoNotRetryIOException)t;
        }
        return t;
    }
}

