/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.ipc.Invocation;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Classes;

public class Exec
extends Invocation
implements Row {
    private byte[] referenceRow;
    private Class<? extends CoprocessorProtocol> protocol;
    private String protocolName;

    public Exec() {
    }

    public Exec(Configuration configuration, Class<? extends CoprocessorProtocol> protocol, Method method, Object[] parameters) {
        this(configuration, HConstants.EMPTY_BYTE_ARRAY, protocol, method, parameters);
    }

    public Exec(Configuration configuration, byte[] row, Class<? extends CoprocessorProtocol> protocol, Method method, Object[] parameters) {
        super(method, protocol, parameters);
        this.conf = configuration;
        this.referenceRow = row;
        this.protocol = protocol;
        this.protocolName = protocol.getName();
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public Class<? extends CoprocessorProtocol> getProtocol() {
        return this.protocol;
    }

    @Override
    public byte[] getRow() {
        return this.referenceRow;
    }

    public int compareTo(Row row) {
        return Bytes.compareTo(this.referenceRow, row.getRow());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.methodName);
        out.writeInt(this.parameterClasses.length);
        for (int i = 0; i < this.parameterClasses.length; ++i) {
            HbaseObjectWritable.writeObject(out, this.parameters[i], this.parameters[i] != null ? this.parameters[i].getClass() : this.parameterClasses[i], this.conf);
            out.writeUTF(this.parameterClasses[i].getName());
        }
        Bytes.writeByteArray(out, this.referenceRow);
        out.writeUTF(this.protocol.getName());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.methodName = in.readUTF();
        this.parameters = new Object[in.readInt()];
        this.parameterClasses = new Class[this.parameters.length];
        HbaseObjectWritable objectWritable = new HbaseObjectWritable();
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = HbaseObjectWritable.readObject(in, objectWritable, this.conf);
            String parameterClassName = in.readUTF();
            try {
                this.parameterClasses[i] = Classes.extendedForName(parameterClassName);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Couldn't find class: " + parameterClassName);
            }
        }
        this.referenceRow = Bytes.readByteArray(in);
        this.protocolName = in.readUTF();
    }
}

