/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CoprocessorClassLoader;
import org.apache.hadoop.hbase.util.SortedCopyOnWriteSet;
import org.apache.hadoop.hbase.util.VersionInfo;

public abstract class CoprocessorHost<E extends CoprocessorEnvironment> {
    public static final String REGION_COPROCESSOR_CONF_KEY = "hbase.coprocessor.region.classes";
    public static final String REGIONSERVER_COPROCESSOR_CONF_KEY = "hbase.coprocessor.regionserver.classes";
    public static final String USER_REGION_COPROCESSOR_CONF_KEY = "hbase.coprocessor.user.region.classes";
    public static final String MASTER_COPROCESSOR_CONF_KEY = "hbase.coprocessor.master.classes";
    public static final String WAL_COPROCESSOR_CONF_KEY = "hbase.coprocessor.wal.classes";
    private static final Log LOG = LogFactory.getLog(CoprocessorHost.class);
    protected SortedSet<E> coprocessors = new SortedCopyOnWriteSet<CoprocessorEnvironment>(new EnvironmentPriorityComparator());
    protected Configuration conf;
    protected String pathPrefix = UUID.randomUUID().toString();
    protected volatile int loadSequence;
    private static Set<String> coprocessorNames = Collections.synchronizedSet(new HashSet());

    public static Set<String> getLoadedCoprocessors() {
        return coprocessorNames;
    }

    public Set<String> getCoprocessors() {
        TreeSet<String> returnValue = new TreeSet<String>();
        for (CoprocessorEnvironment e : this.coprocessors) {
            returnValue.add(e.getInstance().getClass().getSimpleName());
        }
        return returnValue;
    }

    protected void loadSystemCoprocessors(Configuration conf, String confKey) {
        Class<?> implClass = null;
        String[] defaultCPClasses = conf.getStrings(confKey);
        if (defaultCPClasses == null || defaultCPClasses.length == 0) {
            return;
        }
        int priority = 0x1FFFFFFF;
        ArrayList<E> configured = new ArrayList<E>();
        for (String className : defaultCPClasses) {
            if (this.findCoprocessor(className = className.trim()) != null) continue;
            ClassLoader cl = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            try {
                implClass = cl.loadClass(className);
                configured.add(this.loadInstance(implClass, 0x1FFFFFFF, conf));
                LOG.info((Object)("System coprocessor " + className + " was loaded " + "successfully with priority (" + priority++ + ")."));
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Object)("Class " + className + " cannot be found. " + e.getMessage()));
            }
            catch (IOException e) {
                LOG.warn((Object)("Load coprocessor " + className + " failed. " + e.getMessage()));
            }
        }
        this.coprocessors.addAll(configured);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E load(Path path, String className, int priority, Configuration conf) throws IOException {
        Class<?> implClass = null;
        LOG.debug((Object)("Loading coprocessor class " + className + " with path " + path + " and priority " + priority));
        CoprocessorClassLoader cl = null;
        if (path == null) {
            try {
                implClass = this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("No jar path specified for " + className);
            }
        }
        cl = CoprocessorClassLoader.getClassLoader(path, this.getClass().getClassLoader(), this.pathPrefix, conf);
        try {
            implClass = ((ClassLoader)cl).loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot load external coprocessor class " + className, e);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader hostClassLoader = currentThread.getContextClassLoader();
        try {
            E cpInstance;
            currentThread.setContextClassLoader(cl);
            E e = cpInstance = this.loadInstance(implClass, priority, conf);
            return e;
        }
        finally {
            currentThread.setContextClassLoader(hostClassLoader);
        }
    }

    public void load(Class<?> implClass, int priority, Configuration conf) throws IOException {
        E env = this.loadInstance(implClass, priority, conf);
        this.coprocessors.add(env);
    }

    public E loadInstance(Class<?> implClass, int priority, Configuration conf) throws IOException {
        Coprocessor impl;
        Object o = null;
        try {
            o = implClass.newInstance();
            impl = o;
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        E env = this.createEnvironment(implClass, impl, priority, ++this.loadSequence, conf);
        if (env instanceof Environment) {
            ((Environment)env).startup();
        }
        coprocessorNames.add(implClass.getName());
        return env;
    }

    public abstract E createEnvironment(Class<?> var1, Coprocessor var2, int var3, int var4, Configuration var5);

    public void shutdown(CoprocessorEnvironment e) {
        if (e instanceof Environment) {
            ((Environment)e).shutdown();
        } else {
            LOG.warn((Object)("Shutdown called on unknown environment: " + e.getClass().getName()));
        }
    }

    public Coprocessor findCoprocessor(String className) {
        for (CoprocessorEnvironment env : this.coprocessors) {
            if (!env.getInstance().getClass().getName().equals(className) && !env.getInstance().getClass().getSimpleName().equals(className)) continue;
            return env.getInstance();
        }
        return null;
    }

    Set<ClassLoader> getExternalClassLoaders() {
        HashSet<ClassLoader> externalClassLoaders = new HashSet<ClassLoader>();
        ClassLoader systemClassLoader = this.getClass().getClassLoader();
        for (CoprocessorEnvironment env : this.coprocessors) {
            ClassLoader cl = env.getInstance().getClass().getClassLoader();
            if (cl == systemClassLoader) continue;
            externalClassLoaders.add(cl);
        }
        return externalClassLoaders;
    }

    public CoprocessorEnvironment findCoprocessorEnvironment(String className) {
        for (CoprocessorEnvironment env : this.coprocessors) {
            if (!env.getInstance().getClass().getName().equals(className) && !env.getInstance().getClass().getSimpleName().equals(className)) continue;
            return env;
        }
        return null;
    }

    protected void abortServer(String service, Server server, CoprocessorEnvironment environment, Throwable e) {
        String coprocessorName = environment.getInstance().toString();
        server.abort("Aborting service: " + service + " running on : " + server.getServerName() + " because coprocessor: " + coprocessorName + " threw an exception.", e);
    }

    protected void abortServer(CoprocessorEnvironment environment, Throwable e) {
        String coprocessorName = environment.getInstance().toString();
        LOG.error((Object)("The coprocessor: " + coprocessorName + " threw an unexpected " + "exception: " + e + ", but there's no specific implementation of " + " abortServer() for this coprocessor's environment."));
    }

    protected void handleCoprocessorThrowable(CoprocessorEnvironment env, Throwable e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (!env.getConfiguration().getBoolean("hbase.coprocessor.abortonerror", false)) {
            LOG.error((Object)("Removing coprocessor '" + env.toString() + "' from " + "environment because it threw:  " + e), e);
            this.coprocessors.remove(env);
            throw new DoNotRetryIOException("Coprocessor: '" + env.toString() + "' threw: '" + e + "' and has been removed" + "from the active " + "coprocessor set.", e);
        }
        this.abortServer(env, e);
    }

    public static class Environment
    implements CoprocessorEnvironment {
        public Coprocessor impl;
        protected int priority = 0x3FFFFFFF;
        Coprocessor.State state = Coprocessor.State.UNINSTALLED;
        protected List<HTableInterface> openTables = Collections.synchronizedList(new ArrayList());
        private int seq;
        private Configuration conf;

        public Environment(Coprocessor impl, int priority, int seq, Configuration conf) {
            this.impl = impl;
            this.priority = priority;
            this.state = Coprocessor.State.INSTALLED;
            this.seq = seq;
            this.conf = conf;
        }

        public void startup() {
            if (this.state == Coprocessor.State.INSTALLED || this.state == Coprocessor.State.STOPPED) {
                this.state = Coprocessor.State.STARTING;
                try {
                    this.impl.start(this);
                    this.state = Coprocessor.State.ACTIVE;
                }
                catch (IOException ioe) {
                    LOG.error((Object)("Error starting coprocessor " + this.impl.getClass().getName()), (Throwable)ioe);
                }
            } else {
                LOG.warn((Object)("Not starting coprocessor " + this.impl.getClass().getName() + " because not inactive (state=" + this.state.toString() + ")"));
            }
        }

        protected void shutdown() {
            if (this.state == Coprocessor.State.ACTIVE) {
                this.state = Coprocessor.State.STOPPING;
                try {
                    this.impl.stop(this);
                    this.state = Coprocessor.State.STOPPED;
                }
                catch (IOException ioe) {
                    LOG.error((Object)("Error stopping coprocessor " + this.impl.getClass().getName()), (Throwable)ioe);
                }
            } else {
                LOG.warn((Object)("Not stopping coprocessor " + this.impl.getClass().getName() + " because not active (state=" + this.state.toString() + ")"));
            }
            for (HTableInterface table : this.openTables) {
                try {
                    ((HTableWrapper)table).internalClose();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to close " + Bytes.toStringBinary(table.getTableName())), (Throwable)e);
                }
            }
        }

        @Override
        public Coprocessor getInstance() {
            return this.impl;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public int getLoadSequence() {
            return this.seq;
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public String getHBaseVersion() {
            return VersionInfo.getVersion();
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }

        @Override
        public HTableInterface getTable(byte[] tableName) throws IOException {
            return new HTableWrapper(tableName);
        }

        class HTableWrapper
        implements HTableInterface {
            private byte[] tableName;
            private HTable table;

            public HTableWrapper(byte[] tableName) throws IOException {
                this.tableName = tableName;
                this.table = new HTable(Environment.this.conf, tableName);
                Environment.this.openTables.add(this);
            }

            void internalClose() throws IOException {
                this.table.close();
            }

            @Override
            public Configuration getConfiguration() {
                return this.table.getConfiguration();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    this.internalClose();
                }
                finally {
                    Environment.this.openTables.remove(this);
                }
            }

            @Override
            public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
                return this.table.getRowOrBefore(row, family);
            }

            @Override
            public Result get(Get get2) throws IOException {
                return this.table.get(get2);
            }

            @Override
            public boolean exists(Get get2) throws IOException {
                return this.table.exists(get2);
            }

            @Override
            public void put(Put put2) throws IOException {
                this.table.put(put2);
            }

            @Override
            public void put(List<Put> puts) throws IOException {
                this.table.put(puts);
            }

            @Override
            public void delete(Delete delete) throws IOException {
                this.table.delete(delete);
            }

            @Override
            public void delete(List<Delete> deletes) throws IOException {
                this.table.delete(deletes);
            }

            @Override
            public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put2) throws IOException {
                return this.table.checkAndPut(row, family, qualifier, value, put2);
            }

            @Override
            public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
                return this.table.checkAndDelete(row, family, qualifier, value, delete);
            }

            @Override
            public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
                return this.table.incrementColumnValue(row, family, qualifier, amount);
            }

            @Override
            public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
                return this.table.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
            }

            @Override
            public Result append(Append append) throws IOException {
                return this.table.append(append);
            }

            @Override
            public Result increment(Increment increment2) throws IOException {
                return this.table.increment(increment2);
            }

            @Override
            public void flushCommits() throws IOException {
                this.table.flushCommits();
            }

            @Override
            public boolean isAutoFlush() {
                return this.table.isAutoFlush();
            }

            @Override
            public ResultScanner getScanner(Scan scan) throws IOException {
                return this.table.getScanner(scan);
            }

            @Override
            public ResultScanner getScanner(byte[] family) throws IOException {
                return this.table.getScanner(family);
            }

            @Override
            public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
                return this.table.getScanner(family, qualifier);
            }

            @Override
            public HTableDescriptor getTableDescriptor() throws IOException {
                return this.table.getTableDescriptor();
            }

            @Override
            public byte[] getTableName() {
                return this.tableName;
            }

            @Override
            public RowLock lockRow(byte[] row) throws IOException {
                throw new RuntimeException("row locking is not allowed within the coprocessor environment");
            }

            @Override
            public void unlockRow(RowLock rl) throws IOException {
                throw new RuntimeException("row locking is not allowed within the coprocessor environment");
            }

            @Override
            public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
                this.table.batch(actions, results);
            }

            @Override
            public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
                return this.table.batch(actions);
            }

            @Override
            public Result[] get(List<Get> gets) throws IOException {
                return this.table.get(gets);
            }

            @Override
            public <T extends CoprocessorProtocol, R> void coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws IOException, Throwable {
                this.table.coprocessorExec(protocol, startKey, endKey, callable, callback);
            }

            @Override
            public <T extends CoprocessorProtocol, R> Map<byte[], R> coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws IOException, Throwable {
                return this.table.coprocessorExec(protocol, startKey, endKey, callable);
            }

            @Override
            public <T extends CoprocessorProtocol> T coprocessorProxy(Class<T> protocol, byte[] row) {
                return this.table.coprocessorProxy(protocol, row);
            }

            @Override
            public void mutateRow(RowMutations rm) throws IOException {
                this.table.mutateRow(rm);
            }

            @Override
            public void setAutoFlush(boolean autoFlush) {
                this.table.setAutoFlush(autoFlush);
            }

            @Override
            public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
                this.table.setAutoFlush(autoFlush, clearBufferOnFail);
            }

            @Override
            public long getWriteBufferSize() {
                return this.table.getWriteBufferSize();
            }

            @Override
            public void setWriteBufferSize(long writeBufferSize) throws IOException {
                this.table.setWriteBufferSize(writeBufferSize);
            }
        }
    }

    static class EnvironmentPriorityComparator
    implements Comparator<CoprocessorEnvironment> {
        EnvironmentPriorityComparator() {
        }

        @Override
        public int compare(CoprocessorEnvironment env1, CoprocessorEnvironment env2) {
            if (env1.getPriority() < env2.getPriority()) {
                return -1;
            }
            if (env1.getPriority() > env2.getPriority()) {
                return 1;
            }
            if (env1.getLoadSequence() < env2.getLoadSequence()) {
                return -1;
            }
            if (env1.getLoadSequence() > env2.getLoadSequence()) {
                return 1;
            }
            return 0;
        }
    }
}

