/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.CodeToClassAndBack;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;

public class HbaseMapWritable<K, V>
implements SortedMap<byte[], V>,
Configurable,
Writable,
CodeToClassAndBack {
    private AtomicReference<Configuration> conf = new AtomicReference();
    protected SortedMap<byte[], V> instance = null;

    public HbaseMapWritable() {
        this(new TreeMap(Bytes.BYTES_COMPARATOR));
    }

    public HbaseMapWritable(SortedMap<byte[], V> map) {
        this.instance = map;
    }

    public Configuration getConf() {
        return this.conf.get();
    }

    public void setConf(Configuration conf) {
        this.conf.set(conf);
    }

    @Override
    public void clear() {
        this.instance.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.instance.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.instance.containsValue(value);
    }

    @Override
    public Set<Map.Entry<byte[], V>> entrySet() {
        return this.instance.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.instance.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.instance.isEmpty();
    }

    @Override
    public Set<byte[]> keySet() {
        return this.instance.keySet();
    }

    @Override
    public int size() {
        return this.instance.size();
    }

    @Override
    public Collection<V> values() {
        return this.instance.values();
    }

    @Override
    public void putAll(Map<? extends byte[], ? extends V> m) {
        this.instance.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.instance.remove(key);
    }

    @Override
    public V put(byte[] key, V value) {
        return this.instance.put(key, value);
    }

    @Override
    public Comparator<? super byte[]> comparator() {
        return this.instance.comparator();
    }

    @Override
    public byte[] firstKey() {
        return this.instance.firstKey();
    }

    @Override
    public SortedMap<byte[], V> headMap(byte[] toKey) {
        return this.instance.headMap(toKey);
    }

    @Override
    public byte[] lastKey() {
        return this.instance.lastKey();
    }

    @Override
    public SortedMap<byte[], V> subMap(byte[] fromKey, byte[] toKey) {
        return this.instance.subMap(fromKey, toKey);
    }

    @Override
    public SortedMap<byte[], V> tailMap(byte[] fromKey) {
        return this.instance.tailMap(fromKey);
    }

    protected Class<?> getClass(byte id) {
        return (Class)CODE_TO_CLASS.get(id);
    }

    protected byte getId(Class<?> clazz) {
        Byte b = (Byte)CLASS_TO_CODE.get(clazz);
        if (b == null) {
            throw new NullPointerException("Nothing for : " + clazz);
        }
        return b;
    }

    public String toString() {
        return this.instance.toString();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.instance.size());
        for (Map.Entry<byte[], V> e : this.instance.entrySet()) {
            Bytes.writeByteArray(out, e.getKey());
            Byte id = this.getId(e.getValue().getClass());
            out.writeByte(id.byteValue());
            V value = e.getValue();
            if (value instanceof byte[]) {
                Bytes.writeByteArray(out, (byte[])value);
                continue;
            }
            ((Writable)value).write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.instance.clear();
        int entries = in.readInt();
        for (int i = 0; i < entries; ++i) {
            byte[] key = Bytes.readByteArray(in);
            byte id = in.readByte();
            Class<?> clazz = this.getClass(id);
            Object value = null;
            if (clazz.equals(byte[].class)) {
                byte[] bytes;
                value = bytes = Bytes.readByteArray(in);
            } else {
                Writable w = (Writable)ReflectionUtils.newInstance(clazz, (Configuration)this.getConf());
                w.readFields(in);
                value = w;
            }
            this.instance.put(key, (byte[])value);
        }
    }
}

