/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.DoubleBlockCache;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.util.DirectMemoryUtils;
import org.apache.hadoop.util.StringUtils;

public class CacheConfig {
    private static final Log LOG = LogFactory.getLog((String)CacheConfig.class.getName());
    public static final String CACHE_BLOCKS_ON_WRITE_KEY = "hbase.rs.cacheblocksonwrite";
    public static final String CACHE_INDEX_BLOCKS_ON_WRITE_KEY = "hfile.block.index.cacheonwrite";
    public static final String CACHE_BLOOM_BLOCKS_ON_WRITE_KEY = "hfile.block.bloom.cacheonwrite";
    public static final String CACHE_DATA_BLOCKS_COMPRESSED_KEY = "hbase.rs.blockcache.cachedatacompressed";
    public static final String EVICT_BLOCKS_ON_CLOSE_KEY = "hbase.rs.evictblocksonclose";
    public static final boolean DEFAULT_CACHE_DATA_ON_READ = true;
    public static final boolean DEFAULT_CACHE_DATA_ON_WRITE = false;
    public static final boolean DEFAULT_IN_MEMORY = false;
    public static final boolean DEFAULT_CACHE_INDEXES_ON_WRITE = false;
    public static final boolean DEFAULT_CACHE_BLOOMS_ON_WRITE = false;
    public static final boolean DEFAULT_EVICT_ON_CLOSE = false;
    public static final boolean DEFAULT_COMPRESSED_CACHE = false;
    private final BlockCache blockCache;
    private boolean cacheDataOnRead;
    private final boolean inMemory;
    private boolean cacheDataOnWrite;
    private final boolean cacheIndexesOnWrite;
    private final boolean cacheBloomsOnWrite;
    private boolean evictOnClose;
    private final boolean cacheCompressed;
    private static BlockCache globalBlockCache;
    private static boolean blockCacheDisabled;

    public CacheConfig(Configuration conf, HColumnDescriptor family) {
        this(CacheConfig.instantiateBlockCache(conf), family.isBlockCacheEnabled(), family.isInMemory(), conf.getBoolean(CACHE_BLOCKS_ON_WRITE_KEY, false) || family.shouldCacheDataOnWrite(), conf.getBoolean(CACHE_INDEX_BLOCKS_ON_WRITE_KEY, false) || family.shouldCacheIndexesOnWrite(), conf.getBoolean(CACHE_BLOOM_BLOCKS_ON_WRITE_KEY, false) || family.shouldCacheBloomsOnWrite(), conf.getBoolean(EVICT_BLOCKS_ON_CLOSE_KEY, false) || family.shouldEvictBlocksOnClose(), conf.getBoolean(CACHE_DATA_BLOCKS_COMPRESSED_KEY, false));
    }

    public CacheConfig(Configuration conf) {
        this(CacheConfig.instantiateBlockCache(conf), true, false, conf.getBoolean(CACHE_BLOCKS_ON_WRITE_KEY, false), conf.getBoolean(CACHE_INDEX_BLOCKS_ON_WRITE_KEY, false), conf.getBoolean(CACHE_BLOOM_BLOCKS_ON_WRITE_KEY, false), conf.getBoolean(EVICT_BLOCKS_ON_CLOSE_KEY, false), conf.getBoolean(CACHE_DATA_BLOCKS_COMPRESSED_KEY, false));
    }

    CacheConfig(BlockCache blockCache, boolean cacheDataOnRead, boolean inMemory, boolean cacheDataOnWrite, boolean cacheIndexesOnWrite, boolean cacheBloomsOnWrite, boolean evictOnClose, boolean cacheCompressed) {
        this.blockCache = blockCache;
        this.cacheDataOnRead = cacheDataOnRead;
        this.inMemory = inMemory;
        this.cacheDataOnWrite = cacheDataOnWrite;
        this.cacheIndexesOnWrite = cacheIndexesOnWrite;
        this.cacheBloomsOnWrite = cacheBloomsOnWrite;
        this.evictOnClose = evictOnClose;
        this.cacheCompressed = cacheCompressed;
    }

    public CacheConfig(CacheConfig cacheConf) {
        this(cacheConf.blockCache, cacheConf.cacheDataOnRead, cacheConf.inMemory, cacheConf.cacheDataOnWrite, cacheConf.cacheIndexesOnWrite, cacheConf.cacheBloomsOnWrite, cacheConf.evictOnClose, cacheConf.cacheCompressed);
    }

    public boolean isBlockCacheEnabled() {
        return this.blockCache != null;
    }

    public BlockCache getBlockCache() {
        return this.blockCache;
    }

    public boolean shouldCacheDataOnRead() {
        return this.isBlockCacheEnabled() && this.cacheDataOnRead;
    }

    public boolean shouldCacheBlockOnRead(BlockType.BlockCategory category) {
        boolean shouldCache = this.isBlockCacheEnabled() && (this.cacheDataOnRead || category == BlockType.BlockCategory.INDEX || category == BlockType.BlockCategory.BLOOM);
        return shouldCache;
    }

    public boolean isInMemory() {
        return this.isBlockCacheEnabled() && this.inMemory;
    }

    public boolean shouldCacheDataOnWrite() {
        return this.isBlockCacheEnabled() && this.cacheDataOnWrite;
    }

    public void setCacheDataOnWrite(boolean cacheDataOnWrite) {
        this.cacheDataOnWrite = cacheDataOnWrite;
    }

    public boolean shouldCacheIndexesOnWrite() {
        return this.isBlockCacheEnabled() && this.cacheIndexesOnWrite;
    }

    public boolean shouldCacheBloomsOnWrite() {
        return this.isBlockCacheEnabled() && this.cacheBloomsOnWrite;
    }

    public boolean shouldEvictOnClose() {
        return this.isBlockCacheEnabled() && this.evictOnClose;
    }

    public void setEvictOnClose(boolean evictOnClose) {
        this.evictOnClose = evictOnClose;
    }

    public boolean shouldCacheCompressed() {
        return this.isBlockCacheEnabled() && this.cacheCompressed;
    }

    public String toString() {
        if (!this.isBlockCacheEnabled()) {
            return "CacheConfig:disabled";
        }
        return "CacheConfig:enabled [cacheDataOnRead=" + this.shouldCacheDataOnRead() + "] " + "[cacheDataOnWrite=" + this.shouldCacheDataOnWrite() + "] " + "[cacheIndexesOnWrite=" + this.shouldCacheIndexesOnWrite() + "] " + "[cacheBloomsOnWrite=" + this.shouldCacheBloomsOnWrite() + "] " + "[cacheEvictOnClose=" + this.shouldEvictOnClose() + "] " + "[cacheCompressed=" + this.shouldCacheCompressed() + "]";
    }

    private static synchronized BlockCache instantiateBlockCache(Configuration conf) {
        if (globalBlockCache != null) {
            return globalBlockCache;
        }
        if (blockCacheDisabled) {
            return null;
        }
        float cachePercentage = conf.getFloat("hfile.block.cache.size", 0.25f);
        if (cachePercentage == 0.0f) {
            blockCacheDisabled = true;
            return null;
        }
        if ((double)cachePercentage > 1.0) {
            throw new IllegalArgumentException("hfile.block.cache.size must be between 0.0 and 1.0, and not > 1.0");
        }
        MemoryUsage mu = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        long cacheSize = (long)((float)mu.getMax() * cachePercentage);
        int blockSize = conf.getInt("hbase.offheapcache.minblocksize", 65536);
        long offHeapCacheSize = (long)(conf.getFloat("hbase.offheapcache.percentage", 0.0f) * (float)DirectMemoryUtils.getDirectMemorySize());
        LOG.info((Object)("Allocating LruBlockCache with maximum size " + StringUtils.humanReadableInt((long)cacheSize)));
        globalBlockCache = offHeapCacheSize <= 0L ? new LruBlockCache(cacheSize, 8192L, conf) : new DoubleBlockCache(cacheSize, offHeapCacheSize, 8192L, blockSize, conf);
        return globalBlockCache;
    }

    static {
        blockCacheDisabled = false;
    }
}

