/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.InputSplit;

@Deprecated
public class TableSplit
implements InputSplit,
Comparable<TableSplit> {
    private byte[] m_tableName;
    private byte[] m_startRow;
    private byte[] m_endRow;
    private String m_regionLocation;

    public TableSplit() {
        this(HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, "");
    }

    public TableSplit(byte[] tableName, byte[] startRow, byte[] endRow, String location) {
        this.m_tableName = tableName;
        this.m_startRow = startRow;
        this.m_endRow = endRow;
        this.m_regionLocation = location;
    }

    public byte[] getTableName() {
        return this.m_tableName;
    }

    public byte[] getStartRow() {
        return this.m_startRow;
    }

    public byte[] getEndRow() {
        return this.m_endRow;
    }

    public String getRegionLocation() {
        return this.m_regionLocation;
    }

    public String[] getLocations() {
        return new String[]{this.m_regionLocation};
    }

    public long getLength() {
        return 0L;
    }

    public void readFields(DataInput in) throws IOException {
        this.m_tableName = Bytes.readByteArray(in);
        this.m_startRow = Bytes.readByteArray(in);
        this.m_endRow = Bytes.readByteArray(in);
        this.m_regionLocation = Bytes.toString(Bytes.readByteArray(in));
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.m_tableName);
        Bytes.writeByteArray(out, this.m_startRow);
        Bytes.writeByteArray(out, this.m_endRow);
        Bytes.writeByteArray(out, Bytes.toBytes(this.m_regionLocation));
    }

    public String toString() {
        return this.m_regionLocation + ":" + Bytes.toStringBinary(this.m_startRow) + "," + Bytes.toStringBinary(this.m_endRow);
    }

    @Override
    public int compareTo(TableSplit o) {
        return Bytes.compareTo(this.getStartRow(), o.getStartRow());
    }
}

