/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.StringUtils;

public class PutSortReducer
extends Reducer<ImmutableBytesWritable, Put, ImmutableBytesWritable, KeyValue> {
    protected void reduce(ImmutableBytesWritable row, Iterable<Put> puts, Reducer.Context context) throws IOException, InterruptedException {
        long threshold = context.getConfiguration().getLong("putsortreducer.row.threshold", 0x80000000L);
        Iterator<Put> iter = puts.iterator();
        while (iter.hasNext()) {
            TreeSet<KeyValue> map = new TreeSet<KeyValue>(KeyValue.COMPARATOR);
            long curSize = 0L;
            while (iter.hasNext() && curSize < threshold) {
                Put p = iter.next();
                for (List<KeyValue> kvs : p.getFamilyMap().values()) {
                    for (KeyValue kv : kvs) {
                        map.add(kv);
                        curSize += (long)kv.getLength();
                    }
                }
            }
            context.setStatus("Read " + map.size() + " entries of " + map.getClass() + "(" + StringUtils.humanReadableInt((long)curSize) + ")");
            int index = 0;
            for (KeyValue kv : map) {
                context.write((Object)row, (Object)kv);
                if (index <= 0 || index % 100 != 0) continue;
                context.setStatus("Wrote " + index);
            }
            if (!iter.hasNext()) continue;
            context.write(null, null);
        }
    }
}

