/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseFileSystem;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class CreateTableHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(CreateTableHandler.class);
    protected MasterFileSystem fileSystemManager;
    protected final HTableDescriptor hTableDescriptor;
    protected Configuration conf;
    protected final AssignmentManager assignmentManager;
    protected final CatalogTracker catalogTracker;
    protected final ServerManager serverManager;
    private final HRegionInfo[] newRegions;

    public CreateTableHandler(Server server, MasterFileSystem fileSystemManager, ServerManager serverManager, HTableDescriptor hTableDescriptor, Configuration conf, HRegionInfo[] newRegions, CatalogTracker catalogTracker, AssignmentManager assignmentManager) throws NotAllMetaRegionsOnlineException, TableExistsException, IOException {
        super(server, EventHandler.EventType.C_M_CREATE_TABLE);
        this.fileSystemManager = fileSystemManager;
        this.serverManager = serverManager;
        this.hTableDescriptor = hTableDescriptor;
        this.conf = conf;
        this.newRegions = newRegions;
        this.catalogTracker = catalogTracker;
        this.assignmentManager = assignmentManager;
        int timeout = conf.getInt("hbase.client.catalog.timeout", 10000);
        try {
            if (catalogTracker.waitForMeta(timeout) == null) {
                throw new NotAllMetaRegionsOnlineException();
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted waiting for meta availability", (Throwable)e);
            throw new IOException(e);
        }
        String tableName = this.hTableDescriptor.getNameAsString();
        if (MetaReader.tableExists(catalogTracker, tableName)) {
            throw new TableExistsException(tableName);
        }
        try {
            if (!this.assignmentManager.getZKTable().checkAndSetEnablingTable(tableName)) {
                throw new TableExistsException(tableName);
            }
        }
        catch (KeeperException e) {
            throw new IOException("Unable to ensure that the table will be enabling because of a ZooKeeper issue", e);
        }
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.hTableDescriptor.getNameAsString();
    }

    @Override
    public void process() {
        String tableName = this.hTableDescriptor.getNameAsString();
        try {
            LOG.info((Object)("Attempting to create the table " + tableName));
            this.handleCreateTable(tableName);
            this.completed(null);
        }
        catch (Throwable e) {
            LOG.error((Object)("Error trying to create the table " + tableName), e);
            this.completed(e);
        }
    }

    protected void completed(Throwable exception) {
        if (exception != null) {
            try {
                this.assignmentManager.getZKTable().removeEnablingTable(this.hTableDescriptor.getNameAsString(), false);
            }
            catch (KeeperException e) {
                LOG.error((Object)("Got a keeper exception while removing the ENABLING table znode " + this.hTableDescriptor.getNameAsString()), (Throwable)e);
            }
        }
    }

    private void handleCreateTable(String tableName) throws IOException, KeeperException {
        Path tempdir = this.fileSystemManager.getTempDir();
        FileSystem fs = this.fileSystemManager.getFileSystem();
        FSTableDescriptors.createTableDescriptor(fs, tempdir, this.hTableDescriptor);
        Path tempTableDir = new Path(tempdir, tableName);
        Path tableDir = new Path(this.fileSystemManager.getRootDir(), tableName);
        List<HRegionInfo> regionInfos = this.handleCreateHdfsRegions(tempdir, tableName);
        if (!HBaseFileSystem.renameDirForFileSystem(fs, tempTableDir, tableDir)) {
            throw new IOException("Unable to move table from temp=" + tempTableDir + " to hbase root=" + tableDir);
        }
        if (regionInfos != null && regionInfos.size() > 0) {
            MetaEditor.addRegionsToMeta(this.catalogTracker, regionInfos);
            List<ServerName> servers = this.serverManager.getOnlineServersList();
            this.assignmentManager.removeDeadNotExpiredServers(servers);
            try {
                this.assignmentManager.assignUserRegions(regionInfos, servers);
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Caught " + e + " during round-robin assignment"));
                InterruptedIOException ie = new InterruptedIOException(e.getMessage());
                ie.initCause(e);
                throw ie;
            }
        }
        try {
            this.assignmentManager.getZKTable().setEnabledTable(tableName);
        }
        catch (KeeperException e) {
            throw new IOException("Unable to ensure that " + tableName + " will be" + " enabled because of a ZooKeeper issue", e);
        }
    }

    protected List<HRegionInfo> handleCreateHdfsRegions(Path tableRootDir, String tableName) throws IOException {
        return ModifyRegionUtils.createRegions(this.conf, tableRootDir, this.hTableDescriptor, this.newRegions, null);
    }
}

