/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionListener;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.errorhandling.TimeoutExceptionInjector;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Procedure
implements Callable<Void>,
ForeignExceptionListener {
    private static final Log LOG = LogFactory.getLog(Procedure.class);
    private final String procName;
    private final byte[] args;
    final CountDownLatch acquiredBarrierLatch;
    final CountDownLatch releasedBarrierLatch;
    final CountDownLatch completedLatch;
    private final ForeignExceptionDispatcher monitor;
    protected final long wakeFrequency;
    protected final TimeoutExceptionInjector timeoutInjector;
    private Object joinBarrierLock = new Object();
    private final List<String> acquiringMembers;
    private final List<String> inBarrierMembers;
    private ProcedureCoordinator coord;

    public Procedure(ProcedureCoordinator coord, ForeignExceptionDispatcher monitor, long wakeFreq, long timeout, String procName, byte[] args, List<String> expectedMembers) {
        this.coord = coord;
        this.acquiringMembers = new ArrayList<String>(expectedMembers);
        this.inBarrierMembers = new ArrayList<String>(this.acquiringMembers.size());
        this.procName = procName;
        this.args = args;
        this.monitor = monitor;
        this.wakeFrequency = wakeFreq;
        int count = expectedMembers.size();
        this.acquiredBarrierLatch = new CountDownLatch(count);
        this.releasedBarrierLatch = new CountDownLatch(count);
        this.completedLatch = new CountDownLatch(1);
        this.timeoutInjector = new TimeoutExceptionInjector(monitor, timeout);
    }

    public Procedure(ProcedureCoordinator coord, long wakeFreq, long timeout, String procName, byte[] args, List<String> expectedMembers) {
        this(coord, new ForeignExceptionDispatcher(), wakeFreq, timeout, procName, args, expectedMembers);
    }

    public String getName() {
        return this.procName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatus() {
        String done;
        String waiting;
        Object object = this.joinBarrierLock;
        synchronized (object) {
            waiting = this.acquiringMembers.toString();
            done = this.inBarrierMembers.toString();
        }
        return "Procedure " + this.procName + " { waiting=" + waiting + " done=" + done + " }";
    }

    public ForeignExceptionDispatcher getErrorMonitor() {
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Void call() {
        LOG.info((Object)("Starting procedure '" + this.procName + "'"));
        this.timeoutInjector.start();
        try {
            this.monitor.rethrowException();
            LOG.debug((Object)("Procedure '" + this.procName + "' starting 'acquire'"));
            this.sendGlobalBarrierStart();
            LOG.debug((Object)"Waiting for all members to 'acquire'");
            Procedure.waitForLatch(this.acquiredBarrierLatch, this.monitor, this.wakeFrequency, "acquired");
            this.monitor.rethrowException();
            LOG.debug((Object)("Procedure '" + this.procName + "' starting 'in-barrier' execution."));
            this.sendGlobalBarrierReached();
            Procedure.waitForLatch(this.releasedBarrierLatch, this.monitor, this.wakeFrequency, "released");
            this.monitor.rethrowException();
            LOG.info((Object)("Procedure '" + this.procName + "' execution completed"));
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            String msg = "Procedure '" + this.procName + "' execution failed!";
            LOG.error((Object)msg, (Throwable)e);
            this.receive(new ForeignException(this.getName(), e));
        }
        finally {
            LOG.debug((Object)"Running finish phase.");
            this.sendGlobalBarrierComplete();
            this.completedLatch.countDown();
            this.timeoutInjector.complete();
            return null;
        }
    }

    public void sendGlobalBarrierStart() throws ForeignException {
        LOG.debug((Object)("Starting procedure '" + this.procName + "', kicking off acquire phase on members."));
        try {
            this.coord.getRpcs().sendGlobalBarrierAcquire(this, this.args, Lists.newArrayList(this.acquiringMembers));
        }
        catch (IOException e) {
            this.coord.rpcConnectionFailure("Can't reach controller.", e);
        }
        catch (IllegalArgumentException e) {
            throw new ForeignException(this.getName(), e);
        }
    }

    public void sendGlobalBarrierReached() throws ForeignException {
        try {
            this.coord.getRpcs().sendGlobalBarrierReached(this, Lists.newArrayList(this.inBarrierMembers));
        }
        catch (IOException e) {
            this.coord.rpcConnectionFailure("Can't reach controller.", e);
        }
    }

    public void sendGlobalBarrierComplete() {
        LOG.debug((Object)"Finished coordinator procedure - removing self from list of running procedures");
        try {
            this.coord.getRpcs().resetMembers(this);
        }
        catch (IOException e) {
            this.coord.rpcConnectionFailure("Failed to reset procedure:" + this.procName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void barrierAcquiredByMember(String member) {
        LOG.debug((Object)("member: '" + member + "' joining prepared barrier for procedure '" + this.procName + "' on coordinator"));
        if (this.acquiringMembers.contains(member)) {
            Object object = this.joinBarrierLock;
            synchronized (object) {
                if (this.acquiringMembers.remove(member)) {
                    this.inBarrierMembers.add(member);
                    this.acquiredBarrierLatch.countDown();
                }
            }
            LOG.debug((Object)("Waiting on: " + this.acquiredBarrierLatch + " remaining members to acquire global barrier"));
        } else {
            LOG.warn((Object)("Member " + member + " joined barrier, but we weren't waiting on it to join." + " Continuing on."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void barrierReleasedByMember(String member) {
        boolean removed = false;
        Object object = this.joinBarrierLock;
        synchronized (object) {
            removed = this.inBarrierMembers.remove(member);
            if (removed) {
                this.releasedBarrierLatch.countDown();
            }
        }
        if (removed) {
            LOG.debug((Object)("Member: '" + member + "' released barrier for procedure'" + this.procName + "', counting down latch.  Waiting for " + this.releasedBarrierLatch.getCount() + " more"));
        } else {
            LOG.warn((Object)("Member: '" + member + "' released barrier for procedure'" + this.procName + "', but we weren't waiting on it to release!"));
        }
    }

    public void waitForCompleted() throws ForeignException, InterruptedException {
        Procedure.waitForLatch(this.completedLatch, this.monitor, this.wakeFrequency, this.procName + " completed");
    }

    @Override
    public void receive(ForeignException e) {
        this.monitor.receive(e);
    }

    public static void waitForLatch(CountDownLatch latch, ForeignExceptionSnare monitor, long wakeFrequency, String latchDescription) throws ForeignException, InterruptedException {
        boolean released = false;
        while (!released) {
            if (monitor != null) {
                monitor.rethrowException();
            }
            released = latch.await(wakeFrequency, TimeUnit.MILLISECONDS);
        }
    }
}

