/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.ColumnCount;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.ExplicitColumnTracker;
import org.apache.hadoop.hbase.regionserver.ScanDeleteTracker;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScanWildcardColumnTracker;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

public class ScanQueryMatcher {
    private boolean stickyNextRow;
    private final byte[] stopRow;
    private final TimeRange tr;
    private final Filter filter;
    private final DeleteTracker deletes;
    private final boolean retainDeletesInOutput;
    private final boolean keepDeletedCells;
    private final boolean seePastDeleteMarkers;
    private final ColumnTracker columns;
    private final KeyValue startKey;
    private final KeyValue.KeyComparator rowComparator;
    byte[] row;
    int rowOffset;
    short rowLength;
    private final long earliestPutTs;
    protected long maxReadPointToTrackVersions;
    private boolean hasNullColumn = true;
    private final long timeToPurgeDeletes;
    private final boolean isUserScan;

    public ScanQueryMatcher(Scan scan, Store.ScanInfo scanInfo, NavigableSet<byte[]> columns, ScanType scanType, long readPointToUse, long earliestPutTs, long oldestUnexpiredTS) {
        this.tr = scan.getTimeRange();
        this.rowComparator = scanInfo.getComparator().getRawComparator();
        this.deletes = new ScanDeleteTracker();
        this.stopRow = scan.getStopRow();
        this.startKey = KeyValue.createFirstDeleteFamilyOnRow(scan.getStartRow(), scanInfo.getFamily());
        this.filter = scan.getFilter();
        this.earliestPutTs = earliestPutTs;
        this.maxReadPointToTrackVersions = readPointToUse;
        this.timeToPurgeDeletes = scanInfo.getTimeToPurgeDeletes();
        this.isUserScan = scanType == ScanType.USER_SCAN;
        this.keepDeletedCells = scanInfo.getKeepDeletedCells() && !this.isUserScan || scan.isRaw();
        this.retainDeletesInOutput = scanType == ScanType.MINOR_COMPACT || scan.isRaw();
        this.seePastDeleteMarkers = scanInfo.getKeepDeletedCells() && this.isUserScan;
        int maxVersions = Math.min(scan.getMaxVersions(), scanInfo.getMaxVersions());
        if (columns == null || columns.size() == 0) {
            this.hasNullColumn = true;
            this.columns = new ScanWildcardColumnTracker(scanInfo.getMinVersions(), maxVersions, oldestUnexpiredTS);
        } else {
            this.hasNullColumn = ((byte[])columns.first()).length == 0;
            this.columns = new ExplicitColumnTracker(columns, scanInfo.getMinVersions(), maxVersions, oldestUnexpiredTS);
        }
    }

    ScanQueryMatcher(Scan scan, Store.ScanInfo scanInfo, NavigableSet<byte[]> columns, long oldestUnexpiredTS) {
        this(scan, scanInfo, columns, ScanType.USER_SCAN, Long.MAX_VALUE, Long.MAX_VALUE, oldestUnexpiredTS);
    }

    public boolean hasNullColumnInQuery() {
        return this.hasNullColumn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MatchCode match(KeyValue kv) throws IOException {
        MatchCode colChecker;
        int timestampComparison;
        short rowLength;
        int ret;
        int offset;
        if (this.filter != null && this.filter.filterAllRemaining()) {
            return MatchCode.DONE_SCAN;
        }
        byte[] bytes = kv.getBuffer();
        int initialOffset = offset = kv.getOffset();
        int keyLength = Bytes.toInt(bytes, offset, 4);
        offset += 8;
        if ((ret = this.rowComparator.compareRows(this.row, this.rowOffset, this.rowLength, bytes, offset += 2, rowLength = Bytes.toShort(bytes, offset, 2))) <= -1) {
            return MatchCode.DONE;
        }
        if (ret >= 1) {
            return MatchCode.SEEK_NEXT_ROW;
        }
        if (this.stickyNextRow) {
            return MatchCode.SEEK_NEXT_ROW;
        }
        if (this.columns.done()) {
            this.stickyNextRow = true;
            return MatchCode.SEEK_NEXT_ROW;
        }
        byte familyLength = bytes[offset += rowLength];
        int qualLength = keyLength + 8 - ((offset += familyLength + 1) - initialOffset) - 9;
        long timestamp = kv.getTimestamp();
        if (this.columns.isDone(timestamp)) {
            return this.columns.getNextRowOrNextColumn(bytes, offset, qualLength);
        }
        byte type = kv.getType();
        if (kv.isDelete()) {
            if (!this.keepDeletedCells) {
                boolean includeDeleteMarker;
                boolean bl = includeDeleteMarker = this.seePastDeleteMarkers ? this.tr.withinTimeRange(timestamp) : this.tr.withinOrAfterTimeRange(timestamp);
                if (includeDeleteMarker && kv.getMemstoreTS() <= this.maxReadPointToTrackVersions) {
                    this.deletes.add(bytes, offset, qualLength, timestamp, type);
                }
            }
            if (this.retainDeletesInOutput || !this.isUserScan && EnvironmentEdgeManager.currentTimeMillis() - timestamp <= this.timeToPurgeDeletes || kv.getMemstoreTS() > this.maxReadPointToTrackVersions) {
                return MatchCode.INCLUDE;
            }
            if (!this.keepDeletedCells) return MatchCode.SKIP;
            if (timestamp < this.earliestPutTs) {
                return this.columns.getNextRowOrNextColumn(bytes, offset, qualLength);
            }
        } else if (!this.deletes.isEmpty()) {
            DeleteTracker.DeleteResult deleteResult = this.deletes.isDeleted(bytes, offset, qualLength, timestamp);
            switch (deleteResult) {
                case FAMILY_DELETED: 
                case COLUMN_DELETED: {
                    return this.columns.getNextRowOrNextColumn(bytes, offset, qualLength);
                }
                case VERSION_DELETED: {
                    return MatchCode.SKIP;
                }
                case NOT_DELETED: {
                    break;
                }
                default: {
                    throw new RuntimeException("UNEXPECTED");
                }
            }
        }
        if ((timestampComparison = this.tr.compare(timestamp)) >= 1) {
            return MatchCode.SKIP;
        }
        if (timestampComparison <= -1) {
            return this.columns.getNextRowOrNextColumn(bytes, offset, qualLength);
        }
        Filter.ReturnCode filterResponse = Filter.ReturnCode.SKIP;
        if (this.filter != null) {
            filterResponse = this.filter.filterKeyValue(kv);
            if (filterResponse == Filter.ReturnCode.SKIP) {
                return MatchCode.SKIP;
            }
            if (filterResponse == Filter.ReturnCode.NEXT_COL) {
                return this.columns.getNextRowOrNextColumn(bytes, offset, qualLength);
            }
            if (filterResponse == Filter.ReturnCode.NEXT_ROW) {
                this.stickyNextRow = true;
                return MatchCode.SEEK_NEXT_ROW;
            }
            if (filterResponse == Filter.ReturnCode.SEEK_NEXT_USING_HINT) {
                return MatchCode.SEEK_NEXT_USING_HINT;
            }
        }
        if ((colChecker = this.columns.checkColumn(bytes, offset, qualLength, timestamp, type, kv.getMemstoreTS() > this.maxReadPointToTrackVersions)) == MatchCode.SEEK_NEXT_ROW) {
            this.stickyNextRow = true;
            return colChecker;
        } else {
            if (this.filter == null || colChecker != MatchCode.INCLUDE || filterResponse != Filter.ReturnCode.INCLUDE_AND_NEXT_COL) return colChecker;
            return MatchCode.INCLUDE_AND_SEEK_NEXT_COL;
        }
    }

    public boolean moreRowsMayExistAfter(KeyValue kv) {
        return Bytes.equals(this.stopRow, HConstants.EMPTY_END_ROW) || this.rowComparator.compareRows(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), this.stopRow, 0, this.stopRow.length) < 0;
    }

    public void setRow(byte[] row, int offset, short length) {
        this.row = row;
        this.rowOffset = offset;
        this.rowLength = length;
        this.reset();
    }

    public void reset() {
        this.deletes.reset();
        this.columns.reset();
        this.stickyNextRow = false;
    }

    public KeyValue getStartKey() {
        return this.startKey;
    }

    Filter getFilter() {
        return this.filter;
    }

    public KeyValue getNextKeyHint(KeyValue kv) {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getNextKeyHint(kv);
    }

    public KeyValue getKeyForNextColumn(KeyValue kv) {
        ColumnCount nextColumn = this.columns.getColumnHint();
        if (nextColumn == null) {
            return KeyValue.createLastOnRow(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength(), kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength());
        }
        return KeyValue.createFirstOnRow(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength(), nextColumn.getBuffer(), nextColumn.getOffset(), nextColumn.getLength());
    }

    public KeyValue getKeyForNextRow(KeyValue kv) {
        return KeyValue.createLastOnRow(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), null, 0, 0, null, 0, 0);
    }

    public static enum MatchCode {
        INCLUDE,
        SKIP,
        NEXT,
        DONE,
        SEEK_NEXT_ROW,
        SEEK_NEXT_COL,
        DONE_SCAN,
        SEEK_NEXT_USING_HINT,
        INCLUDE_AND_SEEK_NEXT_COL,
        INCLUDE_AND_SEEK_NEXT_ROW;

    }
}

