/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.Decoder;
import org.apache.hadoop.hbase.codec.Encoder;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALEditCodec;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.Writable;

public class WALEdit
implements Writable,
HeapSize {
    private final int VERSION_2 = -1;
    private final ArrayList<KeyValue> kvs = new ArrayList();
    private NavigableMap<byte[], Integer> scopes;
    private WALEditCodec codec = new WALEditCodec();

    public void setCompressionContext(CompressionContext compression) {
        this.codec.setCompression(compression);
    }

    public void setCodec(WALEditCodec codec) {
        this.codec = codec;
    }

    public void add(KeyValue kv) {
        this.kvs.add(kv);
    }

    public boolean isEmpty() {
        return this.kvs.isEmpty();
    }

    public int size() {
        return this.kvs.size();
    }

    public List<KeyValue> getKeyValues() {
        return this.kvs;
    }

    public NavigableMap<byte[], Integer> getScopes() {
        return this.scopes;
    }

    public void setScopes(NavigableMap<byte[], Integer> scopes) {
        this.scopes = scopes;
    }

    public void readFields(DataInput in) throws IOException {
        int numFamilies;
        int versionOrLength;
        this.kvs.clear();
        if (this.scopes != null) {
            this.scopes.clear();
        }
        Decoder decoder = this.codec.getDecoder((DataInputStream)in);
        int length = versionOrLength = in.readInt();
        if (versionOrLength == -1) {
            length = in.readInt();
        }
        for (int i = 0; i < length && decoder.advance(); ++i) {
            this.kvs.add(decoder.current());
        }
        if (versionOrLength == -1 && (numFamilies = in.readInt()) > 0) {
            if (this.scopes == null) {
                this.scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
            }
            for (int i = 0; i < numFamilies; ++i) {
                byte[] fam = Bytes.readByteArray(in);
                int scope = in.readInt();
                this.scopes.put(fam, scope);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        Encoder kvEncoder = this.codec.getEncoder((DataOutputStream)out);
        out.writeInt(-1);
        out.writeInt(this.kvs.size());
        for (KeyValue kv : this.kvs) {
            kvEncoder.write(kv);
        }
        kvEncoder.flush();
        if (this.scopes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.scopes.size());
            for (byte[] key : this.scopes.keySet()) {
                Bytes.writeByteArray(out, key);
                out.writeInt((Integer)this.scopes.get(key));
            }
        }
    }

    @Override
    public long heapSize() {
        long ret = 0L;
        for (KeyValue kv : this.kvs) {
            ret += kv.heapSize();
        }
        if (this.scopes != null) {
            ret += (long)ClassSize.TREEMAP;
            ret += (long)ClassSize.align(this.scopes.size() * ClassSize.MAP_ENTRY);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[#edits: " + this.kvs.size() + " = <");
        for (KeyValue kv : this.kvs) {
            sb.append(kv.toString());
            sb.append("; ");
        }
        if (this.scopes != null) {
            sb.append(" scopes: " + this.scopes.toString());
        }
        sb.append(">]");
        return sb.toString();
    }
}

