/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotTask;
import org.apache.hadoop.hbase.snapshot.TakeSnapshotUtils;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReferenceServerWALsTask
extends SnapshotTask {
    private static final Log LOG = LogFactory.getLog(ReferenceServerWALsTask.class);
    private final FileSystem fs;
    private final Configuration conf;
    private final String serverName;
    private Path logDir;

    public ReferenceServerWALsTask(HBaseProtos.SnapshotDescription snapshot, ForeignExceptionDispatcher failureListener, Path logDir, Configuration conf, FileSystem fs) {
        super(snapshot, failureListener);
        this.fs = fs;
        this.conf = conf;
        this.serverName = logDir.getName();
        this.logDir = logDir;
    }

    @Override
    public Void call() throws IOException, ForeignException {
        Object[] serverLogs = FSUtils.listStatus(this.fs, this.logDir, null);
        if (serverLogs == null) {
            LOG.debug((Object)("No logs for server directory:" + this.logDir + ", done referencing files."));
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding references for WAL files:" + Arrays.toString(serverLogs)));
        }
        for (Object file : serverLogs) {
            this.rethrowException();
            Path rootDir = FSUtils.getRootDir(this.conf);
            Path snapshotDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(this.snapshot, rootDir);
            Path snapshotLogDir = TakeSnapshotUtils.getSnapshotHLogsDir(snapshotDir, this.serverName);
            Path ref = new Path(snapshotLogDir, file.getPath().getName());
            if (!this.fs.createNewFile(ref) && !this.fs.exists(ref)) {
                throw new IOException("Couldn't create reference for:" + file.getPath());
            }
            LOG.debug((Object)("Completed WAL referencing for: " + file.getPath() + " to " + ref));
        }
        LOG.debug((Object)"Successfully completed WAL referencing for ALL files");
        return null;
    }
}

