/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift2.ThriftUtilities;
import org.apache.hadoop.hbase.thrift2.generated.TDelete;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.thrift2.generated.TIOError;
import org.apache.hadoop.hbase.thrift2.generated.TIllegalArgument;
import org.apache.hadoop.hbase.thrift2.generated.TIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TResult;
import org.apache.hadoop.hbase.thrift2.generated.TScan;
import org.apache.thrift.TException;

public class ThriftHBaseServiceHandler
implements THBaseService.Iface {
    private final HTablePool htablePool;
    private static final Log LOG = LogFactory.getLog(ThriftHBaseServiceHandler.class);
    private final AtomicInteger nextScannerId = new AtomicInteger(0);
    private final Map<Integer, ResultScanner> scannerMap = new ConcurrentHashMap<Integer, ResultScanner>();

    public static THBaseService.Iface newInstance(Configuration conf, ThriftMetrics metrics) {
        ThriftHBaseServiceHandler handler = new ThriftHBaseServiceHandler(conf);
        return (THBaseService.Iface)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{THBaseService.Iface.class}, (InvocationHandler)new THBaseServiceMetricsProxy(handler, metrics));
    }

    private static long now() {
        return System.nanoTime();
    }

    ThriftHBaseServiceHandler(Configuration conf) {
        this.htablePool = new HTablePool(conf, Integer.MAX_VALUE);
    }

    private HTableInterface getTable(byte[] tableName) {
        return this.htablePool.getTable(tableName);
    }

    private void closeTable(HTableInterface table) throws TIOError {
        try {
            table.close();
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    private TIOError getTIOError(IOException e) {
        TIOError err = new TIOError();
        err.setMessage(e.getMessage());
        return err;
    }

    private int addScanner(ResultScanner scanner) {
        int id = this.nextScannerId.getAndIncrement();
        this.scannerMap.put(id, scanner);
        return id;
    }

    private ResultScanner getScanner(int id) {
        return this.scannerMap.get(id);
    }

    protected ResultScanner removeScanner(int id) {
        return this.scannerMap.remove(id);
    }

    @Override
    public boolean exists(ByteBuffer table, TGet get2) throws TIOError, TException {
        HTableInterface htable = this.getTable(table.array());
        try {
            boolean bl = htable.exists(ThriftUtilities.getFromThrift(get2));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public TResult get(ByteBuffer table, TGet get2) throws TIOError, TException {
        HTableInterface htable = this.getTable(table.array());
        try {
            TResult tResult = ThriftUtilities.resultFromHBase(htable.get(ThriftUtilities.getFromThrift(get2)));
            return tResult;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public List<TResult> getMultiple(ByteBuffer table, List<TGet> gets) throws TIOError, TException {
        HTableInterface htable = this.getTable(table.array());
        try {
            List<TResult> list = ThriftUtilities.resultsFromHBase(htable.get(ThriftUtilities.getsFromThrift(gets)));
            return list;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public void put(ByteBuffer table, TPut put2) throws TIOError, TException {
        HTableInterface htable = this.getTable(table.array());
        try {
            htable.put(ThriftUtilities.putFromThrift(put2));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public boolean checkAndPut(ByteBuffer table, ByteBuffer row, ByteBuffer family, ByteBuffer qualifier, ByteBuffer value, TPut put2) throws TIOError, TException {
        HTableInterface htable = this.getTable(table.array());
        try {
            boolean bl = htable.checkAndPut(row.array(), family.array(), qualifier.array(), value == null ? null : value.array(), ThriftUtilities.putFromThrift(put2));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public void putMultiple(ByteBuffer table, List<TPut> puts) throws TIOError, TException {
        HTableInterface htable = this.getTable(table.array());
        try {
            htable.put(ThriftUtilities.putsFromThrift(puts));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public void deleteSingle(ByteBuffer table, TDelete deleteSingle2) throws TIOError, TException {
        HTableInterface htable = this.getTable(table.array());
        try {
            htable.delete(ThriftUtilities.deleteFromThrift(deleteSingle2));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public List<TDelete> deleteMultiple(ByteBuffer table, List<TDelete> deletes) throws TIOError, TException {
        HTableInterface htable = this.getTable(table.array());
        List<Delete> tempDeletes = ThriftUtilities.deletesFromThrift(deletes);
        try {
            htable.delete(tempDeletes);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
        return ThriftUtilities.deletesFromHBase(tempDeletes);
    }

    @Override
    public boolean checkAndDelete(ByteBuffer table, ByteBuffer row, ByteBuffer family, ByteBuffer qualifier, ByteBuffer value, TDelete deleteSingle2) throws TIOError, TException {
        HTableInterface htable = this.getTable(table.array());
        try {
            if (value == null) {
                boolean bl = htable.checkAndDelete(row.array(), family.array(), qualifier.array(), null, ThriftUtilities.deleteFromThrift(deleteSingle2));
                return bl;
            }
            boolean bl = htable.checkAndDelete(row.array(), family.array(), qualifier.array(), value.array(), ThriftUtilities.deleteFromThrift(deleteSingle2));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public TResult increment(ByteBuffer table, TIncrement increment2) throws TIOError, TException {
        HTableInterface htable = this.getTable(table.array());
        try {
            TResult tResult = ThriftUtilities.resultFromHBase(htable.increment(ThriftUtilities.incrementFromThrift(increment2)));
            return tResult;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public int openScanner(ByteBuffer table, TScan scan) throws TIOError, TException {
        HTableInterface htable = this.getTable(table.array());
        ResultScanner resultScanner = null;
        try {
            resultScanner = htable.getScanner(ThriftUtilities.scanFromThrift(scan));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
        return this.addScanner(resultScanner);
    }

    @Override
    public List<TResult> getScannerRows(int scannerId, int numRows) throws TIOError, TIllegalArgument, TException {
        ResultScanner scanner = this.getScanner(scannerId);
        if (scanner == null) {
            TIllegalArgument ex = new TIllegalArgument();
            ex.setMessage("Invalid scanner Id");
            throw ex;
        }
        try {
            return ThriftUtilities.resultsFromHBase(scanner.next(numRows));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public void closeScanner(int scannerId) throws TIOError, TIllegalArgument, TException {
        if (this.removeScanner(scannerId) == null) {
            TIllegalArgument ex = new TIllegalArgument();
            ex.setMessage("Invalid scanner Id");
            throw ex;
        }
    }

    private static class THBaseServiceMetricsProxy
    implements InvocationHandler {
        private final THBaseService.Iface handler;
        private final ThriftMetrics metrics;

        private THBaseServiceMetricsProxy(THBaseService.Iface handler, ThriftMetrics metrics) {
            this.handler = handler;
            this.metrics = metrics;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Object result;
            try {
                long start = ThriftHBaseServiceHandler.now();
                result = m.invoke((Object)this.handler, args);
                int processTime = (int)(ThriftHBaseServiceHandler.now() - start);
                this.metrics.incMethodTime(m.getName(), processTime);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
            }
            return result;
        }
    }
}

