/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.metrics.RegionServerMetrics;
import org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class RSStatusTmplImpl
extends AbstractTemplateImpl
implements RSStatusTmpl.Intf {
    private final HRegionServer regionServer;
    private final String filter;
    private final String format;

    protected static RSStatusTmpl.ImplData __jamon_setOptionalArguments(RSStatusTmpl.ImplData p_implData) {
        if (!p_implData.getFilter__IsNotDefault()) {
            p_implData.setFilter("general");
        }
        if (!p_implData.getFormat__IsNotDefault()) {
            p_implData.setFormat("html");
        }
        return p_implData;
    }

    public RSStatusTmplImpl(TemplateManager p_templateManager, RSStatusTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)RSStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.regionServer = p_implData.getRegionServer();
        this.filter = p_implData.getFilter();
        this.format = p_implData.getFormat();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        if (this.format.equals("json")) {
            jamonWriter.write("\n  ");
            TaskMonitorTmpl __jamon__var_4 = new TaskMonitorTmpl(this.getTemplateManager());
            __jamon__var_4.setFilter(this.filter);
            __jamon__var_4.setFormat("json");
            __jamon__var_4.renderNoFlush(jamonWriter);
            jamonWriter.write("\n  ");
            return;
        }
        jamonWriter.write("\n");
        HServerInfo serverInfo = null;
        ServerName serverName = null;
        try {
            serverInfo = this.regionServer.getHServerInfo();
            serverName = this.regionServer.getServerName();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RegionServerMetrics metrics = this.regionServer.getMetrics();
        List<HRegionInfo> onlineRegions = this.regionServer.getOnlineRegions();
        int interval = this.regionServer.getConfiguration().getInt("hbase.regionserver.msginterval", 3000) / 1000;
        int masterInfoPort = this.regionServer.getConfiguration().getInt("hbase.master.info.port", 60010);
        jamonWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!-- Commenting out DOCTYPE so our blue outline shows on hadoop 0.20.205.0, etc.\n     See tail of HBASE-2110 for explaination.\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> \n-->\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n<title>HBase Region Server: ");
        Escaping.HTML.write(StandardEmitter.valueOf((Object)serverName), jamonWriter);
        jamonWriter.write(":");
        Escaping.HTML.write(StandardEmitter.valueOf((int)serverInfo.getServerAddress().getPort()), jamonWriter);
        jamonWriter.write("</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hbase.css\" />\n</head>\n\n<body>\n<a id=\"logo\" href=\"http://wiki.apache.org/lucene-hadoop/Hbase\"><img src=\"/static/hbase_logo.png\" alt=\"HBase Logo\" title=\"HBase Logo\" /></a>\n<h1 id=\"page_title\">RegionServer: ");
        Escaping.HTML.write(StandardEmitter.valueOf((Object)serverName), jamonWriter);
        jamonWriter.write("</h1>\n<p id=\"links_menu\">\n  <a href=\"/logs/\">Local logs</a>,\n  <a href=\"/stacks\">Thread Dump</a>,\n  <a href=\"/logLevel\">Log Level</a>,\n  <a href=\"/dump\">Debug dump</a>,\n");
        if (HBaseConfiguration.isShowConfInServlet()) {
            jamonWriter.write("\n  <a href=\"/conf\">HBase Configuration</a>\n");
        }
        jamonWriter.write("\n</p>\n<hr id=\"head_rule\" />\n\n<h2>Attributes</h2>\n<table id=\"attributes_table\">\n<col style=\"width: 10%;\"/>\n<col />\n<col style=\"width: 20%;\"/>\n<tr><th>Attribute Name</th><th>Value</th><th>Description</th></tr>\n<tr><td>HBase Version</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", r");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td><td>HBase version and revision</td></tr>\n<tr><td>HBase Compiled</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td><td>When HBase version was compiled and by whom</td></tr>\n<tr><td>Metrics</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)metrics.toString()), jamonWriter);
        jamonWriter.write("</td><td>RegionServer Metrics; file and heap sizes are in megabytes</td></tr>\n<tr><td>Zookeeper Quorum</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.regionServer.getZooKeeper().getQuorum()), jamonWriter);
        jamonWriter.write("</td><td>Addresses of all registered ZK servers</td></tr>\n<tr>\n  <td>Coprocessors</td>\n  <td>\n    ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)Arrays.toString(this.regionServer.getCoprocessors())), jamonWriter);
        jamonWriter.write("\n  </td>\n  <td>Coprocessors currently loaded by this regionserver</td></tr>\n<tr><td>RS Start Time</td><td>");
        Escaping.HTML.write(StandardEmitter.valueOf((Object)new Date(this.regionServer.getStartcode())), jamonWriter);
        jamonWriter.write("</td><td>Date stamp of when this region server was started</td></tr>\n</tr>\n<tr><td>HBase Master</td><td>\n");
        if (masterInfoPort < 0) {
            jamonWriter.write("\nNo hbase.master.info.port found\n");
        } else {
            jamonWriter.write("\n");
            String host = this.regionServer.getMasterAddressManager().getMasterAddress().getHostname() + ":" + masterInfoPort;
            String url = "http://" + host + "/";
            jamonWriter.write("<a href=\"");
            Escaping.HTML.write(StandardEmitter.valueOf((String)url), jamonWriter);
            jamonWriter.write("\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)host), jamonWriter);
            jamonWriter.write("</a>\n");
        }
        jamonWriter.write("\n</td><td>Address of HBase Master</td></tr>\n</table>\n\n");
        TaskMonitorTmpl __jamon__var_5 = new TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_5.setFilter(this.filter);
        __jamon__var_5.renderNoFlush(jamonWriter);
        jamonWriter.write("\n\n<h2>Regions</h2>\n");
        if (onlineRegions != null && onlineRegions.size() > 0) {
            jamonWriter.write("\n<table>\n<tr><th>Region Name</th><th>Start Key</th><th>End Key</th><th>Metrics</th></tr>\n");
            Collections.sort(onlineRegions);
            for (HRegionInfo r : onlineRegions) {
                jamonWriter.write("\n");
                HServerLoad.RegionLoad load = this.regionServer.createRegionLoad(r.getEncodedName());
                jamonWriter.write("<tr><td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)r.getRegionNameAsString()), jamonWriter);
                jamonWriter.write("</td>\n    <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)Bytes.toStringBinary(r.getStartKey())), jamonWriter);
                jamonWriter.write("</td><td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)Bytes.toStringBinary(r.getEndKey())), jamonWriter);
                jamonWriter.write("</td>\n    <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)(load == null ? "null" : load.toString())), jamonWriter);
                jamonWriter.write("</td>\n    </tr>\n");
            }
            jamonWriter.write("\n</table>\n<p>Region names are made of the containing table's name, a comma,\nthe start key, a comma, and a randomly generated region id.  To illustrate,\nthe region named\n<em>domains,apache.org,5464829424211263407</em> is party to the table \n<em>domains</em>, has an id of <em>5464829424211263407</em> and the first key\nin the region is <em>apache.org</em>.  The <em>-ROOT-</em>\nand <em>.META.</em> 'tables' are internal sytem tables (or 'catalog' tables in db-speak).\nThe -ROOT- keeps a list of all regions in the .META. table.  The .META. table\nkeeps a list of all regions in the system. The empty key is used to denote\ntable start and table end.  A region with an empty start key is the first region in a table.\nIf region has both an empty start and an empty end key, its the only region in the table.  See\n<a href=\"http://hbase.org\">HBase Home</a> for further explication.<p>\n");
        } else {
            jamonWriter.write("\n<p>Not serving regions</p>\n");
        }
        jamonWriter.write("\n</body>\n</html>\n");
    }
}

