/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;

public class FSHDFSUtils
extends FSUtils {
    private static final Log LOG = LogFactory.getLog(FSHDFSUtils.class);
    public static final long LEASE_SOFTLIMIT_PERIOD = 60000L;
    public static final String TEST_TRIGGER_DFS_APPEND = "hbase.test.trigger.dfs.append";

    @Override
    public void recoverFileLease(FileSystem fs, Path p, Configuration conf) throws IOException {
        block19: {
            if (!FSHDFSUtils.isAppendSupported(conf)) {
                LOG.warn((Object)"Running on HDFS without append enabled may result in data loss");
                return;
            }
            if (!(fs instanceof DistributedFileSystem)) {
                return;
            }
            LOG.info((Object)("Recovering file " + p));
            long startWaiting = System.currentTimeMillis();
            boolean recovered = false;
            long recoveryTimeout = conf.getInt("hbase.lease.recovery.timeout", 300000);
            boolean triggerAppend = conf.getBoolean(TEST_TRIGGER_DFS_APPEND, false);
            int waitingPeriod = conf.getInt("hbase.lease.recovery.waiting.period", 4000);
            Exception ex = null;
            if (!recovered) {
                block18: {
                    try {
                        try {
                            DistributedFileSystem dfs = (DistributedFileSystem)fs;
                            if (triggerAppend) {
                                throw new IOException();
                            }
                            try {
                                recovered = (Boolean)DistributedFileSystem.class.getMethod("recoverLease", Path.class).invoke((Object)dfs, p);
                                if (!recovered) {
                                    LOG.debug((Object)"recoverLease returned false");
                                }
                            }
                            catch (InvocationTargetException ite) {
                                throw (IOException)ite.getCause();
                            }
                        }
                        catch (Exception e) {
                            LOG.debug((Object)("Failed fs.recoverLease invocation, " + e.toString() + ", trying fs.append instead"));
                            ex = e;
                        }
                        if (ex != null || System.currentTimeMillis() - startWaiting > recoveryTimeout) {
                            LOG.debug((Object)("trying fs.append for " + p + " with " + ex));
                            ex = null;
                            FSDataOutputStream out = fs.append(p);
                            out.close();
                            recovered = true;
                            LOG.debug((Object)"fs.append passed");
                        }
                        if (!recovered) break block18;
                        break block19;
                    }
                    catch (IOException e) {
                        e = RemoteExceptionHandler.checkIOException(e);
                        if (e instanceof AlreadyBeingCreatedException) {
                            long waitedFor = System.currentTimeMillis() - startWaiting;
                            if (waitedFor > 60000L) {
                                LOG.warn((Object)("Waited " + waitedFor + "ms for lease recovery on " + p + ":" + e.getMessage()));
                            }
                        }
                        if (e instanceof LeaseExpiredException && e.getMessage().contains("File does not exist")) {
                            throw new FileNotFoundException("The given HLog wasn't found at " + p.toString());
                        }
                        throw new IOException("Failed to open " + p + " for append", e);
                    }
                }
                try {
                    Thread.sleep(waitingPeriod);
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
        }
        LOG.info((Object)("Finished lease recovery attempt for " + p));
    }
}

