/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ClusterId {
    private ZooKeeperWatcher watcher;
    private Abortable abortable;
    private String id;

    public ClusterId(ZooKeeperWatcher watcher, Abortable abortable) {
        this.watcher = watcher;
        this.abortable = abortable;
    }

    public boolean hasId() {
        return this.getId() != null;
    }

    public String getId() {
        try {
            if (this.id == null) {
                this.id = ClusterId.readClusterIdZNode(this.watcher);
            }
        }
        catch (KeeperException ke) {
            this.abortable.abort("Unexpected exception from ZooKeeper reading cluster ID", ke);
        }
        return this.id;
    }

    public static String readClusterIdZNode(ZooKeeperWatcher watcher) throws KeeperException {
        byte[] data;
        if (ZKUtil.checkExists(watcher, watcher.clusterIdZNode) != -1 && (data = ZKUtil.getData(watcher, watcher.clusterIdZNode)) != null) {
            return Bytes.toString(data);
        }
        return null;
    }

    public static void setClusterId(ZooKeeperWatcher watcher, String id) throws KeeperException {
        ZKUtil.createSetData(watcher, watcher.clusterIdZNode, Bytes.toBytes(id));
    }
}

