/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.kafka7;

import com.bfd.crawler.kafka7.consts.KafkaConsts;
import com.bfd.crawler.kafka7.consumer.ConsumerGroup;
import java.util.concurrent.BlockingQueue;

public class KfkConsumer {
    public static void startReadThread(BlockingQueue<String> queue, String topic, int threadNumPerTopic, String groupId, int kafkaServerName) {
        if (!KafkaConsts.consumerGroupMap.containsKey(kafkaServerName + "#" + topic)) {
            ConsumerGroup consumerGroup = new ConsumerGroup(threadNumPerTopic, topic, groupId, queue, kafkaServerName);
            KafkaConsts.consumerGroupMap.put(kafkaServerName + "#" + topic, consumerGroup);
            consumerGroup.execute();
        } else {
            ConsumerGroup consumerGroup = KafkaConsts.consumerGroupMap.get(kafkaServerName + "#" + topic);
            consumerGroup.start();
        }
    }

    public static void stopKfkConsumerThreads() {
        for (ConsumerGroup consumerGroup : KafkaConsts.consumerGroupMap.values()) {
            consumerGroup.stop();
            consumerGroup.getConsumerThreadPool().shutdown();
            consumerGroup.getThreadPoolMonitor().setStopMonitor(true);
        }
    }

    public static void stopKfkConsumerThreads(int kafkaServerName, String topic) {
        if (KafkaConsts.consumerGroupMap.containsKey(kafkaServerName + "#" + topic)) {
            ConsumerGroup consumerGroup = KafkaConsts.consumerGroupMap.get(kafkaServerName + "#" + topic);
            consumerGroup.stop();
        }
    }

    public static int getkafkaConsumerNum(String topic) {
        int totalMessageNum = 0;
        if (KafkaConsts.consumerGroupMap.containsKey(topic)) {
            ConsumerGroup consumerGroup = KafkaConsts.consumerGroupMap.get(topic);
            totalMessageNum += consumerGroup.getConsumerNum();
        }
        return totalMessageNum;
    }
}

