/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.kafka7;

import com.bfd.crawler.kafka7.utils.PropertiesParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.RecordTooLargeException;

public class KfkProducer {
    private Producer<String, String> producer;
    private PropertiesParser pop;
    private String brokerList;
    private String acks;
    private String retries;
    private String batchSize;
    private String lingerMs;
    private String bufferMemory;
    private String maxRequestSize;
    public static Map<String, KfkProducer> KfkProducerMap = new HashMap<String, KfkProducer>();
    private int tatalNum;

    public static KfkProducer getInstance(int kafaServerName, String kafkaName) {
        if (KfkProducerMap.containsKey(kafaServerName + "#" + kafkaName)) {
            return KfkProducerMap.get(kafaServerName + "#" + kafkaName);
        }
        KfkProducer KfkProducer2 = new KfkProducer(kafaServerName);
        KfkProducerMap.put(kafaServerName + "#" + kafkaName, KfkProducer2);
        return KfkProducer2;
    }

    private KfkProducer(int kafkaServerName) {
        this.pop = new PropertiesParser("../etc/" + kafkaServerName + "_kafka.properties");
        this.brokerList = this.pop.getStringProperty("crawl.kfk.metadata.broker.list");
        this.acks = this.pop.getStringProperty("crawl.kfk.producer.acks");
        this.retries = this.pop.getStringProperty("crawl.kfk.producer.retries");
        this.batchSize = this.pop.getStringProperty("crawl.kfk.producer.batch.size");
        this.lingerMs = this.pop.getStringProperty("crawl.kfk.producer.linger.ms");
        this.bufferMemory = this.pop.getStringProperty("crawl.kfk.producer.buffer.memory");
        this.maxRequestSize = this.pop.getStringProperty("crawl.kfk.producer.max.request.size");
        this.tatalNum = 0;
        Properties prop = this.createProducerConfig();
        this.producer = new KafkaProducer(prop);
    }

    public Properties createProducerConfig() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList);
        props.put("acks", this.acks);
        props.put("retries", this.retries);
        props.put("batch.size", this.batchSize);
        props.put("linger.ms", this.lingerMs);
        props.put("buffer.memory", this.bufferMemory);
        props.put("max.request.size", this.maxRequestSize);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("replica.fetch.max.bytes", "104857600");
        props.put("fetch.message.max.bytes", "104857600");
        props.put("message.max.bytes", "104857600");
        return props;
    }

    public boolean send(String topic, String message) {
        while (!this.executeSend(topic, message)) {
            System.out.println("send message error!");
        }
        return true;
    }

    public boolean send(String topic, List<String> messages) {
        while (!this.executeSend(topic, messages)) {
            System.out.println("send message error!");
        }
        return true;
    }

    public boolean executeSend(String topic, String message) {
        if (StringUtils.isEmpty((CharSequence)topic) || StringUtils.isEmpty((CharSequence)message)) {
            System.out.println("before send msg get topic or message -> null, ");
            return true;
        }
        while (this.producer == null) {
            Properties prop = this.createProducerConfig();
            this.producer = new KafkaProducer(prop);
        }
        try {
            this.producer.send(new ProducerRecord(topic, (Object)message), new Callback(){

                public void onCompletion(RecordMetadata metadata, Exception e) {
                    if (e != null) {
                        if (e instanceof RecordTooLargeException) {
                            throw new RecordTooLargeException();
                        }
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            System.out.println("send data exception, err=" + e);
            if (e instanceof RecordTooLargeException) {
                return true;
            }
            this.close();
            return false;
        }
        return true;
    }

    public boolean executeSend(String topic, List<String> messages) {
        if (messages == null || messages.size() == 0) {
            System.out.println("before send msg get topic or message -> null, projName=");
            return true;
        }
        while (this.producer == null) {
            Properties prop = this.createProducerConfig();
            this.producer = new KafkaProducer(prop);
        }
        this.tatalNum += messages.size();
        try {
            for (String message : messages) {
                this.producer.send(new ProducerRecord(topic, (Object)message), new Callback(){

                    public void onCompletion(RecordMetadata metadata, Exception e) {
                        if (e != null) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            System.out.println(Thread.currentThread().getName() + ":topic is " + topic + ".message size is " + messages.size() + ".send data exception, err=" + e);
            this.close();
            return false;
        }
        return true;
    }

    public void close() {
        if (this.producer != null) {
            try {
                this.producer.close();
                System.out.println("Producter closed!");
            }
            catch (Exception e) {
                System.out.println("close producter exception, err=" + e);
            }
            finally {
                this.producer = null;
            }
        }
    }

    private int getKafkaTotalNum() {
        return this.tatalNum;
    }
}

