/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.kafka7.consumer;

import com.bfd.crawler.kafka7.utils.PropertiesParser;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaException;

public class ConsumerThread
implements Runnable {
    private final KafkaConsumer<String, String> consumer;
    private String topic;
    private String groupId;
    private boolean stop;
    private BlockingQueue<String> queue;
    private String brokerList;
    private String autoCommit;
    private String intervalMs;
    private String timeoutMs;
    private String reset;
    private int messageNum;

    public ConsumerThread(BlockingQueue<String> queue, String topic, String groupId, boolean stop, int kafkaServerName, PropertiesParser propar) {
        this.brokerList = propar.getStringProperty("crawl.kfk.metadata.broker.list");
        this.autoCommit = propar.getStringProperty("crawl.kfk.consumer.enable.auto.commit");
        this.intervalMs = propar.getStringProperty("crawl.kfk.consumer.auto.commit.interval.ms");
        this.timeoutMs = propar.getStringProperty("crawl.kfk.consumer.session.timeout.ms");
        this.reset = propar.getStringProperty("crawl.kfk.consumer.auto.offset.reset");
        this.queue = queue;
        this.topic = topic;
        this.groupId = groupId;
        this.stop = stop;
        Properties prop = this.createConsumerConfig();
        this.consumer = new KafkaConsumer(prop);
        this.consumer.subscribe(Arrays.asList(this.topic));
    }

    private Properties createConsumerConfig() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList);
        props.put("group.id", this.groupId);
        props.put("enable.auto.commit", this.autoCommit);
        props.put("auto.commit.interval.ms", this.intervalMs);
        props.put("session.timeout.ms", this.timeoutMs);
        props.put("auto.offset.reset", this.reset);
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        return props;
    }

    public String toString() {
        return "ConsumerThread{topic='" + this.topic + '\'' + ", stop=" + this.stop + '}';
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                ConsumerRecords records = this.consumer.poll(60000L);
                this.messageNum += records.count();
                for (ConsumerRecord record : records) {
                    try {
                        this.queue.put((String)record.value());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (KafkaException e) {
                System.out.println("The Exception is :" + (Object)((Object)e));
            }
        }
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public int getMessageNum() {
        return this.messageNum;
    }
}

