/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.nlp.common.util.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashSet<E>
extends AbstractSet<E>
implements Set<E> {
    private final Map<E, Boolean> map;
    private transient Set<E> keys;

    public ConcurrentHashSet() {
        this.map = new ConcurrentHashMap<E, Boolean>();
        this.keys = this.map.keySet();
    }

    public ConcurrentHashSet(int initialCapacity) {
        this.map = new ConcurrentHashMap<E, Boolean>(initialCapacity);
        this.keys = this.map.keySet();
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.keys.iterator();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.keys.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.keys.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.keys.retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.keys.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.keys.toArray(a);
    }

    @Override
    public boolean equals(Object o) {
        return o == this || this.keys.equals(o);
    }

    @Override
    public int hashCode() {
        return this.keys.hashCode();
    }

    @Override
    public String toString() {
        return this.keys.toString();
    }
}

