/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.nlp.common.util.encryption;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PasswordEncoder {
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private Object salt;
    private String algorithm;

    public PasswordEncoder(Object salt, String algorithm) {
        this.salt = salt;
        this.algorithm = algorithm;
    }

    public String encode(String rawPass) {
        String result = null;
        try {
            MessageDigest md = MessageDigest.getInstance(this.algorithm);
            result = PasswordEncoder.byteArrayToHexString(md.digest(this.mergePasswordAndSalt(rawPass).getBytes("utf-8")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean isPasswordValid(String encPass, String rawPass) {
        String pass1 = "" + encPass;
        String pass2 = this.encode(rawPass);
        return pass1.equals(pass2);
    }

    private String mergePasswordAndSalt(String password) {
        if (password == null) {
            password = "";
        }
        if (this.salt == null || "".equals(this.salt)) {
            return password;
        }
        return password + "{" + this.salt.toString() + "}";
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(PasswordEncoder.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    public static String encryptPBKDF2(String msg) {
        try {
            int iterations = 20000;
            char[] chars = msg.toCharArray();
            byte[] salt = PasswordEncoder.getSalt().getBytes();
            PBEKeySpec spec = new PBEKeySpec(chars, salt, iterations, 512);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] hash = skf.generateSecret(spec).getEncoded();
            return iterations + PasswordEncoder.toHex(salt) + PasswordEncoder.toHex(hash);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String toHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }

    private static String getSaltSHA1() {
        byte[] salt = new byte[16];
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            sr.nextBytes(salt);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return salt.toString();
    }

    private static String getSalt() {
        byte[] salt = new byte[16];
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG", "SUN");
            sr.nextBytes(salt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return salt.toString();
    }

    public static void main(String[] args) {
        String salt = "helloworld";
        PasswordEncoder encoderMd5 = new PasswordEncoder(salt, "MD5");
        String encode = encoderMd5.encode("test");
        System.out.println(encode);
        System.out.println(encoderMd5.mergePasswordAndSalt("test"));
        boolean passwordValid = encoderMd5.isPasswordValid("083a8db3ff5b9b4ece3ef2bde03226c8", "test");
        System.out.println(passwordValid);
        PasswordEncoder encoderSha = new PasswordEncoder(salt, "SHA");
        String pass2 = encoderSha.encode("test");
        System.out.println(pass2);
        boolean passwordValid2 = encoderSha.isPasswordValid("1e4346dcb54c1444e91668e04b8ca4f74f42958e", "test");
        System.out.println(passwordValid2);
        System.out.println("PBKDF2 - > 123456\n" + PasswordEncoder.encryptPBKDF2("123456"));
    }
}

