/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.tmptask.newscrawl.formatTime;

import com.bfd.crawler.tmptask.newscrawl.formatTime.TimeRegexRule;
import com.bfd.crawler.utils.MyDateUtil;
import com.bfd.crawler.utils.MyStringUtil;
import com.bfd.crawler.utils.ParserException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class FormatTime {
    public static String parseDate(String cid, String dateStr) {
        if ("Ccnblogs".equals(cid)) {
            return FormatTime.getDateForCnblog(dateStr);
        }
        if ("infoq".equals(cid)) {
            return FormatTime.getDateForInfoq(dateStr);
        }
        if ("Ctheregister".equals(cid)) {
            return FormatTime.getDateFortheregister(dateStr);
        }
        if ("Copensource".equals(cid)) {
            return FormatTime.getDateForOpenSource(dateStr);
        }
        return FormatTime.getDateForLightReading(dateStr);
    }

    public static String getDateForCnblog(String dateStr) {
        dateStr = dateStr.trim().replace("\u53d1\u5e03\u4e8e ", "");
        String date = "";
        String[] str = dateStr.split("\\s+");
        date = str[0];
        return date;
    }

    public static String getDate2(String dateStr) {
        try {
            String rs = MyStringUtil.getRegexGroup(TimeRegexRule.getTimeregex, dateStr, 1);
            if (rs.trim().length() > 0) {
                return rs;
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getDateForInfoq(String dateStr) {
        String date = "";
        try {
            date = MyStringUtil.getRegexGroup("((\\d+)\\s*\u5e74)?(\\d+)\\s*\u6708(\\d+)\\s*\u65e5", dateStr, 2) + "-" + MyStringUtil.getRegexGroup("((\\d+)\\s*\u5e74)?(\\d+)\\s*\u6708(\\d+)\\s*\u65e5", dateStr, 3) + "-" + MyStringUtil.getRegexGroup("((\\d+)\\s*\u5e74)?(\\d+)\\s*\u6708(\\d+)\\s*\u65e5", dateStr, 4);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getDateFortheregister(String datestr) {
        if (datestr.indexOf("at") < 0) {
            System.out.println("datestr no at :" + datestr);
        }
        datestr = datestr.substring(0, datestr.indexOf("at"));
        String date = "";
        SimpleDateFormat sdf2 = new SimpleDateFormat("d MMM yyyy", Locale.ENGLISH);
        try {
            Date datelong = sdf2.parse(datestr);
            date = MyDateUtil.getStr(datelong, "yyyy-MM-dd");
            System.out.println(datelong);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getDateForOpenSource(String datestr) {
        if (datestr.indexOf("by") < 0) {
            System.out.println("datestr no at :" + datestr);
        }
        datestr = datestr.substring(0, datestr.indexOf("by"));
        String date = "";
        SimpleDateFormat sdf2 = new SimpleDateFormat("d MMM yyyy", Locale.ENGLISH);
        try {
            Date datelong = sdf2.parse(datestr.trim());
            date = MyDateUtil.getStr(datelong, "yyyy-MM-dd");
            System.out.println(datelong);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getDateForLightReading(String datestr) {
        String date = "";
        SimpleDateFormat sdf2 = new SimpleDateFormat("MM/dd/yyyy", Locale.ENGLISH);
        try {
            Date datelong = sdf2.parse(datestr);
            date = MyDateUtil.getStr(datelong, "yyyy-MM-dd");
            System.out.println(datelong);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static void main(String[] args) {
        String dateStr = "\n  \u4f5c\u8005\n  \n   \n  \n  \n\n        \n        \u53d1\u5e03\u4e8e\n        2012\u5e748\u670827\u65e5\n        ";
        System.out.println(FormatTime.getDateForInfoq(dateStr));
    }
}

